/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.Bag;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.policy.FunctionArgumentAttributeValue;
import org.apache.openaz.xacml.pdp.policy.FunctionDefinition;
import org.apache.openaz.xacml.pdp.std.StdFunctionDefinitionFactory;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionHigherOrderBag<O, I>
extends FunctionDefinitionBase<O, I> {
    private OPERATION operation;

    public FunctionDefinitionHigherOrderBag(Identifier idIn, DataType<O> dataTypeIn, DataType<I> dataTypeArgsIn, OPERATION opIn) {
        super(idIn, dataTypeIn, dataTypeArgsIn, opIn == OPERATION.MAP);
        this.operation = opIn;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        FunctionArgument functionIdArgument;
        if (arguments == null || arguments.size() < 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected at least 2 arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        if (this.operation == OPERATION.ALL_OF_ANY || this.operation == OPERATION.ANY_OF_ALL || this.operation == OPERATION.ALL_OF_ALL) {
            if (arguments.size() != 3) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected 3 arguments, got " + arguments.size()));
            }
            if (arguments.get(1) == null || !arguments.get(1).isBag()) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " 2nd argument must be bag, got '" + (arguments.get(1) == null ? "null" : this.getShortDataTypeId(arguments.get(1).getValue().getDataTypeId())) + "'"));
            }
            if (arguments.get(2) == null || !arguments.get(2).isBag()) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " 3rd argument must be bag, got '" + (arguments.get(2) == null ? "null" : this.getShortDataTypeId(arguments.get(2).getValue().getDataTypeId())) + "'"));
            }
        }
        if ((functionIdArgument = arguments.get(0)) == null || functionIdArgument.getValue() == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate Function (first argument) was null"));
        }
        if (!functionIdArgument.getValue().getDataTypeId().equals((Object)DataTypes.DT_ANYURI.getId())) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " First argument expected URI, got " + functionIdArgument.getValue().getDataTypeId()));
        }
        StdFunctionDefinitionFactory fdf = new StdFunctionDefinitionFactory();
        IdentifierImpl functionId = new IdentifierImpl((URI)functionIdArgument.getValue().getValue());
        FunctionDefinition predicate = fdf.getFunctionDefinition((Identifier)functionId);
        if (predicate == null) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " First argument was not URI of a function, got '" + functionId + "'"));
        }
        if (this.operation != OPERATION.MAP && !predicate.getDataTypeId().equals((Object)DataTypes.DT_BOOLEAN.getId())) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate Function must return boolean, but '" + predicate.getId() + "' returns '" + this.getShortDataTypeId(predicate.getDataTypeId())));
        }
        boolean bagSeen = false;
        for (int i = 1; i < arguments.size(); ++i) {
            FunctionArgument argument = arguments.get(i);
            if (argument == null) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null argument at index " + i));
            }
            if (!argument.getStatus().isOk()) {
                return ExpressionResult.newError(this.getFunctionStatus(argument.getStatus()));
            }
            if (argument.isBag()) {
                bagSeen = true;
                continue;
            }
            if (argument.getValue() != null && argument.getValue().getValue() != null) continue;
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Got null attribute at index " + i));
        }
        if (!bagSeen && this.operation != OPERATION.ANY_OF_ANY) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Did not get any Bag argument; must have at least 1"));
        }
        ArrayList<FunctionArgument> predicateArguments = new ArrayList<FunctionArgument>();
        int indexOfBagInOriginalArgs = -1;
        switch (this.operation) {
            case ANY_OF: {
                for (int i = 1; i < arguments.size(); ++i) {
                    predicateArguments.add(arguments.get(i));
                    if (!arguments.get(i).isBag()) continue;
                    if (indexOfBagInOriginalArgs == -1) {
                        indexOfBagInOriginalArgs = i;
                        continue;
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " must have only 1 bag; found one at index " + indexOfBagInOriginalArgs + " and another at " + i));
                }
                Iterator<AttributeValue<?>> bagIterator1 = arguments.get(indexOfBagInOriginalArgs).getBag().getAttributeValues();
                while (bagIterator1.hasNext()) {
                    predicateArguments.set(indexOfBagInOriginalArgs - 1, new FunctionArgumentAttributeValue(bagIterator1.next()));
                    ExpressionResult res = predicate.evaluate(evaluationContext, predicateArguments);
                    if (!res.isOk()) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + res.getStatus().getStatusMessage()));
                    }
                    if ((Boolean)res.getValue().getValue() != Boolean.TRUE) continue;
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case ALL_OF: {
                for (int i = 1; i < arguments.size(); ++i) {
                    predicateArguments.add(arguments.get(i));
                    if (!arguments.get(i).isBag()) continue;
                    if (indexOfBagInOriginalArgs == -1) {
                        indexOfBagInOriginalArgs = i;
                        continue;
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " must have only 1 bag; found one at index " + indexOfBagInOriginalArgs + " and another at " + i));
                }
                Iterator<AttributeValue<?>> bagIterator1 = arguments.get(indexOfBagInOriginalArgs).getBag().getAttributeValues();
                while (bagIterator1.hasNext()) {
                    predicateArguments.set(indexOfBagInOriginalArgs - 1, new FunctionArgumentAttributeValue(bagIterator1.next()));
                    ExpressionResult res = predicate.evaluate(evaluationContext, predicateArguments);
                    if (!res.isOk()) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + res.getStatus().getStatusMessage()));
                    }
                    if ((Boolean)res.getValue().getValue() != Boolean.FALSE) continue;
                    return ER_FALSE;
                }
                return ER_TRUE;
            }
            case ANY_OF_ANY: {
                for (int i = 1; i < arguments.size(); ++i) {
                    if (!arguments.get(i).isBag() || arguments.get(i).getBag().size() != 0) continue;
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Bag is empty at index " + i));
                }
                ArrayList<List<FunctionArgument>> listOfPredicateLists = new ArrayList<List<FunctionArgument>>();
                FunctionDefinitionHigherOrderBag.appendCrossProduct(new ArrayList<FunctionArgument>(), arguments.subList(1, arguments.size()), 0, listOfPredicateLists);
                for (List list : listOfPredicateLists) {
                    ExpressionResult res = predicate.evaluate(evaluationContext, list);
                    if (!res.isOk()) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + res.getStatus().getStatusMessage()));
                    }
                    if ((Boolean)res.getValue().getValue() != Boolean.TRUE) continue;
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case ALL_OF_ANY: {
                Iterator<AttributeValue<?>> bagIterator2 = arguments.get(2).getBag().getAttributeValues();
                while (bagIterator2.hasNext()) {
                    FunctionArgumentAttributeValue predicateArgument2 = new FunctionArgumentAttributeValue(bagIterator2.next());
                    boolean bl = true;
                    Iterator<AttributeValue<?>> bagIterator1 = arguments.get(1).getBag().getAttributeValues();
                    while (bagIterator1.hasNext()) {
                        predicateArguments.clear();
                        predicateArguments.add(new FunctionArgumentAttributeValue(bagIterator1.next()));
                        predicateArguments.add(predicateArgument2);
                        ExpressionResult res = predicate.evaluate(evaluationContext, predicateArguments);
                        if (!res.isOk()) {
                            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + res.getStatus().getStatusMessage()));
                        }
                        if ((Boolean)res.getValue().getValue() != Boolean.FALSE) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case ANY_OF_ALL: {
                Iterator<AttributeValue<?>> bagIterator1 = arguments.get(1).getBag().getAttributeValues();
                while (bagIterator1.hasNext()) {
                    FunctionArgumentAttributeValue predicateArgument1 = new FunctionArgumentAttributeValue(bagIterator1.next());
                    boolean bl = true;
                    Iterator<AttributeValue<?>> bagIterator2 = arguments.get(2).getBag().getAttributeValues();
                    while (bagIterator2.hasNext()) {
                        predicateArguments.clear();
                        predicateArguments.add(predicateArgument1);
                        predicateArguments.add(new FunctionArgumentAttributeValue(bagIterator2.next()));
                        ExpressionResult res = predicate.evaluate(evaluationContext, predicateArguments);
                        if (!res.isOk()) {
                            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + res.getStatus().getStatusMessage()));
                        }
                        if ((Boolean)res.getValue().getValue() != Boolean.FALSE) continue;
                        bl = false;
                        break;
                    }
                    if (!bl) continue;
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case ALL_OF_ALL: {
                Iterator<AttributeValue<?>> bagIterator1 = arguments.get(1).getBag().getAttributeValues();
                while (bagIterator1.hasNext()) {
                    FunctionArgumentAttributeValue predicateArgument1 = new FunctionArgumentAttributeValue(bagIterator1.next());
                    Iterator<AttributeValue<?>> bagIterator2 = arguments.get(2).getBag().getAttributeValues();
                    while (bagIterator2.hasNext()) {
                        predicateArguments.clear();
                        predicateArguments.add(predicateArgument1);
                        predicateArguments.add(new FunctionArgumentAttributeValue(bagIterator2.next()));
                        ExpressionResult expressionResult = predicate.evaluate(evaluationContext, predicateArguments);
                        if (!expressionResult.isOk()) {
                            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + expressionResult.getStatus().getStatusMessage()));
                        }
                        if ((Boolean)expressionResult.getValue().getValue() != Boolean.FALSE) continue;
                        return ER_FALSE;
                    }
                }
                return ER_TRUE;
            }
            case MAP: {
                for (int i = 1; i < arguments.size(); ++i) {
                    predicateArguments.add(arguments.get(i));
                    if (!arguments.get(i).isBag()) continue;
                    if (indexOfBagInOriginalArgs == -1) {
                        indexOfBagInOriginalArgs = i;
                        continue;
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " must have only 1 bag; found one at index " + indexOfBagInOriginalArgs + " and another at " + i));
                }
                Bag outputBag = new Bag();
                Iterator<AttributeValue<?>> bagIterator1 = arguments.get(indexOfBagInOriginalArgs).getBag().getAttributeValues();
                while (bagIterator1.hasNext()) {
                    predicateArguments.set(indexOfBagInOriginalArgs - 1, new FunctionArgumentAttributeValue(bagIterator1.next()));
                    ExpressionResult expressionResult = predicate.evaluate(evaluationContext, predicateArguments);
                    if (!expressionResult.isOk()) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Predicate error: " + expressionResult.getStatus().getStatusMessage()));
                    }
                    if (expressionResult.isBag()) {
                        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Cannot put bag inside bag; predicate was '" + predicate.getId() + "'"));
                    }
                    outputBag.add(expressionResult.getValue());
                }
                return ExpressionResult.newBag(outputBag);
            }
        }
        return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Could not evaluate Higher-Order Bag function " + (Object)((Object)this.operation)));
    }

    private static void appendCrossProduct(List<FunctionArgument> argListInProgress, List<FunctionArgument> valueList, int nPosition, List<List<FunctionArgument>> listArgLists) {
        if (nPosition >= valueList.size()) {
            ArrayList<FunctionArgument> copy = new ArrayList<FunctionArgument>();
            copy.addAll(argListInProgress);
            listArgLists.add(copy);
            return;
        }
        FunctionArgument FunctionArgument2 = valueList.get(nPosition);
        if (FunctionArgument2.isBag() && FunctionArgument2.getBag().getAttributeValues() != null && FunctionArgument2.getBag().size() > 0) {
            Iterator<AttributeValue<?>> iterBagValues = FunctionArgument2.getBag().getAttributeValues();
            while (iterBagValues.hasNext()) {
                AttributeValue<?> attributeValue = iterBagValues.next();
                FunctionArgumentAttributeValue functionArgument = new FunctionArgumentAttributeValue(attributeValue);
                argListInProgress.add(functionArgument);
                FunctionDefinitionHigherOrderBag.appendCrossProduct(argListInProgress, valueList, nPosition + 1, listArgLists);
                argListInProgress.remove(argListInProgress.size() - 1);
            }
        } else {
            argListInProgress.add(FunctionArgument2);
            FunctionDefinitionHigherOrderBag.appendCrossProduct(argListInProgress, valueList, nPosition + 1, listArgLists);
            argListInProgress.remove(argListInProgress.size() - 1);
        }
    }

    public static enum OPERATION {
        ANY_OF,
        ALL_OF,
        ANY_OF_ANY,
        ALL_OF_ANY,
        ANY_OF_ALL,
        ALL_OF_ALL,
        MAP;

    }
}

