/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;

public class FunctionDefinitionNumberTypeConversion<O extends Number, I extends Number>
extends FunctionDefinitionHomogeneousSimple<O, I> {
    public FunctionDefinitionNumberTypeConversion(Identifier idIn, DataType<O> outputType, DataType<I> argType) {
        super(idIn, outputType, argType, 1);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        ExpressionResult expressionResult;
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        try {
            if (((Number)convertedArguments.get(0)).getClass() == BigInteger.class) {
                StdAttributeValue doubleResult = new StdAttributeValue(XACML.ID_DATATYPE_DOUBLE, (Object)new Double(((BigInteger)convertedArguments.get(0)).toString()));
                expressionResult = ExpressionResult.newSingle(doubleResult);
            } else {
                StdAttributeValue integerResult = new StdAttributeValue(XACML.ID_DATATYPE_INTEGER, (Object)BigInteger.valueOf(((Double)convertedArguments.get(0)).intValue()));
                expressionResult = ExpressionResult.newSingle(integerResult);
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
        }
        return expressionResult;
    }
}

