/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.math.BigInteger;
import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.ConvertedArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionBase;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;

public class FunctionDefinitionStringFunctions<O, I>
extends FunctionDefinitionBase<O, I> {
    private final OPERATION operation;

    public FunctionDefinitionStringFunctions(Identifier idIn, DataType<O> dataTypeIn, DataType<I> dataTypeArgsIn, OPERATION op) {
        super(idIn, dataTypeIn, dataTypeArgsIn, false);
        this.operation = op;
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        ConvertedArgument convertedArgument0;
        FunctionArgument functionArgument;
        if (arguments == null || this.operation == OPERATION.CONCATENATE && arguments.size() < 2 || this.operation == OPERATION.SUBSTRING && arguments.size() != 3 || this.operation != OPERATION.SUBSTRING && this.operation != OPERATION.CONCATENATE && arguments.size() != 2) {
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " Expected " + (this.operation == OPERATION.SUBSTRING ? Integer.valueOf(3) : (this.operation == OPERATION.CONCATENATE ? "2 or more " : Integer.valueOf(2))) + " arguments, got " + (arguments == null ? "null" : Integer.valueOf(arguments.size()))));
        }
        ExpressionResult expressionResult = null;
        String firstArgumentAsString = null;
        String secondArgumentAsString = null;
        Integer secondArgumentAsInteger = null;
        Integer thirdArgumentAsInteger = null;
        if (this.operation == OPERATION.CONCATENATE) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < arguments.size(); ++i) {
                FunctionArgument functionArgument2 = arguments.get(i);
                ConvertedArgument convertedArgument = new ConvertedArgument(functionArgument2, this.getDataTypeArgs(), false);
                if (!convertedArgument.isOk()) {
                    return ExpressionResult.newError(this.getFunctionStatus(convertedArgument.getStatus()));
                }
                try {
                    String argumentAsString = this.getDataTypeArgs().toStringValue(convertedArgument.getValue());
                    builder.append(argumentAsString);
                    continue;
                }
                catch (DataTypeException e) {
                    String message = e.getMessage();
                    if (e.getCause() != null) {
                        message = e.getCause().getMessage();
                    }
                    return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
                }
            }
            StdAttributeValue stringResult = new StdAttributeValue(XACML.ID_DATATYPE_STRING, (Object)builder.toString());
            expressionResult = ExpressionResult.newSingle(stringResult);
            return expressionResult;
        }
        if (this.operation == OPERATION.SUBSTRING) {
            functionArgument = arguments.get(0);
            convertedArgument0 = new ConvertedArgument(functionArgument, this.getDataTypeArgs(), false);
            if (!convertedArgument0.isOk()) {
                return ExpressionResult.newError(this.getFunctionStatus(convertedArgument0.getStatus()));
            }
            try {
                firstArgumentAsString = this.getDataTypeArgs().toStringValue(convertedArgument0.getValue());
            }
            catch (DataTypeException e) {
                String message = e.getMessage();
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
            }
            functionArgument = arguments.get(1);
            ConvertedArgument convertedArgumentInt = new ConvertedArgument(functionArgument, DataTypes.DT_INTEGER, false);
            if (!convertedArgumentInt.isOk()) {
                return ExpressionResult.newError(this.getFunctionStatus(convertedArgumentInt.getStatus()));
            }
            secondArgumentAsInteger = ((BigInteger)convertedArgumentInt.getValue()).intValue();
            if (secondArgumentAsInteger < 0 || secondArgumentAsInteger > firstArgumentAsString.length()) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + "Start point '" + secondArgumentAsInteger + "' out of range 0-" + firstArgumentAsString.length() + " for string='" + firstArgumentAsString + "'"));
            }
            functionArgument = arguments.get(2);
            convertedArgumentInt = new ConvertedArgument(functionArgument, DataTypes.DT_INTEGER, false);
            if (!convertedArgumentInt.isOk()) {
                return ExpressionResult.newError(this.getFunctionStatus(convertedArgumentInt.getStatus()));
            }
            thirdArgumentAsInteger = ((BigInteger)convertedArgumentInt.getValue()).intValue();
            if (thirdArgumentAsInteger < -1 || thirdArgumentAsInteger > firstArgumentAsString.length()) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + "End point '" + thirdArgumentAsInteger + "' out of range 0-" + firstArgumentAsString.length() + " for string='" + firstArgumentAsString + "'"));
            }
            if (thirdArgumentAsInteger != -1 && thirdArgumentAsInteger < secondArgumentAsInteger) {
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + "End point '" + thirdArgumentAsInteger + "' less than start point '" + secondArgumentAsString + "'" + " for string='" + firstArgumentAsString + "'"));
            }
        } else {
            functionArgument = arguments.get(0);
            convertedArgument0 = new ConvertedArgument(functionArgument, DataTypes.DT_STRING, false);
            if (!convertedArgument0.isOk()) {
                return ExpressionResult.newError(this.getFunctionStatus(convertedArgument0.getStatus()));
            }
            firstArgumentAsString = (String)convertedArgument0.getValue();
            functionArgument = arguments.get(1);
            ConvertedArgument convertedArgument1 = new ConvertedArgument(functionArgument, this.getDataTypeArgs(), false);
            if (!convertedArgument1.isOk()) {
                return ExpressionResult.newError(this.getFunctionStatus(convertedArgument1.getStatus()));
            }
            try {
                secondArgumentAsString = this.getDataTypeArgs().toStringValue(convertedArgument1.getValue());
            }
            catch (DataTypeException e) {
                String message = e.getMessage();
                if (e.getCause() != null) {
                    message = e.getCause().getMessage();
                }
                return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message + " " + message));
            }
        }
        switch (this.operation) {
            case STARTS_WITH: {
                if (secondArgumentAsString.startsWith(firstArgumentAsString)) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case ENDS_WITH: {
                if (secondArgumentAsString.endsWith(firstArgumentAsString)) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case CONTAINS: {
                if (secondArgumentAsString.contains(firstArgumentAsString)) {
                    return ER_TRUE;
                }
                return ER_FALSE;
            }
            case SUBSTRING: {
                String substring = null;
                substring = thirdArgumentAsInteger == -1 ? firstArgumentAsString.substring(secondArgumentAsInteger) : firstArgumentAsString.substring(secondArgumentAsInteger, thirdArgumentAsInteger);
                StdAttributeValue stringResult = new StdAttributeValue(XACML.ID_DATATYPE_STRING, (Object)substring);
                expressionResult = ExpressionResult.newSingle(stringResult);
            }
        }
        return expressionResult;
    }

    public static enum OPERATION {
        CONCATENATE,
        STARTS_WITH,
        ENDS_WITH,
        CONTAINS,
        SUBSTRING;

    }
}

