/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.pdp.std.functions;

import java.util.ArrayList;
import java.util.List;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.pdp.eval.EvaluationContext;
import org.apache.openaz.xacml.pdp.policy.ExpressionResult;
import org.apache.openaz.xacml.pdp.policy.FunctionArgument;
import org.apache.openaz.xacml.pdp.std.functions.FunctionDefinitionHomogeneousSimple;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.ISO8601Time;

public class FunctionDefinitionTimeInRange<I>
extends FunctionDefinitionHomogeneousSimple<Boolean, I> {
    public FunctionDefinitionTimeInRange(Identifier idIn, DataType<I> dataTypeArgsIn) {
        super(idIn, DataTypes.DT_BOOLEAN, dataTypeArgsIn, 3);
    }

    @Override
    public ExpressionResult evaluate(EvaluationContext evaluationContext, List<FunctionArgument> arguments) {
        int compareResultHigh;
        int compareResultLow;
        ArrayList convertedArguments = new ArrayList();
        Status status = this.validateArguments(arguments, convertedArguments);
        if (!status.getStatusCode().equals((Object)StdStatusCode.STATUS_CODE_OK)) {
            return ExpressionResult.newError(this.getFunctionStatus(status));
        }
        try {
            compareResultLow = ((ISO8601Time)convertedArguments.get(1)).compareTo((ISO8601Time)convertedArguments.get(0));
            compareResultHigh = ((ISO8601Time)convertedArguments.get(2)).compareTo((ISO8601Time)convertedArguments.get(0));
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (e.getCause() != null) {
                message = e.getCause().getMessage();
            }
            return ExpressionResult.newError((Status)new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR, this.getShortFunctionId() + " " + message));
        }
        if (compareResultLow <= 0 && compareResultHigh >= 0) {
            return ER_TRUE;
        }
        return ER_FALSE;
    }
}

