/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.api;

public enum Decision {
    PERMIT("Permit"),
    DENY("Deny"),
    INDETERMINATE("Indeterminate"),
    INDETERMINATE_PERMIT("Indeterminate{P}", true, INDETERMINATE),
    INDETERMINATE_DENY("Indeterminate{D}", true, INDETERMINATE),
    INDETERMINATE_DENYPERMIT("Indeterminate{DP}", true, INDETERMINATE),
    NOTAPPLICABLE("NotApplicable");

    private String name;
    private boolean extended;
    private Decision basicDecision;

    private Decision(String nameIn, Boolean extendedIn, Decision basicDecisionIn) {
        this.name = nameIn;
        this.extended = extendedIn;
        this.basicDecision = basicDecisionIn;
    }

    private Decision(String nameIn) {
        this(nameIn, false, null);
    }

    public boolean isExtended() {
        return this.extended;
    }

    public Decision getBasicDecision() {
        return this.isExtended() ? this.basicDecision : this;
    }

    public static Decision get(String decisionName) {
        for (Decision decision : Decision.values()) {
            if (!decision.toString().equalsIgnoreCase(decisionName)) continue;
            return decision;
        }
        return null;
    }

    public String toString() {
        return this.name;
    }
}

