/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableAdvice
implements Advice {
    private static final List<AttributeAssignment> EMPTY_ATTRIBUTE_ASSIGNMENTS = Collections.unmodifiableList(new ArrayList());
    private Identifier id;
    private List<AttributeAssignment> attributeAssignments = EMPTY_ATTRIBUTE_ASSIGNMENTS;

    public StdMutableAdvice() {
    }

    public StdMutableAdvice(Identifier idIn, Collection<AttributeAssignment> attributeAssignmentsIn) {
        this();
        this.id = idIn;
        this.attributeAssignments = new ArrayList<AttributeAssignment>();
        if (attributeAssignmentsIn != null) {
            this.addAttributeAssignments(attributeAssignmentsIn);
        }
    }

    public StdMutableAdvice(Identifier idIn) {
        this(idIn, null);
        this.attributeAssignments = new ArrayList<AttributeAssignment>();
    }

    public static StdMutableAdvice copy(Advice advice) {
        return new StdMutableAdvice(advice.getId(), advice.getAttributeAssignments());
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    public void setId(Identifier identifier) {
        this.id = identifier;
    }

    @Override
    public Collection<AttributeAssignment> getAttributeAssignments() {
        return this.attributeAssignments == EMPTY_ATTRIBUTE_ASSIGNMENTS ? this.attributeAssignments : Collections.unmodifiableList(this.attributeAssignments);
    }

    public void addAttributeAssignment(AttributeAssignment attributeAssignment) {
        if (this.attributeAssignments == EMPTY_ATTRIBUTE_ASSIGNMENTS) {
            this.attributeAssignments = new ArrayList<AttributeAssignment>();
        }
        this.attributeAssignments.add(attributeAssignment);
    }

    public void addAttributeAssignments(Collection<AttributeAssignment> listAttributeAssignments) {
        if (listAttributeAssignments != null && listAttributeAssignments.size() > 0) {
            if (this.attributeAssignments == EMPTY_ATTRIBUTE_ASSIGNMENTS) {
                this.attributeAssignments = new ArrayList<AttributeAssignment>();
            }
            this.attributeAssignments.addAll(listAttributeAssignments);
        }
    }

    public void setAttributeAssignments(Collection<AttributeAssignment> listAttributeAssignments) {
        this.attributeAssignments = EMPTY_ATTRIBUTE_ASSIGNMENTS;
        this.addAttributeAssignments(listAttributeAssignments);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Advice)) {
            return false;
        }
        Advice adviceObj = (Advice)obj;
        return ObjUtil.equalsAllowNull(this.getId(), adviceObj.getId()) && ListUtil.equalsAllowNulls(this.getAttributeAssignments(), adviceObj.getAttributeAssignments());
    }

    public int hashCode() {
        int result = 17;
        if (this.getId() != null) {
            result = 31 * result + this.getId().hashCode();
        }
        if (this.getAttributeAssignments() != null) {
            result = 31 * result + this.getAttributeAssignments().hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Identifier identifier = this.getId();
        if (identifier != null) {
            stringBuilder.append("id=");
            stringBuilder.append(identifier.toString());
            needsComma = true;
        }
        if (this.attributeAssignments.size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributeAssignments=");
            stringBuilder.append(ListUtil.toString(this.attributeAssignments));
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

