/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.MissingAttributeDetail;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableMissingAttributeDetail
implements MissingAttributeDetail {
    private static final List<AttributeValue<?>> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private Identifier category;
    private Identifier attributeId;
    private Identifier dataTypeId;
    private String issuer;
    private List<AttributeValue<?>> attributeValues;

    public StdMutableMissingAttributeDetail() {
        this.attributeValues = EMPTY_LIST;
    }

    public StdMutableMissingAttributeDetail(Identifier categoryIn, Identifier attributeIdIn, Identifier dataTypeIdIn, String issuerIn, Collection<AttributeValue<?>> attributeValuesIn) {
        this.category = categoryIn;
        this.attributeId = attributeIdIn;
        this.dataTypeId = dataTypeIdIn;
        this.issuer = issuerIn;
        if (attributeValuesIn != null && attributeValuesIn.size() > 0) {
            this.attributeValues = new ArrayList();
            this.attributeValues.addAll(attributeValuesIn);
        } else {
            this.attributeValues = EMPTY_LIST;
        }
    }

    public StdMutableMissingAttributeDetail(Identifier categoryIn, Identifier attributeIdIn, Identifier dataTypeIdIn, String issuerIn) {
        this(categoryIn, attributeIdIn, dataTypeIdIn, issuerIn, null);
    }

    public StdMutableMissingAttributeDetail(Identifier categoryIn, Identifier attributeIdIn, Identifier dataTypeIdIn) {
        this(categoryIn, attributeIdIn, dataTypeIdIn, null);
    }

    public static StdMutableMissingAttributeDetail copy(MissingAttributeDetail missingAttributeDetail) {
        return new StdMutableMissingAttributeDetail(missingAttributeDetail.getCategory(), missingAttributeDetail.getAttributeId(), missingAttributeDetail.getDataTypeId(), missingAttributeDetail.getIssuer(), missingAttributeDetail.getAttributeValues());
    }

    @Override
    public Identifier getCategory() {
        return this.category;
    }

    public void setCategory(Identifier identifier) {
        this.category = identifier;
    }

    @Override
    public Identifier getAttributeId() {
        return this.attributeId;
    }

    public void setAttributeId(Identifier identifier) {
        this.attributeId = identifier;
    }

    @Override
    public Identifier getDataTypeId() {
        return this.dataTypeId;
    }

    public void setDataTypeId(Identifier identifier) {
        this.dataTypeId = identifier;
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuerIn) {
        this.issuer = issuerIn;
    }

    @Override
    public Collection<AttributeValue<?>> getAttributeValues() {
        return this.attributeValues == EMPTY_LIST ? this.attributeValues : Collections.unmodifiableCollection(this.attributeValues);
    }

    public void addAttributeValue(AttributeValue<?> attributeValue) {
        if (this.attributeValues == EMPTY_LIST) {
            this.attributeValues = new ArrayList();
        }
        this.attributeValues.add(attributeValue);
    }

    public void addAttributeValues(Collection<AttributeValue<?>> attributeValuesIn) {
        if (attributeValuesIn != null && attributeValuesIn.size() > 0) {
            if (this.attributeValues == EMPTY_LIST) {
                this.attributeValues = new ArrayList();
            }
            this.attributeValues.addAll(attributeValuesIn);
        }
    }

    public void setAttributeValues(Collection<AttributeValue<?>> attributeValuesIn) {
        this.attributeValues = EMPTY_LIST;
        this.addAttributeValues(attributeValuesIn);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MissingAttributeDetail)) {
            return false;
        }
        MissingAttributeDetail objMissingAttributeDetail = (MissingAttributeDetail)obj;
        return ObjUtil.equalsAllowNull(this.getCategory(), objMissingAttributeDetail.getCategory()) && ObjUtil.equalsAllowNull(this.getAttributeId(), objMissingAttributeDetail.getAttributeId()) && ObjUtil.equalsAllowNull(this.getDataTypeId(), objMissingAttributeDetail.getDataTypeId()) && ObjUtil.equalsAllowNull(this.getIssuer(), objMissingAttributeDetail.getIssuer()) && ListUtil.equalsAllowNulls(this.getAttributeValues(), objMissingAttributeDetail.getAttributeValues());
    }

    public int hashCode() {
        int result = 17;
        if (this.getCategory() != null) {
            result = 31 * result + this.getCategory().hashCode();
        }
        if (this.getAttributeId() != null) {
            result = 31 * result + this.getAttributeId().hashCode();
        }
        if (this.getDataTypeId() != null) {
            result = 31 * result + this.getDataTypeId().hashCode();
        }
        if (this.getIssuer() != null) {
            result = 31 * result + this.getIssuer().hashCode();
        }
        if (this.getAttributeValues() != null) {
            result = 31 * result + this.getAttributeValues().hashCode();
        }
        return result;
    }

    public String toString() {
        Collection<AttributeValue<?>> listAttributeValues;
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object objectToDump = this.getAttributeId();
        if (objectToDump != null) {
            stringBuilder.append("attributeId=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getCategory()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("category=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getDataTypeId()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("dataTypeId=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getIssuer()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("issuer=");
            stringBuilder.append((String)objectToDump);
            needsComma = true;
        }
        if ((listAttributeValues = this.getAttributeValues()).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributeValues=");
            stringBuilder.append(ListUtil.toString(listAttributeValues));
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

