/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.util.ListUtil;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdMutableObligation
implements Obligation {
    private static final List<AttributeAssignment> EMPTY_LIST = Collections.unmodifiableList(new ArrayList());
    private Identifier id;
    private List<AttributeAssignment> attributeAssignments;

    public StdMutableObligation() {
        this.attributeAssignments = EMPTY_LIST;
    }

    public StdMutableObligation(Identifier idIn, Collection<AttributeAssignment> attributeAssignmentsIn) {
        this.id = idIn;
        if (attributeAssignmentsIn != null) {
            this.attributeAssignments = new ArrayList<AttributeAssignment>();
            this.attributeAssignments.addAll(attributeAssignmentsIn);
        } else {
            this.attributeAssignments = EMPTY_LIST;
        }
    }

    public StdMutableObligation(Identifier idIn) {
        this(idIn, null);
    }

    @Override
    public Identifier getId() {
        return this.id;
    }

    public void setId(Identifier identifier) {
        this.id = identifier;
    }

    @Override
    public Collection<AttributeAssignment> getAttributeAssignments() {
        return Collections.unmodifiableCollection(this.attributeAssignments);
    }

    public void addAttributeAssignment(AttributeAssignment attributeAssignment) {
        if (this.attributeAssignments == EMPTY_LIST) {
            this.attributeAssignments = new ArrayList<AttributeAssignment>();
        }
        this.attributeAssignments.add(attributeAssignment);
    }

    public void addAttributeAssignments(Collection<AttributeAssignment> attributeAssignmentsIn) {
        this.attributeAssignments = EMPTY_LIST;
        this.addAttributeAssignments(attributeAssignmentsIn);
    }

    public void setAttributeAssignments(Collection<AttributeAssignment> attributeAssignmentsIn) {
        this.attributeAssignments = EMPTY_LIST;
        this.addAttributeAssignments(attributeAssignmentsIn);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof Obligation)) {
            return false;
        }
        Obligation objObligation = (Obligation)obj;
        return ObjUtil.equalsAllowNull(this.getId(), objObligation.getId()) && ListUtil.equalsAllowNulls(this.getAttributeAssignments(), objObligation.getAttributeAssignments());
    }

    public int hashCode() {
        int result = 17;
        if (this.getId() != null) {
            result = 31 * result + this.getId().hashCode();
        }
        if (this.getAttributeAssignments() != null) {
            result = 31 * result + this.getAttributeAssignments().hashCode();
        }
        return result;
    }

    public String toString() {
        Collection<AttributeAssignment> listAttributeAssignments;
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Identifier identifier = this.getId();
        if (identifier != null) {
            stringBuilder.append("id=");
            stringBuilder.append(identifier.toString());
            needsComma = true;
        }
        if ((listAttributeAssignments = this.getAttributeAssignments()).size() > 0) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributeAssignments=");
            stringBuilder.append(ListUtil.toString(listAttributeAssignments));
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

