/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.pdp.ScopeResolverResult;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.util.StringUtils;

public class StdScopeResolverResult
implements ScopeResolverResult {
    private Status status;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public StdScopeResolverResult(Status statusIn, Collection<Attribute> attributesIn) {
        this.status = statusIn;
        if (attributesIn != null) {
            this.attributes.addAll(attributesIn);
        }
    }

    public StdScopeResolverResult(Status statusIn) {
        this(statusIn, null);
    }

    public StdScopeResolverResult(Collection<Attribute> attributesIn) {
        this(StdStatus.STATUS_OK, attributesIn);
    }

    @Override
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status statusIn) {
        this.status = statusIn;
    }

    @Override
    public Iterator<Attribute> getAttributes() {
        return this.attributes.iterator();
    }

    public void addAttribute(Attribute attribute) {
        this.attributes.add(attribute);
    }

    public String toString() {
        Iterator<Attribute> iterAttributes;
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Status statusToDump = this.getStatus();
        if (statusToDump != null) {
            stringBuilder.append("status=");
            stringBuilder.append(statusToDump.toString());
            needsComma = true;
        }
        if ((iterAttributes = this.getAttributes()) != null && iterAttributes.hasNext()) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("attributes=");
            stringBuilder.append(StringUtils.toString(iterAttributes, true));
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

