/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.XACML1;

public class StdStatusCode
implements StatusCode {
    private Identifier statusCodeValue;
    private StatusCode child;
    public static final StatusCode STATUS_CODE_OK = new StdStatusCode(XACML1.ID_STATUS_OK);
    public static final StatusCode STATUS_CODE_MISSING_ATTRIBUTE = new StdStatusCode(XACML1.ID_STATUS_MISSING_ATTRIBUTE);
    public static final StatusCode STATUS_CODE_SYNTAX_ERROR = new StdStatusCode(XACML1.ID_STATUS_SYNTAX_ERROR);
    public static final StatusCode STATUS_CODE_PROCESSING_ERROR = new StdStatusCode(XACML1.ID_STATUS_PROCESSING_ERROR);

    public StdStatusCode(Identifier statusCodeValueIn, StatusCode childIn) {
        this.statusCodeValue = statusCodeValueIn;
        this.child = childIn;
    }

    public StdStatusCode(Identifier majorStatusCodeValueIn) {
        this(majorStatusCodeValueIn, null);
    }

    public static StdStatusCode copy(StatusCode statusCode) {
        return new StdStatusCode(statusCode.getStatusCodeValue(), statusCode.getChild());
    }

    @Override
    public Identifier getStatusCodeValue() {
        return this.statusCodeValue;
    }

    @Override
    public StatusCode getChild() {
        return this.child;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needsComma = false;
        Object objectToDump = this.getStatusCodeValue();
        if (objectToDump != null) {
            stringBuilder.append("statusCodeValue=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        if ((objectToDump = this.getChild()) != null) {
            if (needsComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("child=");
            stringBuilder.append(objectToDump.toString());
            needsComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hc;
        Identifier identifierStatusCodeValue = this.getStatusCodeValue();
        StatusCode statusCodeChild = this.getChild();
        int n = hc = identifierStatusCodeValue == null ? 0 : identifierStatusCodeValue.hashCode();
        if (statusCodeChild != null) {
            hc += statusCodeChild.hashCode();
        }
        return hc;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof StatusCode)) {
            return false;
        }
        StatusCode statusCodeObj = (StatusCode)obj;
        if (!statusCodeObj.getStatusCodeValue().equals(this.getStatusCodeValue())) {
            return false;
        }
        StatusCode statusCodeChildThis = this.getChild();
        StatusCode statusCodeChildObj = statusCodeObj.getChild();
        if (statusCodeChildThis == null) {
            return statusCodeChildObj == null;
        }
        return statusCodeChildThis.equals(statusCodeChildObj);
    }
}

