/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.text.ParseException;
import java.util.Arrays;
import org.apache.openaz.xacml.api.Version;

public class StdVersion
implements Version {
    private int[] versionDigits;
    private String cachedVersionString;

    public StdVersion(int[] versionDigitsIn) {
        this.versionDigits = versionDigitsIn;
    }

    public static StdVersion newInstance(String versionString) throws ParseException {
        if (versionString == null) {
            throw new NullPointerException("Null version string");
        }
        String[] versionParts = versionString.split("[.]", -1);
        if (versionParts == null) {
            throw new ParseException("Invalid version string \"" + versionString + "\"", 0);
        }
        int[] versionNumberParts = new int[versionParts.length];
        for (int i = 0; i < versionParts.length; ++i) {
            try {
                versionNumberParts[i] = Integer.parseInt(versionParts[i]);
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Invalid version number \"" + versionParts[i] + "\"", i);
            }
            if (versionNumberParts[i] >= 0) continue;
            throw new ParseException("Invalid version number \"" + versionParts[i] + "\"", i);
        }
        return new StdVersion(versionNumberParts);
    }

    @Override
    public String getVersion() {
        if (this.cachedVersionString == null) {
            StringBuilder stringBuilder = new StringBuilder();
            int[] versionDigitsHere = this.getVersionDigits();
            if (versionDigitsHere != null && versionDigitsHere.length > 0) {
                stringBuilder.append(versionDigitsHere[0]);
                for (int i = 1; i < versionDigitsHere.length; ++i) {
                    stringBuilder.append('.');
                    stringBuilder.append(versionDigitsHere[i]);
                }
            }
            this.cachedVersionString = stringBuilder.toString();
        }
        return this.cachedVersionString;
    }

    @Override
    public int[] getVersionDigits() {
        return this.versionDigits;
    }

    public String toString() {
        return this.getVersion();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof Version)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        int[] objDigits = ((Version)obj).getVersionDigits();
        int[] thisDigits = this.getVersionDigits();
        if (thisDigits == null || thisDigits.length == 0) {
            return objDigits == null || objDigits.length == 0;
        }
        if (objDigits == null || objDigits.length == 0) {
            return false;
        }
        return Arrays.equals(thisDigits, objDigits);
    }

    public int hashCode() {
        int result = 17;
        if (this.getVersionDigits() != null) {
            result = 31 * result + Arrays.hashCode(this.getVersionDigits());
        }
        return result;
    }

    @Override
    public int compareTo(Version o) {
        if (o == this || this.equals(o)) {
            return 0;
        }
        int[] thisDigits = this.getVersionDigits();
        int[] oDigits = o.getVersionDigits();
        if (thisDigits == null || thisDigits.length == 0) {
            if (oDigits == null || oDigits.length == 0) {
                return 0;
            }
            return -1;
        }
        if (oDigits == null || oDigits.length == 0) {
            return 1;
        }
        int maxDigits = thisDigits.length > oDigits.length ? thisDigits.length : oDigits.length;
        for (int i = 0; i < maxDigits; ++i) {
            if (i < thisDigits.length) {
                if (i < oDigits.length) {
                    int diff = thisDigits[i] - oDigits[i];
                    if (diff == 0) continue;
                    return diff;
                }
                if (thisDigits[i] <= 0) continue;
                return 1;
            }
            if (oDigits[i] <= 0) continue;
            return -1;
        }
        return 0;
    }

    @Override
    public String stringValue() {
        return this.getVersion();
    }
}

