/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std;

import java.text.ParseException;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.api.VersionMatch;
import org.apache.openaz.xacml.util.ObjUtil;

public class StdVersionMatch
implements VersionMatch {
    private int[] matchComponents;
    private String cachedStringRep;

    private static void addComponent(StringBuilder stringBuilder, int component) {
        if (component == -2) {
            stringBuilder.append('+');
        } else if (component == -1) {
            stringBuilder.append('*');
        } else {
            stringBuilder.append(component);
        }
    }

    public StdVersionMatch(int[] matchComponentsIn) {
        this.matchComponents = matchComponentsIn;
    }

    public static StdVersionMatch newInstance(String versionMatch) throws ParseException {
        if (versionMatch == null) {
            throw new NullPointerException("Null version string");
        }
        String[] versionMatchParts = versionMatch.split("[.]", -1);
        if (versionMatchParts == null) {
            throw new ParseException("Invalid version string \"" + versionMatch + "\"", 0);
        }
        int[] versionMatchNumberParts = new int[versionMatchParts.length];
        for (int i = 0; i < versionMatchParts.length; ++i) {
            if (versionMatchParts[i].equals("*")) {
                versionMatchNumberParts[i] = -1;
                continue;
            }
            if (versionMatchParts[i].equals("+")) {
                versionMatchNumberParts[i] = -2;
                continue;
            }
            try {
                versionMatchNumberParts[i] = Integer.parseInt(versionMatchParts[i]);
                continue;
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Invalid version number \"" + versionMatchParts[i] + "\"", i);
            }
        }
        return new StdVersionMatch(versionMatchNumberParts);
    }

    @Override
    public String getVersionMatch() {
        if (this.cachedStringRep == null) {
            StringBuilder stringBuilder = new StringBuilder();
            int[] matchComponentsHere = this.getMatchComponents();
            if (matchComponentsHere != null && matchComponentsHere.length > 0) {
                StdVersionMatch.addComponent(stringBuilder, this.matchComponents[0]);
                for (int i = 1; i < this.matchComponents.length; ++i) {
                    stringBuilder.append('.');
                    StdVersionMatch.addComponent(stringBuilder, this.matchComponents[i]);
                }
            }
            this.cachedStringRep = stringBuilder.toString();
        }
        return this.cachedStringRep;
    }

    public int[] getMatchComponents() {
        return this.matchComponents;
    }

    @Override
    public boolean match(Version version, int cmp) {
        int iMatch;
        int[] matchComponentsHere = this.getMatchComponents();
        if (matchComponentsHere == null || matchComponentsHere.length == 0) {
            return false;
        }
        int[] versionComponents = version.getVersionDigits();
        if (versionComponents == null || versionComponents.length == 0) {
            return false;
        }
        int iVersion = 0;
        for (iMatch = 0; iMatch < this.matchComponents.length && iVersion < versionComponents.length; ++iMatch) {
            int matchValue = matchComponentsHere[iMatch];
            if (matchValue == -2) {
                iVersion = versionComponents.length;
                continue;
            }
            if (matchValue == -1) {
                ++iVersion;
                continue;
            }
            int versionValue = versionComponents[iVersion];
            if (cmp == 0 && versionValue == matchValue || cmp < 0 && versionValue <= matchValue || cmp > 0 && versionValue >= matchValue) {
                ++iVersion;
                continue;
            }
            return false;
        }
        return iVersion == versionComponents.length && iMatch == this.matchComponents.length;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof VersionMatch)) {
            return false;
        }
        VersionMatch objVersionMatch = (VersionMatch)obj;
        return ObjUtil.equalsAllowNull(this.getVersionMatch(), objVersionMatch.getVersionMatch());
    }

    public int hashCode() {
        int result = 17;
        if (this.getVersionMatch() != null) {
            result = 31 * result + this.getVersionMatch().hashCode();
        }
        return result;
    }

    public String toString() {
        return this.getVersionMatch();
    }
}

