/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML2;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.RFC2396DomainName;

public class DataTypeDNSName
extends DataTypeSemanticStringBase<RFC2396DomainName> {
    private static final DataTypeDNSName singleInstance = new DataTypeDNSName();

    private DataTypeDNSName() {
        super(XACML2.ID_DATATYPE_DNSNAME, RFC2396DomainName.class);
    }

    public static DataTypeDNSName newInstance() {
        return singleInstance;
    }

    @Override
    public RFC2396DomainName convert(Object source) throws DataTypeException {
        if (source == null || source instanceof RFC2396DomainName) {
            return (RFC2396DomainName)source;
        }
        String stringValue = this.convertToString(source);
        if (stringValue == null) {
            return null;
        }
        RFC2396DomainName rfc2396DomainName = null;
        try {
            rfc2396DomainName = RFC2396DomainName.newInstance(stringValue);
        }
        catch (ParseException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to DNSName", ex);
        }
        return rfc2396DomainName;
    }
}

