/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeBase;

public class DataTypeDouble
extends DataTypeBase<Double> {
    private static final DataTypeDouble singleInstance = new DataTypeDouble();

    private DataTypeDouble() {
        super(XACML.ID_DATATYPE_DOUBLE, Double.class);
    }

    public static DataTypeDouble newInstance() {
        return singleInstance;
    }

    @Override
    public Double convert(Object source) throws DataTypeException {
        if (source == null || source instanceof Double) {
            return (Double)source;
        }
        String stringValue = this.convertToString(source);
        Double intValue = null;
        try {
            if (stringValue.equals("INF")) {
                stringValue = "Infinity";
            } else if (stringValue.equals("-INF")) {
                stringValue = "-Infinity";
            }
            intValue = Double.parseDouble(stringValue);
        }
        catch (NumberFormatException ex) {
            throw new DataTypeException(this, "Failed to convert from \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to double", ex);
        }
        return intValue;
    }
}

