/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.HexBinary;

public class DataTypeHexBinary
extends DataTypeSemanticStringBase<HexBinary> {
    private static final DataTypeHexBinary singleInstance = new DataTypeHexBinary();

    private DataTypeHexBinary() {
        super(XACML.ID_DATATYPE_HEXBINARY, HexBinary.class);
    }

    public static DataTypeHexBinary newInstance() {
        return singleInstance;
    }

    @Override
    public HexBinary convert(Object source) throws DataTypeException {
        if (source == null || source instanceof HexBinary) {
            return (HexBinary)source;
        }
        if (source instanceof byte[]) {
            return new HexBinary((byte[])source);
        }
        String stringValue = this.convertToString(source);
        if (stringValue == null) {
            return null;
        }
        HexBinary hexBinary = null;
        try {
            hexBinary = HexBinary.newInstance(stringValue);
        }
        catch (Exception ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to HexBinary", ex);
        }
        return hexBinary;
    }
}

