/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML2;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.IPAddress;

public class DataTypeIpAddress
extends DataTypeSemanticStringBase<IPAddress> {
    private static final DataTypeIpAddress singleInstance = new DataTypeIpAddress();

    private DataTypeIpAddress() {
        super(XACML2.ID_DATATYPE_IPADDRESS, IPAddress.class);
    }

    public static DataTypeIpAddress newInstance() {
        return singleInstance;
    }

    @Override
    public IPAddress convert(Object source) throws DataTypeException {
        if (source == null || source instanceof IPAddress) {
            return (IPAddress)source;
        }
        String stringValue = this.convertToString(source);
        if (stringValue == null) {
            return null;
        }
        IPAddress ipAddress = null;
        try {
            ipAddress = IPAddress.newInstance(stringValue);
        }
        catch (ParseException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to IPAddress", ex);
        }
        return ipAddress;
    }
}

