/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.XACML;
import org.apache.openaz.xacml.std.datatypes.DataTypeSemanticStringBase;
import org.apache.openaz.xacml.std.datatypes.ISO8601Time;

public class DataTypeTime
extends DataTypeSemanticStringBase<ISO8601Time> {
    private static final DataTypeTime singleInstance = new DataTypeTime();

    private DataTypeTime() {
        super(XACML.ID_DATATYPE_TIME, ISO8601Time.class);
    }

    public static DataTypeTime newInstance() {
        return singleInstance;
    }

    @Override
    public ISO8601Time convert(Object source) throws DataTypeException {
        if (source == null || source instanceof ISO8601Time) {
            return (ISO8601Time)source;
        }
        if (source instanceof Date) {
            return ISO8601Time.fromDate((Date)source);
        }
        if (source instanceof Calendar) {
            return ISO8601Time.fromCalendar((Calendar)source);
        }
        String stringValue = this.convertToString(source);
        ISO8601Time timeValue = null;
        try {
            timeValue = ISO8601Time.fromISO8601TimeString(stringValue);
        }
        catch (ParseException ex) {
            throw new DataTypeException(this, "Failed to convert \"" + source.getClass().getCanonicalName() + "\" with value \"" + stringValue + "\" to Time", ex);
        }
        return timeValue;
    }
}

