/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.std.datatypes.IPv4Address;
import org.apache.openaz.xacml.std.datatypes.IPv6Address;

public abstract class IPAddress
implements SemanticString {
    public static IPAddress newInstance(String ipAddressString) throws ParseException {
        if (ipAddressString == null || ipAddressString.length() == 0) {
            return null;
        }
        if (IPv4Address.isIPv4Address(ipAddressString)) {
            return IPv4Address.newIPv4Instance(ipAddressString);
        }
        if (IPv6Address.isIPv6Address(ipAddressString)) {
            return IPv6Address.newIPv6Instance(ipAddressString);
        }
        throw new ParseException("Unknown IPAddress type for \"" + ipAddressString + "\"", 0);
    }

    @Override
    public abstract String stringValue();

    public abstract String toString();

    public abstract boolean equals(Object var1);

    public abstract int hashCode();
}

