/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Arrays;
import org.apache.openaz.xacml.std.datatypes.IPAddress;
import org.apache.openaz.xacml.std.datatypes.PortRange;

public class IPv4Address
extends IPAddress {
    private short[] addressBytes;
    private short[] addressMask;
    private PortRange portRange;

    public IPv4Address(short[] addressBytesIn, short[] addressMaskIn, PortRange portRangeIn) {
        this.addressBytes = addressBytesIn;
        this.addressMask = addressMaskIn;
        this.portRange = portRangeIn;
        if (addressBytesIn.length != 4) {
            throw new IllegalArgumentException("Invalid byte count for IPv4 address: " + addressBytesIn.length);
        }
    }

    protected static short[] getAddress(String ipv4AddressString) throws ParseException {
        String[] addressParts = ipv4AddressString.split("[.]", -1);
        if (addressParts == null || addressParts.length != 4) {
            throw new ParseException("Invalid IPv4 address string \"" + ipv4AddressString + "\": invalid address", 0);
        }
        short[] addressBytes = new short[4];
        for (int i = 0; i < 4; ++i) {
            try {
                int octet = Integer.parseInt(addressParts[i]);
                if (octet < 0 || octet > 255) {
                    throw new ParseException("Invalid IPv4 address string \"" + ipv4AddressString + "\": invalid octet: \"" + addressParts[i], 0);
                }
                addressBytes[i] = (short)octet;
                continue;
            }
            catch (NumberFormatException ex) {
                throw new ParseException("Invalid IPv4 address string \"" + ipv4AddressString + "\": invalid octet: \"" + addressParts[i], 0);
            }
        }
        return addressBytes;
    }

    public static String formatAddress(short[] addressBytes) {
        if (addressBytes == null || addressBytes.length != 4) {
            return null;
        }
        return addressBytes[0] + "." + addressBytes[1] + "." + addressBytes[2] + "." + addressBytes[3];
    }

    public static IPv4Address newIPv4Instance(String ipv4AddressString) throws ParseException {
        int endAddress;
        if (ipv4AddressString == null || ipv4AddressString.length() == 0) {
            return null;
        }
        int slashPos = ipv4AddressString.indexOf(47);
        int colonPos = ipv4AddressString.indexOf(58);
        if (colonPos >= 0 && colonPos < slashPos) {
            throw new ParseException("Invalid IPv4 address string \"" + ipv4AddressString + "\": out of order components", colonPos);
        }
        int n = slashPos >= 0 ? slashPos : (endAddress = colonPos >= 0 ? colonPos : ipv4AddressString.length());
        if (endAddress < 7) {
            throw new ParseException("Invalid IPv4 address string \"" + ipv4AddressString + "\": address too short", 0);
        }
        short[] addressBytes = IPv4Address.getAddress(ipv4AddressString.substring(0, endAddress));
        short[] maskBytes = null;
        if (slashPos >= 0) {
            int endMask = colonPos >= 0 ? colonPos : ipv4AddressString.length();
            maskBytes = IPv4Address.getAddress(ipv4AddressString.substring(slashPos + 1, endMask));
        }
        PortRange portRange = null;
        if (colonPos >= 0) {
            if (ipv4AddressString.substring(colonPos + 1).length() < 1) {
                throw new ParseException("Invalid IPv4 address string \"" + ipv4AddressString + "\": no portrange given after ':'", colonPos + 1);
            }
            portRange = PortRange.newInstance(ipv4AddressString.substring(colonPos + 1));
        }
        return new IPv4Address(addressBytes, maskBytes, portRange);
    }

    public static boolean isIPv4Address(String ipv4AddressString) {
        if (ipv4AddressString == null || ipv4AddressString.length() == 0) {
            return false;
        }
        return ipv4AddressString.indexOf(46) < ipv4AddressString.lastIndexOf(46) && ipv4AddressString.indexOf(58) == ipv4AddressString.lastIndexOf(58);
    }

    @Override
    public String stringValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.addressBytes != null && this.addressBytes.length > 0) {
            stringBuilder.append(IPv4Address.formatAddress(this.addressBytes));
        }
        if (this.addressMask != null && this.addressMask.length > 0) {
            stringBuilder.append('/');
            stringBuilder.append(IPv4Address.formatAddress(this.addressMask));
        }
        if (this.portRange != null) {
            stringBuilder.append(':');
            stringBuilder.append(this.portRange.stringValue());
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        return this.stringValue();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof IPv4Address)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        IPv4Address ipAddress = (IPv4Address)obj;
        short[] bytesThis = this.addressBytes;
        short[] bytesThat = ipAddress.addressBytes;
        if (bytesThis == null ? bytesThat != null : bytesThat == null || !Arrays.equals(bytesThis, bytesThat)) {
            return false;
        }
        bytesThis = this.addressMask;
        bytesThat = ipAddress.addressMask;
        if (bytesThis == null ? bytesThat != null : bytesThat == null || !Arrays.equals(bytesThis, bytesThat)) {
            return false;
        }
        return !(this.portRange == null ? ipAddress.portRange != null : ipAddress.portRange == null || !ipAddress.portRange.equals(this.portRange));
    }

    @Override
    public int hashCode() {
        int result = 17;
        if (this.addressBytes != null) {
            result = 31 * result + Arrays.hashCode(this.addressBytes);
        }
        if (this.addressMask != null) {
            result = 31 * result + Arrays.hashCode(this.addressMask);
        }
        if (this.portRange != null) {
            result = 31 * result + this.portRange.hashCode();
        }
        return result;
    }
}

