/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.std.datatypes.IDateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601DateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601Duration;
import org.apache.openaz.xacml.std.datatypes.ISO8601TimeZone;
import org.apache.openaz.xacml.std.datatypes.ParseUtils;

public class ISO8601Date
implements IDateTime<ISO8601Date>,
Comparable<ISO8601Date>,
SemanticString {
    private ISO8601DateTime dateTime;

    protected ISO8601Date(ISO8601DateTime iso8601DateTime) {
        this.dateTime = iso8601DateTime;
    }

    public ISO8601Date(String timeZone, int yearIn, int monthIn, int dayIn) {
        this.dateTime = new ISO8601DateTime(timeZone, yearIn, monthIn, dayIn, 0, 0, 0, 0);
    }

    public ISO8601Date(TimeZone timeZone, int yearIn, int monthIn, int dayIn) {
        this.dateTime = new ISO8601DateTime(timeZone, yearIn, monthIn, dayIn, 0, 0, 0, 0);
    }

    public ISO8601Date(ISO8601TimeZone timeZone, int yearIn, int monthIn, int dayIn) {
        this(timeZone == null ? null : timeZone.getTimeZoneString(), yearIn, monthIn, dayIn);
    }

    public ISO8601Date(int yearIn, int monthIn, int dayIn) {
        this((String)null, yearIn, monthIn, dayIn);
    }

    public boolean getHasTimeZone() {
        return this.dateTime.getHasTimeZone();
    }

    public Calendar getCalendar() {
        return this.dateTime.getCalendar();
    }

    public String getTimeZone() {
        return this.dateTime.getTimeZone();
    }

    public int getYear() {
        return this.dateTime.getYear();
    }

    public int getMonth() {
        return this.dateTime.getMonth();
    }

    public int getDay() {
        return this.dateTime.getDay();
    }

    @Override
    public ISO8601Date add(ISO8601Duration iso8601Duration) {
        return new ISO8601Date(this.dateTime.add(iso8601Duration));
    }

    @Override
    public ISO8601Date sub(ISO8601Duration iso8601Duration) {
        return new ISO8601Date(this.dateTime.sub(iso8601Duration));
    }

    public int hashCode() {
        return this.dateTime.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ISO8601Date)) {
            return false;
        }
        ISO8601Date iso8601Date = (ISO8601Date)obj;
        return this.dateTime.equals(iso8601Date.dateTime);
    }

    public String stringValue(boolean includeTimeZone) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.format("%d-%02d-%02d", this.dateTime.getYear(), this.dateTime.getMonth(), this.dateTime.getDay()));
        if (includeTimeZone && this.dateTime.getHasTimeZone()) {
            stringBuilder.append(this.dateTime.getTimeZone());
        }
        return stringBuilder.toString();
    }

    @Override
    public String stringValue() {
        return this.stringValue(true);
    }

    public String toString() {
        return this.stringValue(true);
    }

    @Override
    public int compareTo(ISO8601Date o) {
        return this.dateTime.compareTo(o.dateTime);
    }

    public static ISO8601Date fromCalendar(Calendar calendar) {
        int year = calendar.get(0) == 0 ? 1 - calendar.get(1) : calendar.get(1);
        return new ISO8601Date(calendar.getTimeZone(), year, calendar.get(2) + 1, calendar.get(5));
    }

    public static ISO8601Date fromDate(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return ISO8601Date.fromCalendar(cal);
    }

    public static ISO8601Date fromISO8601DateString(String strDate) throws ParseException {
        int day;
        int month;
        int startPos = ParseUtils.nextNonWhite(strDate, 0);
        ParseUtils.ParseValue<Integer> parseValue = ParseUtils.getSignedValue(strDate, startPos);
        if (parseValue == null) {
            throw new ParseException("Invalid year", startPos);
        }
        int year = parseValue.getValue();
        if (parseValue.getNextPos() < 4) {
            throw new ParseException("Invalid year (must be at least 4 digits)", startPos);
        }
        if ((startPos += parseValue.getNextPos()) >= strDate.length() || strDate.charAt(startPos) != '-') {
            throw new ParseException("Invalid date", startPos);
        }
        if ((month = ParseUtils.getTwoDigitValue(strDate, ++startPos)) < 0 || month > 12) {
            throw new ParseException("Invalid month", startPos);
        }
        if ((startPos += 2) >= strDate.length() || strDate.charAt(startPos) != '-') {
            throw new ParseException("Invalid date", startPos);
        }
        if ((day = ParseUtils.getTwoDigitValue(strDate, ++startPos)) < 1 || day > 31) {
            throw new ParseException("Invalid day", startPos);
        }
        String timezone = null;
        if ((startPos += 2) < strDate.length()) {
            switch (strDate.charAt(startPos)) {
                case 'Z': {
                    timezone = "GMT";
                    ++startPos;
                    break;
                }
                case '+': 
                case '-': {
                    if (startPos + 5 < strDate.length()) {
                        timezone = "GMT" + strDate.substring(startPos, startPos + 6);
                        break;
                    }
                    throw new ParseException("Invalid timezone", startPos);
                }
                default: {
                    throw new ParseException("Invalid timezone", startPos);
                }
            }
        }
        return new ISO8601Date(timezone, year, month, day);
    }
}

