/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.std.datatypes.IDateTime;
import org.apache.openaz.xacml.std.datatypes.ISO8601Date;
import org.apache.openaz.xacml.std.datatypes.ISO8601Duration;
import org.apache.openaz.xacml.std.datatypes.ISO8601Time;
import org.apache.openaz.xacml.std.datatypes.ISO8601TimeZone;
import org.apache.openaz.xacml.std.datatypes.ParseUtils;

public class ISO8601DateTime
implements IDateTime<ISO8601DateTime>,
Comparable<ISO8601DateTime>,
SemanticString {
    private static final long TZOFFSET_14_HOURS_MILLIS = 50400000L;
    private boolean hasTimeZone;
    private Calendar calendar;

    private void validateDate() {
        this.calendar.getTime();
        int year = this.calendar.get(1);
        if (this.calendar.isSet(0) && this.calendar.get(0) == 0) {
            year = 0 - year + 1;
        }
    }

    public ISO8601DateTime(TimeZone timeZone, int yearIn, int monthIn, int dayIn, int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this.calendar = Calendar.getInstance();
        this.calendar.setLenient(false);
        if (timeZone != null) {
            this.hasTimeZone = true;
            this.calendar.setTimeZone(timeZone);
        }
        if (yearIn <= 0) {
            this.calendar.set(0, 0);
            this.calendar.set(1, Math.abs(yearIn) + 1);
        } else {
            this.calendar.set(1, yearIn);
        }
        this.calendar.set(2, monthIn - 1);
        this.calendar.set(5, dayIn);
        this.calendar.set(11, hourIn);
        this.calendar.set(12, minuteIn);
        this.calendar.set(13, secondIn);
        this.calendar.set(14, millisecondIn);
        this.validateDate();
    }

    public ISO8601DateTime(String timeZone, int yearIn, int monthIn, int dayIn, int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this(timeZone == null ? null : TimeZone.getTimeZone(timeZone), yearIn, monthIn, dayIn, hourIn, minuteIn, secondIn, millisecondIn);
    }

    public ISO8601DateTime(ISO8601TimeZone timeZone, ISO8601Date iso8601Date, ISO8601Time iso8601Time) {
        this(timeZone == null ? null : timeZone.getTimeZoneString(), iso8601Date.getYear(), iso8601Date.getMonth(), iso8601Date.getDay(), iso8601Time.getHour(), iso8601Time.getMinute(), iso8601Time.getSecond(), iso8601Time.getMillisecond());
    }

    public ISO8601DateTime(int yearIn, int monthIn, int dayIn, int hourIn, int minuteIn, int secondIn, int millisecondIn) {
        this((TimeZone)null, yearIn, monthIn, dayIn, hourIn, minuteIn, secondIn, millisecondIn);
    }

    private ISO8601DateTime(Calendar calendarIn, boolean hasTimeZoneIn) {
        this.calendar = calendarIn;
        this.hasTimeZone = hasTimeZoneIn;
    }

    public boolean getHasTimeZone() {
        return this.hasTimeZone;
    }

    public String getTimeZone() {
        if (this.getHasTimeZone()) {
            int tzOffsetMillis = this.calendar.get(15);
            if (tzOffsetMillis == 0) {
                return "Z";
            }
            int tzOffsetHours = Math.abs(tzOffsetMillis) / 3600000;
            int tzOffsetMinutes = (Math.abs(tzOffsetMillis) - tzOffsetHours * 60 * 60 * 1000) / 60000;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(tzOffsetMillis < 0 ? (char)'-' : '+');
            stringBuilder.append(String.format("%02d", tzOffsetHours));
            stringBuilder.append(':');
            stringBuilder.append(String.format("%02d", tzOffsetMinutes));
            return stringBuilder.toString();
        }
        return null;
    }

    public int getYear() {
        int year = this.calendar.get(1);
        if (this.calendar.get(0) == 0) {
            return -(year - 1);
        }
        return year;
    }

    public int getMonth() {
        return this.calendar.get(2) + 1;
    }

    public int getDay() {
        return this.calendar.get(5);
    }

    public int getHour() {
        return this.calendar.get(11);
    }

    public int getMinute() {
        return this.calendar.get(12);
    }

    public int getSecond() {
        return this.calendar.get(13);
    }

    public int getMillisecond() {
        return this.calendar.get(14);
    }

    public Calendar getCalendar() {
        Calendar calendarCopy = Calendar.getInstance();
        calendarCopy.setLenient(false);
        if (this.getHasTimeZone()) {
            calendarCopy.setTimeZone(this.calendar.getTimeZone());
        }
        calendarCopy.setTimeInMillis(this.calendar.getTimeInMillis());
        return calendarCopy;
    }

    public ISO8601DateTime getGMTDateTime() {
        if (!this.getHasTimeZone()) {
            throw new IllegalStateException("Cannot convert non-time-zoned ISO8601DateTime to GMT");
        }
        if (this.calendar.get(15) == 0) {
            return this;
        }
        Calendar calendarGMT = Calendar.getInstance();
        calendarGMT.setLenient(false);
        calendarGMT.setTimeZone(TimeZone.getTimeZone("GMT"));
        calendarGMT.setTimeInMillis(this.calendar.getTimeInMillis());
        return new ISO8601DateTime(calendarGMT, true);
    }

    private ISO8601DateTime add(ISO8601Duration iso8601Duration, int sign) {
        int millis;
        int seconds;
        Calendar calendarCopy = this.getCalendar();
        int value = iso8601Duration.getYears();
        if (value != 0) {
            calendarCopy.add(1, sign * value);
        }
        if ((value = iso8601Duration.getMonths()) != 0) {
            calendarCopy.add(2, sign * value);
        }
        if ((value = iso8601Duration.getDays()) != 0) {
            calendarCopy.add(6, sign * value);
        }
        if ((value = iso8601Duration.getHours()) != 0) {
            calendarCopy.add(11, sign * value);
        }
        if ((value = iso8601Duration.getMinutes()) != 0) {
            calendarCopy.add(12, sign * value);
        }
        if ((seconds = iso8601Duration.getSeconds()) >= 1) {
            calendarCopy.add(13, sign * seconds);
        }
        if ((millis = iso8601Duration.getMillis()) != 0) {
            calendarCopy.add(14, sign * millis);
        }
        return new ISO8601DateTime(calendarCopy, this.getHasTimeZone());
    }

    @Override
    public ISO8601DateTime add(ISO8601Duration iso8601Duration) {
        return this.add(iso8601Duration, iso8601Duration.getDurationSign());
    }

    @Override
    public ISO8601DateTime sub(ISO8601Duration iso8601Duration) {
        return this.add(iso8601Duration, -iso8601Duration.getDurationSign());
    }

    public int hashCode() {
        return (this.getHasTimeZone() ? 999 : 0) + this.calendar.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof ISO8601DateTime)) {
            return false;
        }
        ISO8601DateTime iso8601DateTime = (ISO8601DateTime)obj;
        return this.getHasTimeZone() == iso8601DateTime.getHasTimeZone() && this.calendar.equals(iso8601DateTime.calendar);
    }

    public static ISO8601DateTime fromCalendar(Calendar calendar) {
        Calendar calendarNew = Calendar.getInstance();
        calendarNew.setTime(calendar.getTime());
        calendarNew.setLenient(false);
        return new ISO8601DateTime(calendarNew, true);
    }

    public static ISO8601DateTime fromDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.setLenient(false);
        return new ISO8601DateTime(calendar, true);
    }

    public static ISO8601DateTime fromISO8601DateTimeString(String strDateTime) throws ParseException {
        int ss;
        int minutes;
        int hours;
        int day;
        int month;
        int startPos = ParseUtils.nextNonWhite(strDateTime, 0);
        ParseUtils.ParseValue<Integer> parseValue = ParseUtils.getSignedValue(strDateTime, startPos);
        if (parseValue == null) {
            throw new ParseException("Invalid year", startPos);
        }
        int year = parseValue.getValue();
        if (parseValue.getNextPos() < 4) {
            throw new ParseException("Invalid year (must be at least 4 digits)", startPos);
        }
        if ((startPos += parseValue.getNextPos()) >= strDateTime.length() || strDateTime.charAt(startPos) != '-') {
            throw new ParseException("Invalid date", startPos);
        }
        if ((month = ParseUtils.getTwoDigitValue(strDateTime, ++startPos)) <= 0 || month > 12) {
            throw new ParseException("Invalid month", startPos);
        }
        if ((startPos += 2) >= strDateTime.length() || strDateTime.charAt(startPos) != '-') {
            throw new ParseException("Invalid date", startPos);
        }
        if ((day = ParseUtils.getTwoDigitValue(strDateTime, ++startPos)) < 1 || day > 31) {
            throw new ParseException("Invalid day", startPos);
        }
        if ((startPos += 2) >= strDateTime.length() || strDateTime.charAt(startPos) != 'T') {
            throw new ParseException("Missing time separator 'T'", startPos);
        }
        if ((hours = ParseUtils.getTwoDigitValue(strDateTime, ++startPos)) < 0 || hours > 23) {
            throw new ParseException("Invalid hours", startPos);
        }
        if ((startPos += 2) >= strDateTime.length() || strDateTime.charAt(startPos) != ':') {
            throw new ParseException("Invalid date", startPos);
        }
        if ((minutes = ParseUtils.getTwoDigitValue(strDateTime, ++startPos)) < 0 || minutes > 59) {
            throw new ParseException("Invalid minutes", startPos);
        }
        if ((startPos += 2) >= strDateTime.length() || strDateTime.charAt(startPos) != ':') {
            throw new ParseException("Invalid date", startPos);
        }
        if ((ss = ParseUtils.getTwoDigitValue(strDateTime, ++startPos)) < 0 || ss >= 60) {
            throw new ParseException("Invalid second of minute", startPos);
        }
        int ms = 0;
        if ((startPos += 2) < strDateTime.length() && strDateTime.charAt(startPos) == '.') {
            if ((ms = ParseUtils.getThreeDigitValue(strDateTime, ++startPos)) < 0 || ms >= 1000) {
                throw new ParseException("Invalid milliseconds", startPos);
            }
            startPos += 3;
        }
        String timezone = null;
        if (startPos < strDateTime.length()) {
            switch (strDateTime.charAt(startPos)) {
                case 'Z': {
                    timezone = "GMT";
                    ++startPos;
                    break;
                }
                case '+': 
                case '-': {
                    if (startPos + 5 < strDateTime.length()) {
                        timezone = "GMT" + strDateTime.substring(startPos, startPos + 6);
                        break;
                    }
                    throw new ParseException("Invalid timezone", startPos);
                }
                default: {
                    throw new ParseException("Invalid timezone", startPos);
                }
            }
        }
        return new ISO8601DateTime(timezone, year, month, day, hours, minutes, ss, ms);
    }

    @Override
    public String stringValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.calendar.get(0) == 0) {
            int yearBC = this.calendar.get(1) - 1;
            stringBuilder.append('-');
            stringBuilder.append(String.format("%d", yearBC));
        } else {
            stringBuilder.append(String.format("%d", this.calendar.get(1)));
        }
        stringBuilder.append('-');
        stringBuilder.append(String.format("%02d", this.calendar.get(2) + 1));
        stringBuilder.append('-');
        stringBuilder.append(String.format("%02d", this.calendar.get(5)));
        stringBuilder.append('T');
        stringBuilder.append(String.format("%02d", this.calendar.get(11)));
        stringBuilder.append(':');
        stringBuilder.append(String.format("%02d", this.calendar.get(12)));
        stringBuilder.append(':');
        stringBuilder.append(String.format("%02d", this.calendar.get(13)));
        int ms = this.calendar.get(14);
        if (ms != 0) {
            stringBuilder.append('.');
            stringBuilder.append(String.format("%03d", ms));
        }
        if (this.getHasTimeZone()) {
            stringBuilder.append(this.getTimeZone());
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.stringValue();
    }

    private static int compareCalendars(Calendar cal1, Calendar cal2) {
        long cal2Time;
        long cal1Time = cal1.getTimeInMillis();
        if (cal1Time < (cal2Time = cal2.getTimeInMillis())) {
            return -1;
        }
        if (cal1Time > cal2Time) {
            return 1;
        }
        return 0;
    }

    @Override
    public int compareTo(ISO8601DateTime o) {
        if (this.getHasTimeZone()) {
            long oMilliseconds;
            if (o.getHasTimeZone()) {
                return ISO8601DateTime.compareCalendars(this.calendar, o.calendar);
            }
            long thisMilliseconds = this.calendar.getTimeInMillis();
            if (thisMilliseconds < (oMilliseconds = o.calendar.getTimeInMillis()) - 50400000L) {
                return -1;
            }
            if (thisMilliseconds > oMilliseconds + 50400000L) {
                return 1;
            }
            throw new IllegalArgumentException("Cannot compare this ISO8601DateTime with non-time-zoned ISO8601DateTime");
        }
        if (o.getHasTimeZone()) {
            long oMilliseconds;
            long thisMilliseconds = this.calendar.getTimeInMillis();
            if (thisMilliseconds + 50400000L < (oMilliseconds = o.calendar.getTimeInMillis())) {
                return -1;
            }
            if (thisMilliseconds - 50400000L > oMilliseconds) {
                return 1;
            }
            throw new IllegalArgumentException("Cannot compare this ISO8601DateTime with time-zoned ISO8601DateTime");
        }
        return ISO8601DateTime.compareCalendars(this.calendar, o.calendar);
    }
}

