/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.SemanticString;

public final class PortRange
implements SemanticString {
    private int portMin;
    private int portMax;

    public PortRange(int portMinIn, int portMaxIn) {
        this.portMin = portMinIn;
        this.portMax = portMaxIn;
    }

    public static PortRange newInstance(String stringPortRange) throws ParseException {
        if (stringPortRange == null) {
            return null;
        }
        String[] portParts = stringPortRange.split("[-]", -1);
        if (portParts == null || portParts.length == 0) {
            return null;
        }
        if (portParts.length > 2) {
            throw new ParseException("Invalid PortRange \"" + stringPortRange + "\": too many ranges", 0);
        }
        int[] rangeParts = new int[portParts.length];
        try {
            for (int i = 0; i < portParts.length; ++i) {
                rangeParts[i] = portParts[i].length() == 0 ? -1 : Integer.parseInt(portParts[i]);
            }
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Invalid PortRange \"" + stringPortRange + "\": invalid port number", 0);
        }
        if (rangeParts.length == 1) {
            return new PortRange(rangeParts[0], rangeParts[0]);
        }
        return new PortRange(rangeParts[0], rangeParts[1]);
    }

    public int getPortMin() {
        return this.portMin;
    }

    public int getPortMax() {
        return this.portMax;
    }

    public boolean contains(int port) {
        if (port < 0) {
            return false;
        }
        return port >= this.getPortMin() && (this.getPortMax() < 0 || port <= this.getPortMax());
    }

    @Override
    public String stringValue() {
        StringBuilder stringBuilder = new StringBuilder();
        int pMin = this.getPortMin();
        int pMax = this.getPortMax();
        if (pMin >= 0) {
            stringBuilder.append(pMin);
        }
        stringBuilder.append('-');
        if (pMax >= 0) {
            stringBuilder.append(pMax);
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hc = 0;
        if (this.getPortMax() > 0) {
            hc += this.getPortMax();
        }
        if (this.getPortMin() > 0) {
            hc += this.getPortMax();
        }
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof PortRange)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PortRange portRange = (PortRange)obj;
        return this.getPortMax() == portRange.getPortMax() && this.getPortMin() == portRange.getPortMin();
    }

    public String toString() {
        return "{portMin=" + this.getPortMin() + "portMax=" + this.getPortMax() + "}";
    }
}

