/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.std.datatypes.PortRange;

public class RFC2396DomainName
implements SemanticString {
    private String domainName;
    private PortRange portRange;

    public static boolean isValidTopLabel(String topLabel) {
        if (topLabel == null || topLabel.length() == 0) {
            return false;
        }
        if (!Character.isLetter(topLabel.charAt(0))) {
            return false;
        }
        if (topLabel.length() > 1) {
            for (int i = 1; i < topLabel.length() - 1; ++i) {
                char c = topLabel.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-') continue;
                return false;
            }
            if (!Character.isLetterOrDigit(topLabel.charAt(topLabel.length() - 1))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidDomainLabel(String domainLabel) {
        if (domainLabel == null || domainLabel.length() == 0) {
            return false;
        }
        if (!Character.isLetterOrDigit(domainLabel.charAt(0))) {
            return false;
        }
        if (domainLabel.length() > 1) {
            for (int i = 1; i < domainLabel.length() - 1; ++i) {
                char c = domainLabel.charAt(i);
                if (Character.isLetterOrDigit(c) || c == '-') continue;
                return false;
            }
            if (!Character.isLetterOrDigit(domainLabel.charAt(domainLabel.length() - 1))) {
                return false;
            }
        }
        return true;
    }

    public static boolean isValidHostName(String hostName) {
        if (hostName == null || hostName.length() == 0) {
            return false;
        }
        String[] labels = hostName.split("[.]", -1);
        if (labels == null || labels.length == 0) {
            return false;
        }
        for (int i = 0; i < labels.length - 1; ++i) {
            if (RFC2396DomainName.isValidDomainLabel(labels[i])) continue;
            return false;
        }
        return RFC2396DomainName.isValidTopLabel(labels[labels.length - 1]);
    }

    public RFC2396DomainName(String domainNameIn, PortRange portRangeIn) {
        if (!RFC2396DomainName.isValidHostName(domainNameIn)) {
            throw new IllegalArgumentException("Invalid RFC2396 domain name");
        }
        this.domainName = domainNameIn;
        this.portRange = portRangeIn;
    }

    public static RFC2396DomainName newInstance(String rfc2396DomainNameString) throws ParseException {
        String hostName;
        if (rfc2396DomainNameString == null || rfc2396DomainNameString.length() == 0) {
            return null;
        }
        int colonPos = rfc2396DomainNameString.indexOf(58);
        String string = hostName = colonPos < 0 ? rfc2396DomainNameString : rfc2396DomainNameString.substring(0, colonPos);
        if (!RFC2396DomainName.isValidHostName(hostName)) {
            throw new ParseException("Invalid RFC 2396 host name \"" + hostName + "\"", 0);
        }
        PortRange portRange = null;
        if (colonPos >= 0) {
            if (colonPos + 1 >= rfc2396DomainNameString.length()) {
                throw new ParseException("Invalid RFC 2396 port range \"" + rfc2396DomainNameString + "\": no port numbers", colonPos);
            }
            String stringPortRange = rfc2396DomainNameString.substring(colonPos + 1);
            try {
                portRange = PortRange.newInstance(stringPortRange);
            }
            catch (ParseException ex) {
                throw new ParseException("Invalid RFC 2396 port range \"" + stringPortRange + "\"", colonPos);
            }
        }
        return new RFC2396DomainName(hostName, portRange);
    }

    public String getDomainName() {
        return this.domainName;
    }

    public PortRange getPortRange() {
        return this.portRange;
    }

    @Override
    public String stringValue() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.getDomainName() != null) {
            stringBuilder.append(this.getDomainName());
        }
        if (this.getPortRange() != null) {
            stringBuilder.append(':');
            stringBuilder.append(this.getPortRange().stringValue());
        }
        return stringBuilder.toString();
    }

    public int hashCode() {
        int hc = this.getDomainName() == null ? 0 : this.getDomainName().hashCode();
        return hc + (this.getPortRange() == null ? 0 : this.getPortRange().hashCode());
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RFC2396DomainName)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RFC2396DomainName rfc2396DomainName = (RFC2396DomainName)obj;
        if (this.getDomainName() == null ? rfc2396DomainName.getDomainName() != null : !this.getDomainName().equals(rfc2396DomainName.getDomainName())) {
            return false;
        }
        if (this.getPortRange() == null) {
            return rfc2396DomainName.getPortRange() == null;
        }
        return this.getPortRange().equals(rfc2396DomainName.getPortRange());
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needComma = false;
        if (this.getDomainName() != null) {
            stringBuilder.append("domainName=");
            stringBuilder.append(this.getDomainName());
            needComma = true;
        }
        if (this.getPortRange() != null) {
            if (needComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("portRange=");
            stringBuilder.append(this.getPortRange().toString());
            needComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

