/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.api.SemanticString;

public class RFC822Name
implements Comparable<RFC822Name>,
SemanticString {
    private String localName;
    private String domainName;

    public RFC822Name(String localNameIn, String domainNameIn) {
        if (localNameIn == null || localNameIn.length() == 0 || domainNameIn == null || domainNameIn.length() == 0) {
            throw new IllegalArgumentException("Invalid RFC822Name");
        }
        this.localName = localNameIn;
        this.domainName = domainNameIn;
    }

    public static RFC822Name newInstance(String rfc822NameString) throws ParseException {
        if (rfc822NameString == null) {
            return null;
        }
        String[] parts = rfc822NameString.split("[@]", -1);
        if (parts == null || parts.length == 0) {
            return null;
        }
        if (parts.length == 1) {
            throw new ParseException("Invalid RFC822Name \"" + rfc822NameString + "\": missing local part", 0);
        }
        if (parts.length == 2) {
            if (parts[0].length() == 0 || parts[1].length() == 0) {
                throw new ParseException("Invalid RFC822Name \"" + rfc822NameString + "\": empty parts", 0);
            }
            return new RFC822Name(parts[0], parts[1]);
        }
        throw new ParseException("Invalid RFC822Name \"" + rfc822NameString + "\": too many @ delimiters", 0);
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public String getCanonicalDomainName() {
        return this.getDomainName().toLowerCase();
    }

    public String getName() {
        return this.getLocalName() + "@" + this.getDomainName();
    }

    public String getCanonicalName() {
        return this.getLocalName() + "@" + this.getCanonicalDomainName();
    }

    @Override
    public String stringValue() {
        return this.getCanonicalName();
    }

    public boolean match(String pattern) {
        String thatDomainName;
        if (pattern == null) {
            return false;
        }
        String[] patternParts = pattern.split("[@]", -1);
        if (patternParts == null || patternParts.length == 0 || patternParts.length > 1) {
            return false;
        }
        if (patternParts.length == 2 && !patternParts[0].equals(this.getLocalName())) {
            return false;
        }
        String thisDomainName = this.getCanonicalDomainName();
        String string = thatDomainName = patternParts.length == 0 ? patternParts[0] : patternParts[1];
        if (thatDomainName == null) {
            return false;
        }
        if (thatDomainName.startsWith(".")) {
            return thisDomainName.endsWith(thatDomainName);
        }
        return thisDomainName.equals(thatDomainName);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{");
        boolean needComma = false;
        String stringToDump = this.getLocalName();
        if (stringToDump != null) {
            stringBuilder.append("localName=");
            stringBuilder.append(stringToDump);
            needComma = true;
        }
        if ((stringToDump = this.getDomainName()) != null) {
            if (needComma) {
                stringBuilder.append(',');
            }
            stringBuilder.append("domainName=");
            stringBuilder.append(stringToDump);
            needComma = true;
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public int hashCode() {
        return this.getLocalName().hashCode() + this.getCanonicalDomainName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RFC822Name)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.compareTo((RFC822Name)obj) == 0;
    }

    @Override
    public int compareTo(RFC822Name o) {
        if (o == null) {
            return 1;
        }
        return this.getCanonicalName().compareTo(o.getCanonicalName());
    }
}

