/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.ExtendedNamespaceContext;
import org.apache.openaz.xacml.std.datatypes.NodeNamespaceContext;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class XPathExpressionWrapper
implements XPathExpression {
    private XPathExpression xpathExpressionWrapped;
    private String path;
    private ExtendedNamespaceContext namespaceContext;
    private Status status;

    public XPathExpressionWrapper(ExtendedNamespaceContext namespaceContextIn, String pathIn) {
        this.namespaceContext = namespaceContextIn;
        this.path = pathIn;
    }

    public XPathExpressionWrapper(Document documentIn, String pathIn) {
        this(new NodeNamespaceContext(documentIn), pathIn);
        if (pathIn == null || pathIn.length() == 0) {
            throw new IllegalArgumentException("XPathExpression must have XPath value");
        }
    }

    public XPathExpressionWrapper(String pathIn) {
        this((ExtendedNamespaceContext)null, pathIn);
    }

    public XPathExpressionWrapper(Node node) {
        this(node.getOwnerDocument(), node.getTextContent());
    }

    public XPathExpressionWrapper(XPathExpression xpathExpression) {
        this.xpathExpressionWrapped = xpathExpression;
    }

    public synchronized XPathExpression getXpathExpressionWrapped() {
        String thisPath;
        if (this.xpathExpressionWrapped == null && (this.getStatus() == null || this.getStatus().isOk()) && (thisPath = this.getPath()) != null) {
            XPath xPath = XPathFactory.newInstance().newXPath();
            ExtendedNamespaceContext namespaceContextThis = this.getNamespaceContext();
            if (namespaceContextThis != null) {
                xPath.setNamespaceContext(namespaceContextThis);
            }
            try {
                this.xpathExpressionWrapped = xPath.compile(thisPath);
            }
            catch (XPathExpressionException ex) {
                this.status = new StdStatus(StdStatusCode.STATUS_CODE_SYNTAX_ERROR, "Error compiling XPath " + thisPath + ": " + ex.getMessage());
            }
        }
        return this.xpathExpressionWrapped;
    }

    public String getPath() {
        return this.path;
    }

    public ExtendedNamespaceContext getNamespaceContext() {
        return this.namespaceContext;
    }

    public Status getStatus() {
        return this.status;
    }

    @Override
    public Object evaluate(Object item, QName returnType) throws XPathExpressionException {
        XPathExpression thisXPathExpression = this.getXpathExpressionWrapped();
        return thisXPathExpression == null ? null : thisXPathExpression.evaluate(item, returnType);
    }

    @Override
    public String evaluate(Object item) throws XPathExpressionException {
        XPathExpression thisXPathExpression = this.getXpathExpressionWrapped();
        return thisXPathExpression == null ? null : thisXPathExpression.evaluate(item);
    }

    @Override
    public Object evaluate(InputSource source, QName returnType) throws XPathExpressionException {
        XPathExpression thisXPathExpression = this.getXpathExpressionWrapped();
        return thisXPathExpression == null ? null : thisXPathExpression.evaluate(source, returnType);
    }

    @Override
    public String evaluate(InputSource source) throws XPathExpressionException {
        XPathExpression thisXPathExpression = this.getXpathExpressionWrapped();
        return thisXPathExpression == null ? null : thisXPathExpression.evaluate(source);
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof XPathExpressionWrapper)) {
            return false;
        }
        XPathExpressionWrapper other = (XPathExpressionWrapper)o;
        return this.path.equals(other.path);
    }

    public int hashCode() {
        int result = 17;
        if (this.path != null) {
            result = 31 * result + this.path.hashCode();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("path=" + this.path);
        sb.append(",Namespace=" + this.namespaceContext);
        sb.append(",status=" + this.status);
        sb.append(",xpathExpressionWrapped=" + (this.xpathExpressionWrapped == null ? "null" : "(XpathExpression object)"));
        sb.append("}");
        return sb.toString();
    }
}

