/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.datatypes;

import java.text.ParseException;
import org.apache.openaz.xacml.std.datatypes.ISO8601Duration;

public class XPathYearMonthDuration
extends ISO8601Duration
implements Comparable<XPathYearMonthDuration> {
    private int monthsDuration = this.getDurationSign() * (this.getYears() * 12 + this.getMonths());

    public XPathYearMonthDuration(int durationSignIn, int yearsIn, int monthsIn) {
        super(durationSignIn, yearsIn, monthsIn, 0, 0, 0, 0.0);
    }

    public int getMonthsDuration() {
        return this.monthsDuration;
    }

    public XPathYearMonthDuration getCanonical() {
        int monthsLeft = Math.abs(this.getMonthsDuration());
        int years = monthsLeft / 12;
        return new XPathYearMonthDuration(this.getDurationSign(), years, monthsLeft -= years * 12);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof XPathYearMonthDuration)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        return this.getMonthsDuration() == ((XPathYearMonthDuration)obj).getMonthsDuration();
    }

    public static XPathYearMonthDuration newInstance(ISO8601Duration iso8601Duration) throws ParseException {
        if (iso8601Duration == null) {
            return null;
        }
        if (iso8601Duration.getDays() > 0 || iso8601Duration.getHours() > 0 || iso8601Duration.getMinutes() > 0 || iso8601Duration.getFractionalSecs() > 0.0) {
            throw new ParseException("Invalid XPath yearMonthDuraiton \"" + iso8601Duration.toString() + "\": includes days, hours, minutes, or seconds", 0);
        }
        return new XPathYearMonthDuration(iso8601Duration.getDurationSign(), iso8601Duration.getYears(), iso8601Duration.getMonths());
    }

    public static XPathYearMonthDuration newInstance(String iso8601DurationString) throws ParseException {
        return XPathYearMonthDuration.newInstance(ISO8601Duration.newInstance(iso8601DurationString));
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("{super=");
        stringBuilder.append(super.toString());
        stringBuilder.append(",monthsDuration=");
        stringBuilder.append(this.getMonthsDuration());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public int compareTo(XPathYearMonthDuration o) {
        if (o == null) {
            return 1;
        }
        return Integer.compare(this.getMonthsDuration(), o.getMonthsDuration());
    }
}

