/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.dom.DOMAttributeValue;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAttribute {
    private static Log logger = LogFactory.getLog(DOMAttribute.class);

    protected DOMAttribute() {
    }

    public static Attribute newInstance(Identifier category, Node nodeAttribute) throws DOMStructureException {
        int numChildren;
        Element elementAttribute = DOMUtil.getElement(nodeAttribute);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableAttribute mutableAttribute = new StdMutableAttribute();
        mutableAttribute.setCategory(category);
        mutableAttribute.setAttributeId(DOMUtil.getIdentifierAttribute(nodeAttribute, "AttributeId", !bLenient));
        NodeList children = elementAttribute.getChildNodes();
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeValue".equals(child.getLocalName())) {
                        mutableAttribute.addValue(DOMAttributeValue.newInstance(child, category));
                        sawAttributeValue = true;
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeAttribute);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeAttribute);
            }
        }
        if (!sawAttributeValue && !bLenient) {
            throw DOMUtil.newMissingElementException(nodeAttribute, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "AttributeValue");
        }
        mutableAttribute.setIssuer(DOMUtil.getStringAttribute(nodeAttribute, "Issuer"));
        mutableAttribute.setIncludeInResults(DOMUtil.getBooleanAttribute((Node)elementAttribute, "IncludeInResult", !bLenient));
        return new StdAttribute(mutableAttribute);
    }

    public static boolean repair(Node nodeAttribute) throws DOMStructureException {
        int numChildren;
        Element elementAttribute = DOMUtil.getElement(nodeAttribute);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementAttribute, "AttributeId", logger) || result;
        result = DOMUtil.repairBooleanAttribute(elementAttribute, "IncludeInResult", false, logger) || result;
        NodeList children = elementAttribute.getChildNodes();
        boolean sawAttributeValue = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("AttributeValue".equals(child.getLocalName())) {
                        result = DOMAttributeValue.repair(child) || result;
                        sawAttributeValue = true;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementAttribute.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementAttribute.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributeValue) {
            throw new DOMStructureException(DOMUtil.newMissingAttributeException(elementAttribute, "AttributeValue"));
        }
        return result;
    }
}

