/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.std.StdAttributeCategory;
import org.apache.openaz.xacml.std.dom.DOMAttribute;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMAttributeCategory {
    private static final Log logger = LogFactory.getLog(DOMAttributeCategory.class);

    protected DOMAttributeCategory() {
    }

    public static AttributeCategory newInstance(Node nodeAttributeCategory) throws DOMStructureException {
        int numChildren;
        Element elementAttributeCategory = DOMUtil.getElement(nodeAttributeCategory);
        boolean bLenient = DOMProperties.isLenient();
        Identifier identifierCategory = DOMUtil.getIdentifierAttribute(nodeAttributeCategory, "Category", !bLenient);
        ArrayList<Attribute> listAttributes = new ArrayList<Attribute>();
        NodeList children = elementAttributeCategory.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Attribute".equals(child.getLocalName())) {
                        listAttributes.add(DOMAttribute.newInstance(identifierCategory, child));
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeAttributeCategory);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeAttributeCategory);
            }
        }
        return new StdAttributeCategory(identifierCategory, listAttributes);
    }

    public static boolean repair(Node nodeAttributeCategory) throws DOMStructureException {
        int numChildren;
        Element elementAttributeCategory = DOMUtil.getElement(nodeAttributeCategory);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementAttributeCategory, "Category", logger) || result;
        NodeList children = elementAttributeCategory.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Attribute".equals(child.getLocalName())) {
                        result = DOMAttribute.repair(child) || result;
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementAttributeCategory.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementAttributeCategory.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

