/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Version;
import org.apache.openaz.xacml.std.StdIdReference;
import org.apache.openaz.xacml.std.StdVersion;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMIdReference
extends StdIdReference {
    private static Log logger = LogFactory.getLog(DOMIdReference.class);

    protected DOMIdReference(Identifier idReferenceIn, Version versionIn) {
        super(idReferenceIn, versionIn);
    }

    public static IdReference newInstance(Node nodeIdReference) throws DOMStructureException {
        StdVersion version;
        Identifier idReference;
        block3: {
            Element elementIdReference = DOMUtil.getElement(nodeIdReference);
            boolean bLenient = DOMProperties.isLenient();
            idReference = DOMUtil.getIdentifierContent(elementIdReference, !bLenient);
            String versionString = DOMUtil.getStringAttribute(elementIdReference, "Version");
            version = null;
            if (versionString != null) {
                try {
                    version = StdVersion.newInstance(versionString);
                }
                catch (ParseException ex) {
                    if (bLenient) break block3;
                    throw new DOMStructureException(nodeIdReference, "Invalid version \"" + versionString + "\" in \"" + DOMUtil.getNodeLabel(nodeIdReference) + "\"");
                }
            }
        }
        return new DOMIdReference(idReference, version);
    }

    public static boolean repair(Node nodeIdReference) throws DOMStructureException {
        Element elementIdReference = DOMUtil.getElement(nodeIdReference);
        boolean result = false;
        result = DOMUtil.repairIdentifierContent(elementIdReference, logger) || result;
        String versionString = DOMUtil.getStringAttribute(elementIdReference, "Version");
        if (versionString != null) {
            try {
                StdVersion.newInstance(versionString);
            }
            catch (ParseException ex) {
                logger.warn((Object)("Deleting invalid Version string " + versionString), (Throwable)ex);
                elementIdReference.removeAttribute("Version");
                result = true;
            }
        }
        return result;
    }
}

