/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.text.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.IdReferenceMatch;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.VersionMatch;
import org.apache.openaz.xacml.std.StdIdReferenceMatch;
import org.apache.openaz.xacml.std.StdVersionMatch;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMIdReferenceMatch
extends StdIdReferenceMatch {
    private static final Log logger = LogFactory.getLog(DOMIdReferenceMatch.class);

    protected DOMIdReferenceMatch(Identifier idIn, VersionMatch versionIn, VersionMatch earliestVersionIn, VersionMatch latestVersionIn) {
        super(idIn, versionIn, earliestVersionIn, latestVersionIn);
    }

    public static IdReferenceMatch newInstance(Node nodeIdReferenceMatch) throws DOMStructureException {
        StdVersionMatch versionLatest;
        StdVersionMatch versionEarliest;
        StdVersionMatch version;
        Identifier idReferenceMatch;
        block11: {
            String versionLatestString;
            boolean bLenient;
            block10: {
                String versionEarliestString;
                block9: {
                    Element elementIdReferenceMatch = DOMUtil.getElement(nodeIdReferenceMatch);
                    bLenient = DOMProperties.isLenient();
                    idReferenceMatch = DOMUtil.getIdentifierContent(elementIdReferenceMatch, !bLenient);
                    String versionString = DOMUtil.getStringAttribute(elementIdReferenceMatch, "Version");
                    versionEarliestString = DOMUtil.getStringAttribute(elementIdReferenceMatch, "EarliestVersion");
                    versionLatestString = DOMUtil.getStringAttribute(elementIdReferenceMatch, "LatestVersion");
                    version = null;
                    versionEarliest = null;
                    versionLatest = null;
                    if (versionString != null) {
                        try {
                            version = StdVersionMatch.newInstance(versionString);
                        }
                        catch (ParseException ex) {
                            if (bLenient) break block9;
                            throw new DOMStructureException(nodeIdReferenceMatch, "Invalid Version string \"" + versionString + "\" in \"" + DOMUtil.getNodeLabel(nodeIdReferenceMatch), ex);
                        }
                    }
                }
                if (versionEarliestString != null) {
                    try {
                        versionEarliest = StdVersionMatch.newInstance(versionEarliestString);
                    }
                    catch (ParseException ex) {
                        if (bLenient) break block10;
                        throw new DOMStructureException(nodeIdReferenceMatch, "Invalid EarliestVersion string \"" + versionEarliestString + "\" in \"" + DOMUtil.getNodeLabel(nodeIdReferenceMatch), ex);
                    }
                }
            }
            if (versionLatestString != null) {
                try {
                    versionLatest = StdVersionMatch.newInstance(versionLatestString);
                }
                catch (ParseException ex) {
                    if (bLenient) break block11;
                    throw new DOMStructureException(nodeIdReferenceMatch, "Invalid LatestVersion string \"" + versionLatestString + "\" in \"" + DOMUtil.getNodeLabel(nodeIdReferenceMatch), ex);
                }
            }
        }
        return new DOMIdReferenceMatch(idReferenceMatch, version, versionEarliest, versionLatest);
    }

    public static boolean repair(Node nodeIdReferenceMatch) throws DOMStructureException {
        Element elementIdReferenceMatch = DOMUtil.getElement(nodeIdReferenceMatch);
        boolean result = false;
        result = DOMUtil.repairIdentifierContent(elementIdReferenceMatch, logger) || result;
        result = DOMUtil.repairVersionMatchAttribute(elementIdReferenceMatch, "Version", logger) || result;
        result = DOMUtil.repairVersionMatchAttribute(elementIdReferenceMatch, "EarliestVersion", logger) || result;
        result = DOMUtil.repairVersionMatchAttribute(elementIdReferenceMatch, "LatestVersion", logger) || result;
        return result;
    }
}

