/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.util.HashMap;
import java.util.Map;
import org.apache.openaz.xacml.util.XACMLProperties;

public class DOMProperties {
    private static final String PROP_LENIENT = "xacml.dom.lenient";
    private static final String PROP_EXCEPTIONS = "xacml.dom.exceptions";
    private static Map<String, Object> cachedProperties = new HashMap<String, Object>();

    protected static String getSourceProperty(String propertyName) {
        String result = System.getProperty(propertyName);
        if (result == null) {
            try {
                result = XACMLProperties.getProperties().getProperty(propertyName);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected static String getStringProperty(String propertyName) {
        Object cachedProperty = cachedProperties.get(propertyName);
        if (cachedProperty == null) {
            cachedProperty = DOMProperties.getSourceProperty(propertyName);
            cachedProperties.put(propertyName, cachedProperty);
        }
        return cachedProperty instanceof String ? (String)cachedProperty : cachedProperty.toString();
    }

    protected static Boolean getBooleanProperty(String propertyName) {
        String stringProperty;
        Object cachedProperty = cachedProperties.get(propertyName);
        if (cachedProperty == null && (stringProperty = DOMProperties.getSourceProperty(propertyName)) != null) {
            cachedProperty = Boolean.parseBoolean(stringProperty);
            cachedProperties.put(propertyName, cachedProperty);
        }
        if (cachedProperty == null || cachedProperty instanceof Boolean) {
            return (Boolean)cachedProperty;
        }
        return null;
    }

    protected DOMProperties() {
    }

    public static boolean isLenient() {
        Boolean booleanIsLenient = DOMProperties.getBooleanProperty(PROP_LENIENT);
        return booleanIsLenient == null ? false : booleanIsLenient;
    }

    public static void setLenient(boolean b) {
        cachedProperties.put(PROP_LENIENT, b ? Boolean.TRUE : Boolean.FALSE);
    }

    public static boolean throwsExceptions() {
        Boolean booleanThrowsExceptions = DOMProperties.getBooleanProperty(PROP_EXCEPTIONS);
        return booleanThrowsExceptions == null ? true : booleanThrowsExceptions;
    }

    public static void setThrowsExceptions(boolean b) {
        cachedProperties.put(PROP_EXCEPTIONS, b ? Boolean.TRUE : Boolean.FALSE);
    }
}

