/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.RequestReference;
import org.apache.openaz.xacml.std.StdMutableRequestReference;
import org.apache.openaz.xacml.std.StdRequestReference;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMRequestAttributesReference;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMRequestReference {
    private static final Log logger = LogFactory.getLog(DOMRequestReference.class);

    protected DOMRequestReference() {
    }

    public static RequestReference newInstance(Node nodeRequestReference) throws DOMStructureException {
        int numChildren;
        Element elementRequestReference = DOMUtil.getElement(nodeRequestReference);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableRequestReference stdRequestReference = new StdMutableRequestReference();
        NodeList children = elementRequestReference.getChildNodes();
        boolean sawAttributesReference = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributesReference".equals(child.getLocalName())) {
                    stdRequestReference.add(DOMRequestAttributesReference.newInstance(child));
                    sawAttributesReference = true;
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeRequestReference);
            }
        }
        if (!sawAttributesReference && !bLenient) {
            throw DOMUtil.newMissingElementException(nodeRequestReference, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "AttributesReference");
        }
        return new StdRequestReference(stdRequestReference);
    }

    public static boolean repair(Node nodeRequestReference) throws DOMStructureException {
        int numChildren;
        Element elementRequestReference = DOMUtil.getElement(nodeRequestReference);
        boolean result = false;
        NodeList children = elementRequestReference.getChildNodes();
        boolean sawAttributesReference = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "AttributesReference".equals(child.getLocalName())) {
                    result = DOMRequestAttributesReference.repair(child) || result;
                    sawAttributesReference = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementRequestReference.removeChild(child);
                result = true;
            }
        }
        if (!sawAttributesReference) {
            throw DOMUtil.newMissingAttributeException(nodeRequestReference, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "AttributesReference");
        }
        return result;
    }
}

