/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.MissingAttributeDetail;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.StatusDetail;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.StdMutableResponse;
import org.apache.openaz.xacml.std.StdResponse;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.datatypes.ExtendedNamespaceContext;
import org.apache.openaz.xacml.std.datatypes.XPathExpressionWrapper;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMResult;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMResponse {
    private static final Log logger = LogFactory.getLog(DOMResponse.class);

    protected DOMResponse() {
    }

    public static Response newInstance(Node nodeResponse) throws DOMStructureException {
        int numChildren;
        Element elementResponse = DOMUtil.getElement(nodeResponse);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableResponse mutableResponse = new StdMutableResponse();
        NodeList children = elementResponse.getChildNodes();
        boolean sawResult = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "Result".equals(child.getLocalName())) {
                    mutableResponse.add(DOMResult.newInstance(child));
                    sawResult = true;
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeResponse);
            }
        }
        if (!sawResult && !bLenient) {
            throw DOMUtil.newMissingElementException(nodeResponse, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Result");
        }
        return new StdResponse(mutableResponse);
    }

    public static boolean repair(Node nodeResponse) throws DOMStructureException {
        int numChildren;
        Element elementResponse = DOMUtil.getElement(nodeResponse);
        boolean result = false;
        NodeList children = elementResponse.getChildNodes();
        boolean sawResult = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "Result".equals(child.getLocalName())) {
                    result = DOMResult.repair(child) || result;
                    sawResult = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementResponse.removeChild(child);
                result = true;
            }
        }
        if (!sawResult) {
            throw DOMUtil.newMissingElementException(nodeResponse, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Result");
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response load(String xmlString) throws DOMStructureException {
        try (ByteArrayInputStream is = new ByteArrayInputStream(xmlString.getBytes("UTF-8"));){
            Response response = DOMResponse.load(is);
            return response;
        }
        catch (Exception ex) {
            throw new DOMStructureException("Exception loading String Response: " + ex.getMessage(), (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response load(File fileResponse) throws DOMStructureException {
        try (FileInputStream fis = new FileInputStream(fileResponse);){
            Response response = DOMResponse.load(fis);
            return response;
        }
        catch (Exception e) {
            throw new DOMStructureException("File: " + fileResponse.getName() + " " + e.getMessage());
        }
    }

    public static Response load(Path fileResponse) throws DOMStructureException {
        try {
            return DOMResponse.load(Files.newInputStream(fileResponse, new OpenOption[0]));
        }
        catch (Exception e) {
            throw new DOMStructureException(e);
        }
    }

    public static Response load(InputStream is) throws DOMStructureException {
        Response request;
        block7: {
            request = null;
            try {
                Document document = DOMUtil.loadDocument(is);
                if (document == null) {
                    throw new DOMStructureException("Null document returned");
                }
                Element rootNode = DOMUtil.getFirstChildElement(document);
                if (rootNode == null) {
                    throw new DOMStructureException("No child in document");
                }
                if (DOMUtil.isInNamespace(rootNode, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if ("Response".equals(rootNode.getLocalName())) {
                        request = DOMResponse.newInstance(rootNode);
                        if (request == null) {
                            throw new DOMStructureException("Failed to parse Response");
                        }
                        break block7;
                    }
                    throw DOMUtil.newUnexpectedElementException(rootNode);
                }
                throw DOMUtil.newUnexpectedElementException(rootNode);
            }
            catch (Exception ex) {
                throw new DOMStructureException("Exception loading Response from InputStream: " + ex.getMessage(), (Throwable)ex);
            }
        }
        return request;
    }

    public static String toString(Response response) throws Exception {
        return DOMResponse.toString(response, true);
    }

    public static String toString(Response response, boolean prettyPrint) throws Exception {
        String outputString = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            DOMResponse.convert(response, os, prettyPrint);
            outputString = new String(os.toByteArray(), "UTF-8");
        }
        return outputString;
    }

    private static void outputStatusCode(StringBuilder sb, StatusCode statusCode, int tabCount, boolean prettyPrint) {
        String prettyPrintString = "";
        if (prettyPrint) {
            prettyPrintString = "\n";
            for (int i = 0; i < tabCount; ++i) {
                prettyPrintString = prettyPrintString + "\t";
            }
        }
        sb.append(prettyPrintString);
        sb.append("<StatusCode");
        if (statusCode.getStatusCodeValue() != null) {
            sb.append(" Value=\"" + statusCode.getStatusCodeValue().stringValue() + "\"");
        }
        if (statusCode.getChild() == null) {
            sb.append("/>");
        } else {
            sb.append(">");
            DOMResponse.outputStatusCode(sb, statusCode.getChild(), tabCount + 1, prettyPrint);
            sb.append(prettyPrintString);
            sb.append("</StatusCode>");
        }
    }

    private static String outputValueValue(Object obj) throws DOMStructureException {
        if (obj instanceof String || obj instanceof Boolean || obj instanceof Integer || obj instanceof BigInteger) {
            return obj.toString();
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            if (d == Double.NaN) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return obj.toString();
        }
        if (obj instanceof SemanticString) {
            return ((SemanticString)obj).stringValue();
        }
        if (obj instanceof X500Principal || obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof XPathExpressionWrapper) {
            XPathExpressionWrapper xw = (XPathExpressionWrapper)obj;
            return xw.getPath();
        }
        throw new DOMStructureException("Unhandled data type='" + obj.getClass().getName() + "'");
    }

    private static String getNamespaces(Object valueObject) {
        String returnString = "";
        if (!(valueObject instanceof XPathExpressionWrapper)) {
            return returnString;
        }
        XPathExpressionWrapper xw = (XPathExpressionWrapper)valueObject;
        ExtendedNamespaceContext namespaceContext = xw.getNamespaceContext();
        if (namespaceContext != null) {
            Iterator<String> prefixIt = namespaceContext.getAllPrefixes();
            while (prefixIt.hasNext()) {
                String prefix = prefixIt.next();
                String namespaceURI = namespaceContext.getNamespaceURI(prefix);
                if (prefix == null || prefix.equals("")) {
                    returnString = returnString + " xmlns=\"" + namespaceURI + "\"";
                    continue;
                }
                returnString = returnString + " xmlns:" + prefix + "=\"" + namespaceURI + "\"";
            }
        }
        return returnString;
    }

    public static void convert(Response response, OutputStream outputStream) throws IOException, DOMStructureException {
        DOMResponse.convert(response, outputStream, false);
    }

    public static void convert(Response response, OutputStream outputStream, boolean prettyPrint) throws IOException, DOMStructureException {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream);
        if (response == null) {
            throw new DOMStructureException("No Request in convert");
        }
        if (response.getResults() == null || response.getResults().size() == 0) {
            throw new DOMStructureException("No Result in Response");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        if (prettyPrint) {
            sb.append("\n");
        }
        sb.append("<Response");
        sb.append(" xmlns=\"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17\"");
        sb.append(" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"");
        sb.append(" xsi:schemaLocation=\"urn:oasis:names:tc:xacml:3.0:core:schema:wd-17");
        sb.append(" http://docs.oasis-open.org/xacml/3.0/xacml-core-v3-schema-wd-17.xsd\"");
        sb.append(">");
        for (Result result : response.getResults()) {
            if (prettyPrint) {
                sb.append("\n\t");
            }
            sb.append("<Result>");
            if (prettyPrint) {
                sb.append("\n\t\t");
            }
            if (result.getDecision() == null) {
                throw new DOMStructureException("Result missing Decision");
            }
            sb.append("<Decision>" + result.getDecision().toString() + "</Decision>");
            Status status = result.getStatus();
            if (status != null) {
                StatusDetail statusDetail;
                if (prettyPrint) {
                    sb.append("\n\t\t");
                }
                sb.append("<Status>");
                StatusCode statusCode = status.getStatusCode();
                if (statusCode == null) {
                    throw new DOMStructureException("Status must have StatusCode");
                }
                Identifier statusCodeId = statusCode.getStatusCodeValue();
                if (statusCodeId.equals(StdStatusCode.STATUS_CODE_OK.getStatusCodeValue()) && result.getDecision() != Decision.DENY && result.getDecision() != Decision.PERMIT && result.getDecision() != Decision.NOTAPPLICABLE || !statusCodeId.equals(StdStatusCode.STATUS_CODE_OK.getStatusCodeValue()) && result.getDecision() != Decision.INDETERMINATE && result.getDecision() != Decision.INDETERMINATE_DENY && result.getDecision() != Decision.INDETERMINATE_DENYPERMIT && result.getDecision() != Decision.INDETERMINATE_PERMIT) {
                    throw new DOMStructureException("StatusCode '" + statusCodeId.stringValue() + "' does not match Decision '" + result.getDecision().toString());
                }
                DOMResponse.outputStatusCode(sb, statusCode, 3, prettyPrint);
                if (status.getStatusMessage() != null) {
                    if (prettyPrint) {
                        sb.append("\n\t\t\t");
                    }
                    sb.append("<StatusMessage>" + status.getStatusMessage() + "</StatusMessage>");
                }
                if ((statusDetail = status.getStatusDetail()) != null) {
                    if (status.isOk()) {
                        throw new DOMStructureException("Status '" + statusCodeId.stringValue() + "' must not return StatusDetail");
                    }
                    if (statusCodeId.stringValue().equals(XACML3.ID_STATUS_MISSING_ATTRIBUTE.stringValue()) && status.getStatusDetail().getMissingAttributeDetails() == null) {
                        throw new DOMStructureException("Status '" + statusCodeId.stringValue() + "' has StatusDetail without MissingAttributeDetail");
                    }
                    if (statusCodeId.stringValue().equals(XACML3.ID_STATUS_SYNTAX_ERROR.stringValue())) {
                        throw new DOMStructureException("Status '" + statusCodeId.stringValue() + "' must not return StatusDetail");
                    }
                    if (statusCodeId.stringValue().equals(XACML3.ID_STATUS_PROCESSING_ERROR.stringValue())) {
                        throw new DOMStructureException("Status '" + statusCodeId.stringValue() + "' must not return StatusDetail");
                    }
                    if (result.getStatus().getStatusDetail().getMissingAttributeDetails() != null) {
                        if (prettyPrint) {
                            sb.append("\n\t\t\t");
                        }
                        sb.append("<StatusDetail>");
                        for (MissingAttributeDetail mad : statusDetail.getMissingAttributeDetails()) {
                            if (mad.getAttributeId() == null || mad.getCategory() == null || mad.getDataTypeId() == null) {
                                throw new DOMStructureException("MissingAttributeDetail is missing required AttributeId, Category or DataTypeId");
                            }
                            if (prettyPrint) {
                                sb.append("\n\t\t\t\t");
                            }
                            sb.append("<MissingAttributeDetail");
                            sb.append(" Category=\"" + mad.getCategory().stringValue() + "\"");
                            sb.append(" AttributeId=\"" + mad.getAttributeId().stringValue() + "\"");
                            sb.append(" DataTypeId=\"" + mad.getDataTypeId().stringValue() + "\"");
                            if (mad.getIssuer() != null) {
                                sb.append(" Issuer=\"" + mad.getIssuer() + "\"");
                            }
                            sb.append(">");
                            if (mad.getAttributeValues() != null) {
                                for (AttributeValue<?> value : mad.getAttributeValues()) {
                                    if (prettyPrint) {
                                        sb.append("\n\t\t\t\t\t");
                                    }
                                    sb.append("<AttributeValue" + DOMResponse.getNamespaces(value.getValue()) + ">" + DOMResponse.outputValueValue(value.getValue()) + "</AttributeValue>");
                                }
                            }
                            if (prettyPrint) {
                                sb.append("\n\t\t\t\t");
                            }
                            sb.append("</MissingAttributeDetail>");
                        }
                        if (prettyPrint) {
                            sb.append("\n\t\t\t");
                        }
                        sb.append("</StatusDetail>");
                    }
                }
                if (prettyPrint) {
                    sb.append("\n\t\t");
                }
                sb.append("</Status>");
            }
            if (result.getObligations() != null && result.getObligations().size() > 0) {
                if (prettyPrint) {
                    sb.append("\n\t\t");
                }
                sb.append("<Obligations>");
                for (Obligation obligation : result.getObligations()) {
                    if (obligation.getId() == null) {
                        throw new DOMStructureException("Obligation must have ObligationId");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t\t");
                    }
                    sb.append("<Obligation ObligationId=\"" + obligation.getId().stringValue() + "\">");
                    for (AttributeAssignment aa : obligation.getAttributeAssignments()) {
                        if (prettyPrint) {
                            sb.append("\n\t\t\t\t");
                        }
                        sb.append("<AttributeAssignment");
                        if (aa.getAttributeId() == null) {
                            throw new DOMStructureException("Obligation AttributeAssignment must have AttributeId");
                        }
                        sb.append(" AttributeId=\"" + aa.getAttributeId().stringValue() + "\"");
                        if (aa.getDataTypeId() == null || aa.getAttributeValue() == null || aa.getAttributeValue().getValue() == null) {
                            throw new DOMStructureException("Obligation AttributeAssignment '" + aa.getAttributeId().stringValue() + "' must have DataType and Value");
                        }
                        sb.append(" DataType=\"" + aa.getDataTypeId().stringValue() + "\"" + DOMResponse.getNamespaces(aa.getAttributeValue().getValue()) + ">");
                        sb.append(DOMResponse.outputValueValue(aa.getAttributeValue().getValue()));
                        sb.append("</AttributeAssignment>");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t\t");
                    }
                    sb.append("</Obligation>");
                }
                if (prettyPrint) {
                    sb.append("\n\t\t");
                }
                sb.append("</Obligations>");
            }
            if (result.getAssociatedAdvice() != null && result.getAssociatedAdvice().size() > 0) {
                if (prettyPrint) {
                    sb.append("\n\t\t");
                }
                sb.append("<AssociatedAdvice>");
                for (Advice advice : result.getAssociatedAdvice()) {
                    if (advice.getId() == null) {
                        throw new DOMStructureException("Advice must have AdviceId");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t\t");
                    }
                    sb.append("<Advice AdviceId=\"" + advice.getId().stringValue() + "\">");
                    for (AttributeAssignment aa : advice.getAttributeAssignments()) {
                        if (prettyPrint) {
                            sb.append("\n\t\t\t\t");
                        }
                        sb.append("<AttributeAssignment");
                        if (aa.getAttributeId() == null) {
                            throw new DOMStructureException("Advice AttributeAssignment must have AttributeId");
                        }
                        sb.append(" AttributeId=\"" + aa.getAttributeId().stringValue() + "\"");
                        if (aa.getDataTypeId() == null || aa.getAttributeValue() == null || aa.getAttributeValue().getValue() == null) {
                            throw new DOMStructureException("Advice AttributeAssignment '" + aa.getAttributeId().stringValue() + "' must have DataType and Value");
                        }
                        sb.append(" DataType=\"" + aa.getDataTypeId().stringValue() + "\"" + DOMResponse.getNamespaces(aa.getAttributeValue().getValue()) + ">");
                        sb.append(DOMResponse.outputValueValue(aa.getAttributeValue().getValue()));
                        sb.append("</AttributeAssignment>");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t\t");
                    }
                    sb.append("</Advice>");
                }
                if (prettyPrint) {
                    sb.append("\n\t\t");
                }
                sb.append("</AssociatedAdvice>");
            }
            if (result.getAttributes() != null && result.getAttributes().size() > 0) {
                for (AttributeCategory category : result.getAttributes()) {
                    if (prettyPrint) {
                        sb.append("\n\t\t");
                    }
                    if (category.getCategory() == null) {
                        throw new DOMStructureException("Attributes must have Category");
                    }
                    sb.append("<Attributes Category=\"" + category.getCategory().stringValue() + "\">");
                    for (Attribute attr : category.getAttributes()) {
                        if (!attr.getIncludeInResults()) continue;
                        if (prettyPrint) {
                            sb.append("\n\t\t\t");
                        }
                        sb.append("<Attribute IncludeInResult=\"" + attr.getIncludeInResults() + "\"");
                        if (attr.getAttributeId() == null) {
                            throw new DOMStructureException("Attribute inf Category '" + category.getCategory().stringValue() + "' must have AttributeId");
                        }
                        sb.append(" AttributeId=\"" + attr.getAttributeId().stringValue() + "\"");
                        if (attr.getIssuer() == null) {
                            sb.append(">");
                        } else {
                            sb.append(" Issuer=\"" + attr.getIssuer() + "\">");
                        }
                        if (attr.getValues().size() == 0) {
                            throw new DOMStructureException("Attribute '" + attr.getAttributeId() + "' must have at least one value");
                        }
                        for (AttributeValue<?> value : attr.getValues()) {
                            if (value.getDataTypeId() == null || value.getValue() == null) {
                                throw new DOMStructureException("Attribute '" + attr.getAttributeId() + "' has AttributeValue missing either DataType or Value");
                            }
                            if (prettyPrint) {
                                sb.append("\n\t\t\t\t");
                            }
                            sb.append("<AttributeValue DataType=\"" + value.getDataTypeId().stringValue() + "\"");
                            if (value.getXPathCategory() != null) {
                                sb.append(" XPathCategory=\"" + value.getXPathCategory().stringValue() + "\"");
                            }
                            sb.append(">");
                            sb.append(DOMResponse.outputValueValue(value.getValue()));
                            sb.append("</AttributeValue>");
                        }
                        if (prettyPrint) {
                            sb.append("\n\t\t\t");
                        }
                        sb.append("</Attribute>");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t");
                    }
                    sb.append("</Attributes>");
                }
            }
            Collection<IdReference> policyIds = result.getPolicyIdentifiers();
            Collection<IdReference> policySetIds = result.getPolicySetIdentifiers();
            if (policyIds != null && policyIds.size() > 0 || policySetIds != null && policySetIds.size() > 0) {
                if (prettyPrint) {
                    sb.append("\n\t\t\t");
                }
                sb.append("<PolicyIdentifierList>");
                for (IdReference idReference : policyIds) {
                    if (idReference == null) {
                        throw new DOMStructureException("PolicyIdentifiers has null IdReference");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t\t\t");
                    }
                    sb.append("<PolicyIdReference");
                    if (idReference.getVersion() != null) {
                        sb.append(" Version=\"" + idReference.getVersion().stringValue() + "\">");
                    } else {
                        sb.append(">");
                    }
                    sb.append(idReference.getId().stringValue());
                    sb.append("</PolicyIdReference>");
                }
                for (IdReference idReference : policySetIds) {
                    if (idReference == null) {
                        throw new DOMStructureException("PolicySetIdentifiers has null IdReference");
                    }
                    if (prettyPrint) {
                        sb.append("\n\t\t\t\t");
                    }
                    sb.append("<PolicySetIdReference");
                    if (idReference.getVersion() != null) {
                        sb.append(" Version=\"" + idReference.getVersion().stringValue() + "\">");
                    } else {
                        sb.append(">");
                    }
                    sb.append(idReference.getId().stringValue());
                    sb.append("</PolicySetIdReference>");
                }
                if (prettyPrint) {
                    sb.append("\n\t\t\t");
                }
                sb.append("</PolicyIdentifierList>");
            }
            if (prettyPrint) {
                sb.append("\n\t");
            }
            sb.append("</Result>");
        }
        if (prettyPrint) {
            sb.append("\n");
        }
        sb.append("</Response>");
        osw.write(sb.toString());
        osw.flush();
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            for (String xmlFileName : args) {
                File fileXml = new File(xmlFileName);
                if (!fileXml.exists()) {
                    System.err.println("Input file \"" + fileXml.getAbsolutePath() + "\" does not exist.");
                    continue;
                }
                if (!fileXml.canRead()) {
                    System.err.println("Permission denied reading input file \"" + fileXml.getAbsolutePath() + "\"");
                    continue;
                }
                System.out.println(fileXml.getAbsolutePath() + ":");
                try {
                    Node nodeResponse;
                    Document documentResponse = DOMUtil.loadDocument(fileXml);
                    assert (documentResponse != null);
                    NodeList children = documentResponse.getChildNodes();
                    if (children == null || children.getLength() == 0) {
                        System.err.println("No Responses found in \"" + fileXml.getAbsolutePath() + "\"");
                        continue;
                    }
                    if (children.getLength() > 1) {
                        System.err.println("Multiple Responses found in \"" + fileXml.getAbsolutePath() + "\"");
                    }
                    if (!(nodeResponse = children.item(0)).getLocalName().equals("Response")) {
                        System.err.println("\"" + fileXml.getAbsolutePath() + "\" is not a Response");
                        continue;
                    }
                    Response domResponse = DOMResponse.newInstance(nodeResponse);
                    System.out.println(domResponse.toString());
                    System.out.println();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }
}

