/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.std.StdMutableResult;
import org.apache.openaz.xacml.std.StdResult;
import org.apache.openaz.xacml.std.dom.DOMAdvice;
import org.apache.openaz.xacml.std.dom.DOMAttributeCategory;
import org.apache.openaz.xacml.std.dom.DOMIdReference;
import org.apache.openaz.xacml.std.dom.DOMObligation;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStatus;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMResult {
    private static final Log logger = LogFactory.getLog(DOMResult.class);

    protected DOMResult() {
    }

    public static Result newInstance(Node nodeResult) throws DOMStructureException {
        int numChildren;
        Element elementResult = DOMUtil.getElement(nodeResult);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableResult mutableResult = new StdMutableResult();
        NodeList children = elementResult.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Decision".equals(childName)) {
                        Decision decision = Decision.get(child.getTextContent());
                        if (decision == null) {
                            if (bLenient) continue;
                            throw new DOMStructureException(child, "Unknown Decision \"" + child.getTextContent() + "\" in \"" + DOMUtil.getNodeLabel(child) + "\"");
                        }
                        mutableResult.setDecision(decision);
                        continue;
                    }
                    if ("Status".equals(childName)) {
                        mutableResult.setStatus(DOMStatus.newInstance(child));
                        continue;
                    }
                    if ("Obligations".equals(childName)) {
                        mutableResult.addObligations(DOMObligation.newList(child));
                        continue;
                    }
                    if ("AssociatedAdvice".equals(childName)) {
                        mutableResult.addAdvice(DOMAdvice.newList(child));
                        continue;
                    }
                    if ("Attributes".equals(childName)) {
                        mutableResult.addAttributeCategory(DOMAttributeCategory.newInstance(child));
                        continue;
                    }
                    if ("PolicyIdentifierList".equals(childName)) {
                        int numGrandchildren;
                        NodeList grandchildren = child.getChildNodes();
                        if (grandchildren == null || (numGrandchildren = grandchildren.getLength()) <= 0) continue;
                        for (int j = 0; j < numGrandchildren; ++j) {
                            Node grandchild = grandchildren.item(j);
                            if (!DOMUtil.isElement(grandchild)) continue;
                            String grandchildName = grandchild.getLocalName();
                            if (DOMUtil.isInNamespace(grandchild, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                                if ("PolicyIdReference".equals(grandchildName)) {
                                    mutableResult.addPolicyIdentifier(DOMIdReference.newInstance(grandchild));
                                    continue;
                                }
                                if ("PolicySetIdReference".equals(grandchildName)) {
                                    mutableResult.addPolicySetIdentifier(DOMIdReference.newInstance(grandchild));
                                    continue;
                                }
                                if (bLenient) continue;
                                throw DOMUtil.newUnexpectedElementException(grandchild, child);
                            }
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException(grandchild, child);
                        }
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeResult);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeResult);
            }
        }
        if (mutableResult.getDecision() == null && !bLenient) {
            throw DOMUtil.newMissingElementException(nodeResult, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Decision");
        }
        return new StdResult(mutableResult);
    }

    public static boolean repair(Node nodeResult) throws DOMStructureException {
        int numChildren;
        Element elementResult = DOMUtil.getElement(nodeResult);
        boolean result = false;
        NodeList children = elementResult.getChildNodes();
        boolean sawDecision = false;
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    String childName = child.getLocalName();
                    if ("Decision".equals(childName)) {
                        Decision decision = Decision.get(child.getTextContent());
                        if (decision == null) {
                            throw new DOMStructureException(child, "Unknown Decision \"" + child.getTextContent() + "\" in \"" + DOMUtil.getNodeLabel(child) + "\"");
                        }
                        sawDecision = true;
                        continue;
                    }
                    if ("Status".equals(childName)) {
                        result = DOMStatus.repair(child) || result;
                        continue;
                    }
                    if ("Obligations".equals(childName)) {
                        result = DOMObligation.repairList(child) || result;
                        continue;
                    }
                    if ("AssociatedAdvice".equals(childName)) {
                        result = DOMAdvice.repairList(child) || result;
                        continue;
                    }
                    if ("Attributes".equals(childName)) {
                        result = DOMAttributeCategory.repair(child) || result;
                        continue;
                    }
                    if ("PolicyIdentifierList".equals(childName)) {
                        int numGrandchildren;
                        NodeList grandchildren = child.getChildNodes();
                        if (grandchildren == null || (numGrandchildren = grandchildren.getLength()) <= 0) continue;
                        for (int j = 0; j < numGrandchildren; ++j) {
                            Node grandchild = grandchildren.item(j);
                            if (!DOMUtil.isElement(grandchild)) continue;
                            String grandchildName = grandchild.getLocalName();
                            if (DOMUtil.isInNamespace(grandchild, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                                if ("PolicyIdReference".equals(grandchildName)) {
                                    result = DOMIdReference.repair(grandchild) || result;
                                    continue;
                                }
                                if ("PolicySetIdReference".equals(grandchildName)) {
                                    result = DOMIdReference.repair(grandchild) || result;
                                    continue;
                                }
                                logger.warn((Object)("Unexpected element " + grandchild.getNodeName()));
                                child.removeChild(grandchild);
                                result = true;
                                continue;
                            }
                            logger.warn((Object)("Unexpected element " + grandchild.getNodeName()));
                            child.removeChild(grandchild);
                            result = true;
                        }
                        continue;
                    }
                    logger.warn((Object)("Unexpected element " + child.getNodeName()));
                    elementResult.removeChild(child);
                    result = true;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementResult.removeChild(child);
                result = true;
            }
        }
        if (!sawDecision) {
            throw DOMUtil.newMissingElementException(nodeResult, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17", "Decision");
        }
        return result;
    }
}

