/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMStatusCode {
    private static final Log logger = LogFactory.getLog(DOMStatusCode.class);

    protected DOMStatusCode() {
    }

    public static StatusCode newInstance(Node nodeStatusCode) throws DOMStructureException {
        int numChildren;
        Element elementStatusCode = DOMUtil.getElement(nodeStatusCode);
        boolean bLenient = DOMProperties.isLenient();
        Identifier identifierStatusCode = DOMUtil.getIdentifierAttribute((Node)elementStatusCode, "Value", !bLenient);
        StatusCode statusCodeChild = null;
        NodeList children = elementStatusCode.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if (child.getLocalName().equals("StatusCode")) {
                        if (statusCodeChild != null) {
                            if (bLenient) continue;
                            throw DOMUtil.newUnexpectedElementException(child, nodeStatusCode);
                        }
                        statusCodeChild = DOMStatusCode.newInstance(child);
                        continue;
                    }
                    if (bLenient) continue;
                    throw DOMUtil.newUnexpectedElementException(child, nodeStatusCode);
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeStatusCode);
            }
        }
        return new StdStatusCode(identifierStatusCode, statusCodeChild);
    }

    public static boolean repair(Node nodeStatusCode) throws DOMStructureException {
        int numChildren;
        Element elementStatusCode = DOMUtil.getElement(nodeStatusCode);
        boolean result = false;
        result = DOMUtil.repairIdentifierAttribute(elementStatusCode, "Value", logger) || result;
        NodeList children = elementStatusCode.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    result = DOMStatusCode.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementStatusCode.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

