/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.dom;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.StatusDetail;
import org.apache.openaz.xacml.std.StdMutableStatusDetail;
import org.apache.openaz.xacml.std.StdStatusDetail;
import org.apache.openaz.xacml.std.dom.DOMMissingAttributeDetail;
import org.apache.openaz.xacml.std.dom.DOMProperties;
import org.apache.openaz.xacml.std.dom.DOMStructureException;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMStatusDetail {
    private static final Log logger = LogFactory.getLog(DOMStatusDetail.class);

    protected DOMStatusDetail() {
    }

    public static StatusDetail newInstance(Node nodeStatusDetail) throws DOMStructureException {
        int numChildren;
        Element elementStatusDetail = DOMUtil.getElement(nodeStatusDetail);
        boolean bLenient = DOMProperties.isLenient();
        StdMutableStatusDetail mutableStatusDetail = new StdMutableStatusDetail();
        NodeList children = elementStatusDetail.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "MissingAttributeDetail".equals(child.getLocalName())) {
                    mutableStatusDetail.addMissingAttributeDetail(DOMMissingAttributeDetail.newInstance(child));
                    continue;
                }
                if (bLenient) continue;
                throw DOMUtil.newUnexpectedElementException(child, nodeStatusDetail);
            }
        }
        return new StdStatusDetail(mutableStatusDetail);
    }

    public static boolean repair(Node nodeStatusDetail) throws DOMStructureException {
        int numChildren;
        Element elementStatusDetail = DOMUtil.getElement(nodeStatusDetail);
        boolean result = false;
        NodeList children = elementStatusDetail.getChildNodes();
        if (children != null && (numChildren = children.getLength()) > 0) {
            for (int i = 0; i < numChildren; ++i) {
                Node child = children.item(i);
                if (!DOMUtil.isElement(child)) continue;
                if (DOMUtil.isInNamespace(child, "urn:oasis:names:tc:xacml:3.0:core:schema:wd-17") && "MissingAttributeDetail".equals(child.getLocalName())) {
                    result = DOMMissingAttributeDetail.repair(child) || result;
                    continue;
                }
                logger.warn((Object)("Unexpected element " + child.getNodeName()));
                elementStatusDetail.removeChild(child);
                result = true;
            }
        }
        return result;
    }
}

