/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.security.auth.x500.X500Principal;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Request;
import org.apache.openaz.xacml.api.RequestAttributes;
import org.apache.openaz.xacml.api.RequestAttributesReference;
import org.apache.openaz.xacml.api.RequestReference;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdMutableRequest;
import org.apache.openaz.xacml.std.StdMutableRequestAttributes;
import org.apache.openaz.xacml.std.StdMutableRequestReference;
import org.apache.openaz.xacml.std.StdRequest;
import org.apache.openaz.xacml.std.StdRequestAttributesReference;
import org.apache.openaz.xacml.std.StdRequestDefaults;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.ExtendedNamespaceContext;
import org.apache.openaz.xacml.std.datatypes.StringNamespaceContext;
import org.apache.openaz.xacml.std.datatypes.XPathExpressionWrapper;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.std.json.JSONStructureException;
import org.apache.openaz.xacml.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class JSONRequest {
    private static final Log logger = LogFactory.getLog(JSONRequest.class);
    private static Map<String, Identifier> shorthandMap = null;
    private static DataTypeFactory dataTypeFactory = null;

    protected JSONRequest() {
    }

    private static Boolean makeBoolean(Object value, String location) throws JSONStructureException {
        if (value == null || value instanceof Boolean) {
            return (Boolean)value;
        }
        try {
            Boolean b = DataTypes.DT_BOOLEAN.convert(value);
            logger.warn((Object)(location + " has string containing boolean, should be unquoted boolean value"));
            return b;
        }
        catch (Exception e) {
            throw new JSONStructureException(location + " must be Boolean");
        }
    }

    private static void checkUnknown(String component, Map<?, ?> map) throws JSONStructureException {
        if (map.size() == 0) {
            return;
        }
        String keys = null;
        Iterator<?> it = map.keySet().iterator();
        while (it.hasNext()) {
            if (keys == null) {
                keys = "'" + it.next().toString() + "'";
                continue;
            }
            keys = keys + ", '" + it.next().toString() + "'";
        }
        String message = component + " contains unknown element" + (map.size() == 1 ? " " : "s ") + keys;
        throw new JSONStructureException(message);
    }

    private static AttributeValue<Object> convertXPathExpressionMapToAttributeValue(Map<?, ?> valueMap) throws JSONStructureException {
        Object xpathCategoryObject = valueMap.remove("XPathCategory");
        Object xpathObject = valueMap.remove("XPath");
        if (!(xpathCategoryObject instanceof String) || !(xpathObject instanceof String)) {
            throw new JSONStructureException("XpathCategory and XPath must both be strings");
        }
        String xpathCategoryString = (String)xpathCategoryObject;
        String xpathString = (String)xpathObject;
        if (xpathCategoryString == null || xpathCategoryString.length() == 0 || xpathString == null || xpathString.length() == 0) {
            throw new JSONStructureException("XPathCategory or XPath missing or 0-length");
        }
        IdentifierImpl xpathCategoryId = new IdentifierImpl(xpathCategoryString);
        StringNamespaceContext namespaceContext = null;
        Object namespacesObject = valueMap.remove("Namespaces");
        if (namespacesObject != null) {
            if (!(namespacesObject instanceof List)) {
                throw new JSONStructureException("Namespaces must be an array");
            }
            List namespacesList = (List)namespacesObject;
            if (namespacesList.size() > 0) {
                namespaceContext = new StringNamespaceContext();
                for (Object n : namespacesList) {
                    if (!(n instanceof Map)) {
                        throw new JSONStructureException("Namespace within Namespaces array must be object");
                    }
                    Map namespaceMap = (Map)n;
                    Object namespaceObject = namespaceMap.remove("Namespace");
                    if (namespaceObject == null || !(namespaceObject instanceof String)) {
                        throw new JSONStructureException("Namespace object within Namespaces array must contain Namespace string member");
                    }
                    Object prefixObject = namespaceMap.remove("Prefix");
                    if (prefixObject != null && !(prefixObject instanceof String)) {
                        throw new JSONStructureException("Namespace object within Namespaces array Prefix must be string");
                    }
                    JSONRequest.checkUnknown("Namespaces item", namespaceMap);
                    try {
                        namespaceContext.add((String)prefixObject, (String)namespaceObject);
                    }
                    catch (Exception e) {
                        throw new JSONStructureException("Unable to add namespace prefix='" + prefixObject + "' URI='" + namespaceObject + "'");
                    }
                }
            }
        }
        XPathExpressionWrapper xpathExpressionWrapper = new XPathExpressionWrapper(namespaceContext, xpathString);
        StdAttributeValue<Object> attributeValue = new StdAttributeValue<Object>(DataTypes.DT_XPATHEXPRESSION.getId(), xpathExpressionWrapper, xpathCategoryId);
        JSONRequest.checkUnknown("XPathExpression", valueMap);
        return attributeValue;
    }

    private static void initShorthandMap() throws JSONStructureException {
        Field[] declaredFields = XACML3.class.getDeclaredFields();
        shorthandMap = new HashMap<String, Identifier>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("ID_DATATYPE") || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                Identifier id = (Identifier)field.get(null);
                String longName = id.stringValue();
                int sharpIndex = longName.lastIndexOf("#");
                if (sharpIndex <= 0) {
                    if (!longName.contains(":data-type:")) continue;
                    sharpIndex = longName.lastIndexOf(":");
                }
                String shortName = longName.substring(sharpIndex + 1);
                shorthandMap.put(longName, id);
                shorthandMap.put(shortName, id);
            }
            catch (Exception e) {
                throw new JSONStructureException("Error loading ID Table, e=" + e);
            }
        }
    }

    private static List<Attribute> parseAttribute(Identifier categoryID, ArrayList<?> attributes) throws JSONStructureException {
        Iterator<?> iterAttributes = attributes.iterator();
        ArrayList<Attribute> collectedAttributes = new ArrayList<Attribute>();
        while (iterAttributes.hasNext()) {
            Map attributeMap = (Map)iterAttributes.next();
            if (!(attributeMap instanceof Map)) {
                throw new JSONStructureException("Expect Attribute content to be Map got " + attributeMap.getClass());
            }
            Attribute attribute = JSONRequest.parseAttribute(categoryID, attributeMap);
            collectedAttributes.add(attribute);
        }
        return collectedAttributes;
    }

    private static Attribute parseAttribute(Identifier categoryID, Map<?, ?> attributeMap) throws JSONStructureException {
        Object DataType2;
        Object idString = attributeMap.remove("AttributeId");
        if (idString == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Attribute missing AttributeId, looking for Id");
            }
            if ((idString = attributeMap.remove("Id")) == null) {
                throw new JSONStructureException("Attribute missing AttributeId (and Id)");
            }
        } else if (attributeMap.remove("Id") != null) {
            throw new JSONStructureException("Found both AttributeId '" + idString + "' and Id field.  Please use only AttributeId.");
        }
        if (!(idString instanceof String)) {
            throw new JSONStructureException("AttributeId must be String, got " + idString.getClass());
        }
        IdentifierImpl id = new IdentifierImpl(idString.toString());
        Object Value = attributeMap.remove("Value");
        if (Value == null) {
            throw new JSONStructureException("Attribute missing Value");
        }
        String Issuer = (String)attributeMap.remove("Issuer");
        Object includeInResultObject = attributeMap.remove("IncludeInResult");
        Boolean includeInResult = JSONRequest.makeBoolean(includeInResultObject, "IncludeInResult");
        if (includeInResult == null) {
            includeInResult = Boolean.FALSE;
        }
        if ((DataType2 = attributeMap.remove("DataType")) != null && !(DataType2 instanceof String)) {
            throw new JSONStructureException("DataType must be String, got " + DataType2.getClass());
        }
        String dataTypeString = null;
        if (DataType2 != null) {
            dataTypeString = DataType2.toString();
        }
        Identifier dataTypeId = shorthandMap.get(dataTypeString);
        if (DataType2 != null && dataTypeId == null) {
            throw new JSONStructureException("Unknown DataType '" + dataTypeString + "'");
        }
        if (Value instanceof List) {
            List valueList = (List)Value;
            if (valueList.size() > 0) {
                Identifier inferredDataTypeId = null;
                if (dataTypeId == null) {
                    for (Object item : (List)Value) {
                        if (inferredDataTypeId == null) {
                            if (item instanceof Boolean) {
                                inferredDataTypeId = DataTypes.DT_BOOLEAN.getId();
                                continue;
                            }
                            if (item instanceof Integer) {
                                inferredDataTypeId = DataTypes.DT_INTEGER.getId();
                                continue;
                            }
                            if (item instanceof Double) {
                                inferredDataTypeId = DataTypes.DT_DOUBLE.getId();
                                continue;
                            }
                            inferredDataTypeId = DataTypes.DT_STRING.getId();
                            continue;
                        }
                        if (!inferredDataTypeId.equals(DataTypes.DT_INTEGER.getId()) || !(item instanceof Double)) continue;
                        inferredDataTypeId = DataTypes.DT_DOUBLE.getId();
                    }
                    dataTypeId = inferredDataTypeId;
                }
            }
        } else if (dataTypeId == null) {
            dataTypeId = Value instanceof Integer ? DataTypes.DT_INTEGER.getId() : (Value instanceof Double ? DataTypes.DT_DOUBLE.getId() : (Value instanceof Boolean ? DataTypes.DT_BOOLEAN.getId() : DataTypes.DT_STRING.getId()));
        }
        StdAttribute attribute = null;
        DataType<?> dataType = dataTypeFactory.getDataType(dataTypeId);
        Object incomingValue = null;
        try {
            if (Value instanceof List) {
                ArrayList attributeValueList = new ArrayList();
                for (Object o : (List)Value) {
                    AttributeValue<Object> attributeValue;
                    incomingValue = o;
                    if (dataType.getId().equals(DataTypes.DT_XPATHEXPRESSION.getId())) {
                        if (!(o instanceof Map)) {
                            throw new JSONStructureException("XPathExpression must contain object, not simple value");
                        }
                        attributeValue = JSONRequest.convertXPathExpressionMapToAttributeValue((Map)o);
                    } else {
                        Object convertedValue = dataType.convert(o);
                        attributeValue = new StdAttributeValue(dataTypeId, convertedValue);
                        if ((convertedValue instanceof Integer || convertedValue instanceof Boolean || convertedValue instanceof Double) && o instanceof String || convertedValue instanceof Double && o instanceof Integer || convertedValue instanceof String && (o instanceof Integer || o instanceof Boolean || o instanceof Double)) {
                            logger.warn((Object)("Attribute Id '" + id.stringValue() + "' Value '" + incomingValue + "' in Array auto-converted from '" + o.getClass().getName() + "' to type '" + dataType.getId().stringValue()));
                        }
                    }
                    attributeValueList.add(attributeValue);
                }
                attribute = new StdAttribute(categoryID, (Identifier)id, attributeValueList, Issuer, (boolean)includeInResult);
            } else {
                AttributeValue<Object> attributeValue;
                incomingValue = Value;
                if (dataType.getId().equals(DataTypes.DT_XPATHEXPRESSION.getId())) {
                    if (!(Value instanceof Map)) {
                        throw new JSONStructureException("XPathExpression must contain object, not simple value");
                    }
                    attributeValue = JSONRequest.convertXPathExpressionMapToAttributeValue((Map)Value);
                } else {
                    Object convertedValue = dataType.convert(Value);
                    attributeValue = new StdAttributeValue(dataTypeId, convertedValue);
                    if ((convertedValue instanceof BigInteger || convertedValue instanceof Boolean || convertedValue instanceof Double) && Value instanceof String || convertedValue instanceof Double && Value instanceof Integer || convertedValue instanceof String && (Value instanceof Integer || Value instanceof Boolean || Value instanceof Double)) {
                        logger.warn((Object)("Attribute Id '" + id.stringValue() + "' Value '" + incomingValue + "' auto-converted from '" + Value.getClass().getName() + "' to type '" + dataType.getId().stringValue()));
                    }
                }
                attribute = new StdAttribute(categoryID, (Identifier)id, attributeValue, Issuer, (boolean)includeInResult);
            }
        }
        catch (Exception e) {
            throw new JSONStructureException("In Id='" + id.stringValue() + "' Unable to convert Attribute Value '" + incomingValue + "' to type '" + dataTypeId.stringValue() + "'");
        }
        JSONRequest.checkUnknown(id.stringValue() + "Attribute '" + idString.toString() + "'", attributeMap);
        return attribute;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Node parseXML(String xmlContent) throws JSONStructureException {
        if (xmlContent == null) return null;
        if (xmlContent.length() == 0) {
            return null;
        }
        String unescapedContent = xmlContent.replace("\\\"", "\"");
        unescapedContent = unescapedContent.replace("\\\\", "\\");
        try (ByteArrayInputStream is = new ByteArrayInputStream(unescapedContent.getBytes("UTF-8"));){
            Document doc = DOMUtil.loadDocument(is);
            if (doc != null) {
                Element element = doc.getDocumentElement();
                return element;
            }
            Node node = null;
            return node;
        }
        catch (Exception ex) {
            throw new JSONStructureException("Unable to parse Content '" + xmlContent + "'");
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void parseCategory(Map<?, ?> categoryMap, String categoryName, Identifier defaultCategoryId, StdMutableRequest stdMutableRequest) throws JSONStructureException {
        void var7_10;
        Identifier categoryId = defaultCategoryId;
        Object categoryIDString = categoryMap.remove("CategoryId");
        if (categoryIDString == null && defaultCategoryId == null) {
            throw new JSONStructureException("Category is missing CategoryId");
        }
        if (categoryIDString != null) {
            if (!(categoryIDString instanceof String)) {
                throw new JSONStructureException("Expect '" + categoryName + "' CategoryId to be String got " + categoryIDString.getClass());
            }
            categoryId = new IdentifierImpl(categoryIDString.toString());
        }
        if (defaultCategoryId != null && !defaultCategoryId.equals(categoryId)) {
            throw new JSONStructureException(categoryName + " given CategoryId '" + categoryId + "' which does not match default id '" + defaultCategoryId + "'");
        }
        String xmlId = (String)categoryMap.remove("Id");
        ArrayList arrayList = new ArrayList();
        Object attributesMap = categoryMap.remove("Attribute");
        if (attributesMap != null) {
            if (attributesMap instanceof ArrayList) {
                List<Attribute> list = JSONRequest.parseAttribute(categoryId, (ArrayList)attributesMap);
            } else {
                if (!(attributesMap instanceof Map)) throw new JSONStructureException("Category '" + categoryName + "' saw unexpected Attribute class " + attributesMap.getClass());
                ArrayList<Map> listForOne = new ArrayList<Map>();
                listForOne.add((Map)attributesMap);
                List<Attribute> list = JSONRequest.parseAttribute(categoryId, listForOne);
            }
        }
        Node contentRootNode = null;
        Object content = categoryMap.remove("Content");
        if (content != null) {
            byte[] realContent;
            if (content instanceof String) {
                if (Base64.isBase64((byte[])((String)content).getBytes())) {
                    realContent = Base64.decodeBase64((String)((String)content));
                    try {
                        contentRootNode = JSONRequest.parseXML(new String(realContent, "UTF-8"));
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new JSONStructureException("Category '" + categoryName + "' Unsupported encoding in Content");
                    }
                } else {
                    contentRootNode = JSONRequest.parseXML((String)content);
                }
            } else {
                if (!(content instanceof byte[])) throw new JSONStructureException("Category '" + categoryName + "' Unable to determine what Content is " + content.getClass());
                if (!Base64.isBase64((byte[])((String)content).getBytes())) throw new JSONStructureException("Category '" + categoryName + "' Content expected Base64 value");
                realContent = Base64.decodeBase64((String)((String)content));
                try {
                    contentRootNode = JSONRequest.parseXML(new String(realContent, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new JSONStructureException("Category '" + categoryName + "' Unsupported encoding in Content");
                }
            }
        }
        JSONRequest.checkUnknown(categoryName, categoryMap);
        StdMutableRequestAttributes attributeCategory = new StdMutableRequestAttributes(categoryId, (Collection<Attribute>)var7_10, contentRootNode, xmlId);
        stdMutableRequest.add(attributeCategory);
    }

    private static void parseDefaultCategory(Map<?, ?> jsonRequestMap, String categoryName, String categoryIdString, StdMutableRequest stdMutableRequest) throws JSONStructureException {
        Object categoryMap = jsonRequestMap.remove(categoryName);
        if (categoryMap != null) {
            IdentifierImpl defaultIdentifier = new IdentifierImpl(categoryIdString);
            if (categoryMap instanceof Map) {
                JSONRequest.parseCategory((Map)categoryMap, categoryName, defaultIdentifier, stdMutableRequest);
            } else if (categoryMap instanceof List) {
                List categoryList = (List)categoryMap;
                for (Object subCategory : categoryList) {
                    if (!(subCategory instanceof Map)) {
                        throw new JSONStructureException(categoryName + " array can only contain objects within curly braces");
                    }
                    JSONRequest.parseCategory((Map)subCategory, categoryName, defaultIdentifier, stdMutableRequest);
                }
            } else {
                throw new JSONStructureException(categoryName + " must have one object contained within curly braces ({}) or an array of objects ([{}{}])");
            }
        }
    }

    public static Request load(String jsonString) throws JSONStructureException {
        Request request = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));){
            request = JSONRequest.load(is);
        }
        catch (Exception ex) {
            throw new JSONStructureException("Exception loading String Request: " + ex.getMessage(), ex);
        }
        return request;
    }

    public static Request load(File fileRequest) throws JSONStructureException {
        Request request = null;
        try (FileInputStream fis = new FileInputStream(fileRequest);){
            request = JSONRequest.load(fis);
        }
        catch (Exception ex) {
            throw new JSONStructureException("Exception loading File Request: " + ex.getMessage(), ex);
        }
        return request;
    }

    public static Request load(InputStream is) throws JSONStructureException {
        if (shorthandMap == null) {
            JSONRequest.initShorthandMap();
        }
        if (dataTypeFactory == null) {
            try {
                dataTypeFactory = DataTypeFactory.newInstance();
                if (dataTypeFactory == null) {
                    throw new NullPointerException("No DataTypeFactory found");
                }
            }
            catch (FactoryException e) {
                throw new JSONStructureException("Unable to find DataTypeFactory, e=" + e);
            }
        }
        StdMutableRequest stdMutableRequest = null;
        String json = null;
        ObjectMapper mapper = null;
        try {
            Object xPath;
            Scanner scanner = new Scanner(is);
            scanner.useDelimiter("\\A");
            json = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
            Map root = (Map)mapper.readValue(json, Map.class);
            Map jsonRequestMap = (Map)root.remove("Request");
            if (jsonRequestMap == null) {
                throw new JSONStructureException("No \"Request\" property found.");
            }
            JSONRequest.checkUnknown("Top-level message", root);
            stdMutableRequest = new StdMutableRequest();
            Object categoryList = jsonRequestMap.remove("Category");
            if (categoryList != null && !(categoryList instanceof List)) {
                throw new JSONStructureException("Category must contain list of objects, not '" + categoryList.getClass() + "'");
            }
            if (categoryList != null) {
                for (Object category : (List)categoryList) {
                    if (!(category instanceof Map)) {
                        throw new JSONStructureException("Category list must contain objects contained within curly braces ({})");
                    }
                    JSONRequest.parseCategory((Map)category, "Category", null, stdMutableRequest);
                }
            }
            JSONRequest.parseDefaultCategory(jsonRequestMap, "AccessSubject", "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "Subject", "urn:oasis:names:tc:xacml:1.0:subject-category:access-subject", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "Action", "urn:oasis:names:tc:xacml:3.0:attribute-category:action", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "Resource", "urn:oasis:names:tc:xacml:3.0:attribute-category:resource", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "Environment", "urn:oasis:names:tc:xacml:3.0:attribute-category:environment", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "RecipientSubject", "urn:oasis:names:tc:xacml:1.0:subject-category:recipient-subject", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "IntermediarySubject", "urn:oasis:names:tc:xacml:1.0:subject-category:intermediary-subject", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "Codebase", "urn:oasis:names:tc:xacml:1.0:subject-category:codebase", stdMutableRequest);
            JSONRequest.parseDefaultCategory(jsonRequestMap, "RequestingMachine", "urn:oasis:names:tc:xacml:1.0:subject-category:requesting-machine", stdMutableRequest);
            Map multiRequests = (Map)jsonRequestMap.remove("MultiRequests");
            if (multiRequests != null) {
                if (!(multiRequests instanceof Map)) {
                    throw new JSONStructureException("MultiRequests must be object structure, not single value");
                }
                List requestReferenceList = (List)multiRequests.remove("RequestReference");
                if (requestReferenceList == null) {
                    throw new JSONStructureException("MultiRequest must contain a RequestReference element");
                }
                if (requestReferenceList.size() < 1) {
                    throw new JSONStructureException("MultiRequest must contain at least one element in the RequestReference list");
                }
                JSONRequest.checkUnknown("MultiRequest", multiRequests);
                for (Object requestReferenceMapObject : requestReferenceList) {
                    if (!(requestReferenceMapObject instanceof Map)) {
                        throw new JSONStructureException("MultiRequest RequestReference must be object");
                    }
                    Map requestReferenceMap = (Map)requestReferenceMapObject;
                    Object referenceIdListObject = requestReferenceMap.remove("ReferenceId");
                    if (referenceIdListObject == null) {
                        throw new JSONStructureException("MultiRequest RequestReference list element must contain ReferenceId");
                    }
                    List referenceIdList = (List)referenceIdListObject;
                    if (referenceIdList.size() == 0) continue;
                    JSONRequest.checkUnknown("RequestReference", requestReferenceMap);
                    StdMutableRequestReference requestReference = new StdMutableRequestReference();
                    for (Object referenceId : referenceIdList) {
                        StdRequestAttributesReference requestAttributesReference = new StdRequestAttributesReference((String)referenceId);
                        requestReference.add(requestAttributesReference);
                    }
                    stdMutableRequest.add(requestReference);
                }
            }
            Object returnPolicyIdList = jsonRequestMap.remove("ReturnPolicyIdList");
            Boolean returnPolicyIdListBoolean = JSONRequest.makeBoolean(returnPolicyIdList, "ReturnPolicyIdList");
            if (returnPolicyIdList != null) {
                stdMutableRequest.setReturnPolicyIdList(returnPolicyIdListBoolean);
            }
            Object combinedDecision = jsonRequestMap.remove("CombinedDecision");
            Boolean combinedDecisionBoolean = JSONRequest.makeBoolean(combinedDecision, "CombinedDecision");
            if (combinedDecision != null) {
                stdMutableRequest.setCombinedDecision(combinedDecisionBoolean);
            }
            if ((xPath = jsonRequestMap.remove("XPathVersion")) != null) {
                if (!(xPath instanceof String)) {
                    throw new JSONStructureException("XPathVersion not a URI passed as a String");
                }
                URI xPathUri = null;
                try {
                    xPathUri = new URI(xPath.toString());
                }
                catch (Exception e) {
                    throw new JSONStructureException("XPathVersion not a valid URI: '" + xPath + "'", e);
                }
                StdRequestDefaults requestDefaults = new StdRequestDefaults(xPathUri);
                stdMutableRequest.setRequestDefaults(requestDefaults);
            }
            JSONRequest.checkUnknown("Request", jsonRequestMap);
        }
        catch (JsonParseException e) {
            JsonLocation location = e.getLocation();
            String locationOfError = "(unavailable)";
            if (location != null && location != JsonLocation.NA) {
                String jsonText = json;
                if (location.getLineNr() > 1) {
                    String[] jsonArray = jsonText.split("\\r?\\n|\\r");
                    jsonText = jsonArray[location.getLineNr()];
                }
                if (location.getCharOffset() < (long)jsonText.length()) {
                    if (location.getCharOffset() > 0L) {
                        locationOfError = jsonText.substring((int)location.getCharOffset() - 1);
                    }
                    if (locationOfError.length() > 30) {
                        locationOfError = locationOfError.substring(0, 30);
                    }
                }
            }
            throw new JSONStructureException("Unable to parse JSON starting at text'" + locationOfError + "', input was '" + json + "', exception: " + (Object)((Object)e), e);
        }
        catch (JsonMappingException e) {
            throw new JSONStructureException("Unable to map JSON '" + json + "', exception: " + (Object)((Object)e), e);
        }
        catch (IOException e) {
            throw new JSONStructureException("Unable to read JSON input, exception: " + e, e);
        }
        return new StdRequest(stdMutableRequest);
    }

    public static String toString(Request request) throws Exception {
        return JSONRequest.toString(request, true);
    }

    public static String toString(Request request, boolean prettyPrint) throws Exception {
        String outputString = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JSONRequest.convert(request, os, prettyPrint);
            outputString = new String(os.toByteArray(), "UTF-8");
        }
        return outputString;
    }

    public static void convert(Request request, OutputStream outputStream) throws IOException, JSONStructureException {
        JSONRequest.convert(request, outputStream, false);
    }

    public static void convert(Request request, OutputStream outputStream, boolean prettyPrint) throws IOException, JSONStructureException {
        if (request == null) {
            throw new NullPointerException("No Request in convert");
        }
        HashMap<String, Object> requestMap = new HashMap<String, Object>();
        requestMap.put("ReturnPolicyIdList", request.getReturnPolicyIdList());
        requestMap.put("CombinedDecision", request.getCombinedDecision());
        if (request.getRequestDefaults() != null) {
            requestMap.put("XPathVersion", request.getRequestDefaults().getXPathVersion());
        }
        Iterator<RequestAttributes> rait = request.getRequestAttributes().iterator();
        ArrayList generalCategoriesList = new ArrayList();
        while (rait.hasNext()) {
            RequestAttributes ra = rait.next();
            HashMap<String, Object> categoryMap = new HashMap<String, Object>();
            if (ra.getXmlId() != null) {
                categoryMap.put("Id", ra.getXmlId());
            }
            if (ra.getContentRoot() != null) {
                StringWriter writer = new StringWriter();
                Transformer transformer = null;
                try {
                    transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.transform(new DOMSource(ra.getContentRoot()), new StreamResult(writer));
                }
                catch (Exception e) {
                    throw new JSONStructureException("Unable to Content node to string; e=" + e);
                }
                String xml = writer.toString();
                categoryMap.put("Content", xml);
            }
            Iterator<Attribute> attrIt = ra.getAttributes().iterator();
            ArrayList attributesList = new ArrayList();
            while (attrIt.hasNext()) {
                Attribute attr = attrIt.next();
                HashMap<String, Object> attrMap = new HashMap<String, Object>();
                attrMap.put("AttributeId", attr.getAttributeId().stringValue());
                if (attr.getIssuer() != null) {
                    attrMap.put("Issuer", attr.getIssuer());
                }
                attrMap.put("IncludeInResult", attr.getIncludeInResults());
                Collection<AttributeValue<?>> valuesCollection = attr.getValues();
                Iterator<AttributeValue<?>> valuesIt = valuesCollection.iterator();
                if (valuesCollection.size() == 1) {
                    AttributeValue<?> attrValue = valuesIt.next();
                    attrMap.put("DataType", attrValue.getDataTypeId().stringValue());
                    attrMap.put("Value", JSONRequest.jsonOutputObject(attrValue.getValue(), attrValue));
                } else if (valuesCollection.size() > 1) {
                    ArrayList<Object> attrValueList = new ArrayList<Object>();
                    while (valuesIt.hasNext()) {
                        AttributeValue<?> attrValue = valuesIt.next();
                        attrMap.put("DataType", attrValue.getDataTypeId().stringValue());
                        attrValueList.add(JSONRequest.jsonOutputObject(attrValue.getValue(), attrValue));
                    }
                    attrMap.put("Value", attrValueList);
                }
                attributesList.add(attrMap);
            }
            if (attributesList.size() > 0) {
                categoryMap.put("Attribute", attributesList);
            }
            categoryMap.put("CategoryId", ra.getCategory().stringValue());
            generalCategoriesList.add(categoryMap);
        }
        if (generalCategoriesList.size() > 0) {
            requestMap.put("Category", generalCategoriesList);
        }
        if (request.getMultiRequests() != null) {
            Collection<RequestReference> referenceCollection = request.getMultiRequests();
            HashMap multiRequestMap = new HashMap();
            ArrayList requestReferenceList = new ArrayList();
            for (RequestReference rr : referenceCollection) {
                HashMap requestReferenceMap = new HashMap();
                Collection<RequestAttributesReference> rarCollection = rr.getAttributesReferences();
                ArrayList<String> ridList = new ArrayList<String>();
                for (RequestAttributesReference rar : rarCollection) {
                    ridList.add(rar.getReferenceId());
                }
                if (ridList.size() > 0) {
                    requestReferenceMap.put("ReferenceId", ridList);
                }
                if (requestReferenceMap.size() > 0) {
                    requestReferenceList.add(requestReferenceMap);
                }
                if (requestReferenceList.size() <= 0) continue;
                multiRequestMap.put("RequestReference", requestReferenceList);
            }
            if (multiRequestMap.size() > 0) {
                requestMap.put("MultiRequests", multiRequestMap);
            }
        }
        HashMap<String, HashMap<String, Object>> theWholeRequest = new HashMap<String, HashMap<String, Object>>();
        theWholeRequest.put("Request", requestMap);
        ObjectMapper mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
        try (OutputStreamWriter osw = new OutputStreamWriter(outputStream);){
            String json = mapper.writeValueAsString(theWholeRequest);
            osw.write(json);
            osw.flush();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to write to json string: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static Object jsonOutputObject(Object obj, AttributeValue<?> attrValue) throws JSONStructureException {
        if (obj instanceof String || obj instanceof Boolean || obj instanceof BigInteger) {
            return obj;
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            if (d == Double.NaN) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return obj;
        }
        if (obj instanceof SemanticString) {
            return ((SemanticString)obj).stringValue();
        }
        if (obj instanceof X500Principal || obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof XPathExpressionWrapper) {
            HashMap<String, Object> xpathExpressionMap = new HashMap<String, Object>();
            Identifier xpathCategoryId = attrValue.getXPathCategory();
            if (xpathCategoryId == null) {
                throw new JSONStructureException("XPathExpression is missing XPathCategory");
            }
            xpathExpressionMap.put("XPathCategory", attrValue.getXPathCategory().stringValue());
            XPathExpressionWrapper xw = (XPathExpressionWrapper)obj;
            xpathExpressionMap.put("XPath", xw.getPath());
            ExtendedNamespaceContext namespaceContext = xw.getNamespaceContext();
            if (namespaceContext != null) {
                ArrayList namespaceList = new ArrayList();
                Iterator<String> prefixIt = namespaceContext.getAllPrefixes();
                while (prefixIt.hasNext()) {
                    String prefix = prefixIt.next();
                    String namespaceURI = namespaceContext.getNamespaceURI(prefix);
                    HashMap<String, String> namespaceMap = new HashMap<String, String>();
                    if (prefix != null && !prefix.equals("")) {
                        namespaceMap.put("Prefix", prefix);
                    }
                    namespaceMap.put("Namespace", namespaceURI);
                    namespaceList.add(namespaceMap);
                }
                xpathExpressionMap.put("Namespaces", namespaceList);
            }
            return xpathExpressionMap;
        }
        throw new JSONStructureException("Unhandled data type='" + obj.getClass().getName() + "'");
    }
}

