/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.json;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigInteger;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeAssignment;
import org.apache.openaz.xacml.api.AttributeCategory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Decision;
import org.apache.openaz.xacml.api.IdReference;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.MissingAttributeDetail;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.api.Response;
import org.apache.openaz.xacml.api.Result;
import org.apache.openaz.xacml.api.SemanticString;
import org.apache.openaz.xacml.api.StatusCode;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAdvice;
import org.apache.openaz.xacml.std.StdDataTypeFactory;
import org.apache.openaz.xacml.std.StdIdReference;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.StdMutableAttributeAssignment;
import org.apache.openaz.xacml.std.StdMutableAttributeCategory;
import org.apache.openaz.xacml.std.StdMutableMissingAttributeDetail;
import org.apache.openaz.xacml.std.StdMutableResponse;
import org.apache.openaz.xacml.std.StdMutableResult;
import org.apache.openaz.xacml.std.StdMutableStatus;
import org.apache.openaz.xacml.std.StdMutableStatusDetail;
import org.apache.openaz.xacml.std.StdObligation;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.StdVersion;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.ExtendedNamespaceContext;
import org.apache.openaz.xacml.std.datatypes.StringNamespaceContext;
import org.apache.openaz.xacml.std.datatypes.XPathExpressionWrapper;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.apache.openaz.xacml.std.json.JSONStructureException;
import org.apache.openaz.xacml.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JSONResponse {
    private static final Log logger = LogFactory.getLog(JSONResponse.class);
    private static Map<String, String> outputShorthandMap = null;
    private static Map<String, Identifier> shorthandMap = null;
    private static DataTypeFactory dataTypeFactory = null;

    protected JSONResponse() {
    }

    private static void initOutputShorthandMap() throws JSONStructureException {
        Field[] declaredFields = XACML3.class.getDeclaredFields();
        outputShorthandMap = new HashMap<String, String>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("ID_DATATYPE") || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                Identifier id = (Identifier)field.get(null);
                String longName = id.stringValue();
                int sharpIndex = longName.lastIndexOf("#");
                if (sharpIndex <= 0) {
                    if (!longName.contains(":data-type:")) continue;
                    sharpIndex = longName.lastIndexOf(":");
                }
                String shortName = longName.substring(sharpIndex + 1);
                outputShorthandMap.put(id.stringValue(), shortName);
            }
            catch (Exception e) {
                throw new JSONStructureException("Error loading ID Table, e=" + e);
            }
        }
    }

    private static void initShorthandMap() throws JSONStructureException {
        Field[] declaredFields = XACML3.class.getDeclaredFields();
        shorthandMap = new HashMap<String, Identifier>();
        for (Field field : declaredFields) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("ID_DATATYPE") || !Modifier.isPublic(field.getModifiers())) continue;
            try {
                Identifier id = (Identifier)field.get(null);
                String longName = id.stringValue();
                int sharpIndex = longName.lastIndexOf("#");
                if (sharpIndex <= 0) {
                    if (!longName.contains(":data-type:")) continue;
                    sharpIndex = longName.lastIndexOf(":");
                }
                String shortName = longName.substring(sharpIndex + 1);
                shorthandMap.put(longName, id);
                shorthandMap.put(shortName, id);
            }
            catch (Exception e) {
                throw new JSONStructureException("Error loading ID Table, e=" + e);
            }
        }
    }

    private static void checkUnknown(String component, Map<?, ?> map) throws JSONStructureException {
        if (map.size() == 0) {
            return;
        }
        String keys = null;
        Iterator<?> it = map.keySet().iterator();
        while (it.hasNext()) {
            if (keys == null) {
                keys = "'" + it.next().toString() + "'";
                continue;
            }
            keys = keys + ", '" + it.next().toString() + "'";
        }
        String message = component + " contains unknown element" + (map.size() == 1 ? " " : "s ") + keys;
        throw new JSONStructureException(message);
    }

    private static StatusCode parseStatusCode(Map<?, ?> statusCodeMap) throws JSONStructureException {
        Object valueObject = statusCodeMap.remove("Value");
        IdentifierImpl identifier = null;
        if (valueObject != null) {
            identifier = new IdentifierImpl(valueObject.toString());
        }
        Object childStatusCodeMap = statusCodeMap.remove("StatusCode");
        StatusCode childStatusCode = null;
        if (childStatusCodeMap != null) {
            if (!(childStatusCodeMap instanceof Map)) {
                throw new JSONStructureException("Child StatusCode must be object");
            }
            childStatusCode = JSONResponse.parseStatusCode((Map)childStatusCodeMap);
        }
        JSONResponse.checkUnknown("StatusCode", statusCodeMap);
        StdStatusCode statusCode = new StdStatusCode(identifier, childStatusCode);
        return statusCode;
    }

    private static AttributeValue<?> convertMapToXPathExpression(Object mapObject) throws JSONStructureException {
        AttributeValue attributeValue;
        if (!(mapObject instanceof Map)) {
            throw new JSONStructureException("XPathExpression value must be complex object containing XPath, XPathCategory and optional Namespaces");
        }
        Map xpathExpressionMap = (Map)mapObject;
        Object xpathObject = xpathExpressionMap.remove("XPath");
        if (xpathObject == null || !(xpathObject instanceof String)) {
            throw new JSONStructureException("XPathExpression must contain string XPath");
        }
        Object xpathCategoryObject = xpathExpressionMap.remove("XPathCategory");
        if (xpathCategoryObject == null || !(xpathCategoryObject instanceof String)) {
            throw new JSONStructureException("XPathExpression must contain URI (string) XPathCategory");
        }
        IdentifierImpl xpathCategoryIdentifier = new IdentifierImpl(xpathCategoryObject.toString());
        Object namespacesObject = xpathExpressionMap.remove("Namespaces");
        StringNamespaceContext namespaceContext = null;
        if (namespacesObject != null) {
            if (!(namespacesObject instanceof List)) {
                throw new JSONStructureException("Namespaces must be list");
            }
            List namespacesList = (List)namespacesObject;
            namespaceContext = new StringNamespaceContext();
            for (Object namespaceObject : namespacesList) {
                if (!(namespaceObject instanceof Map)) {
                    throw new JSONStructureException("Namespaces array items must be object");
                }
                Map namespaceMap = (Map)namespaceObject;
                Object namespaceURI = namespaceMap.remove("Namespace");
                if (namespaceURI == null) {
                    throw new JSONStructureException("Namespace array item must contain Namespace member");
                }
                Object prefixObject = namespaceMap.remove("Prefix");
                String prefix = null;
                if (prefixObject != null) {
                    prefix = prefixObject.toString();
                }
                JSONResponse.checkUnknown("Namespace", namespaceMap);
                try {
                    if (prefix == null) {
                        namespaceContext.add(namespaceURI.toString());
                        continue;
                    }
                    namespaceContext.add(prefix, namespaceURI.toString());
                }
                catch (Exception e) {
                    throw new JSONStructureException("Namespace array item error: " + e.getMessage());
                }
            }
        }
        JSONResponse.checkUnknown("XPathExpression", xpathExpressionMap);
        XPathExpressionWrapper wrapper = new XPathExpressionWrapper(namespaceContext, xpathObject.toString());
        try {
            attributeValue = DataTypes.DT_XPATHEXPRESSION.createAttributeValue(wrapper, xpathCategoryIdentifier);
        }
        catch (DataTypeException e) {
            throw new JSONStructureException("Namespaces unable to create AttributeValue; reason: " + e.getMessage());
        }
        return attributeValue;
    }

    private static void parseObligationsOrAdvice(Object listObject, StdMutableResult stdMutableResult, boolean isObligation) throws JSONStructureException {
        String oaTypeName;
        String string = oaTypeName = isObligation ? "Obligations" : "AssociatedAdvice";
        if (!(listObject instanceof List)) {
            throw new JSONStructureException(oaTypeName + " must be list");
        }
        List oaList = (List)listObject;
        for (Object oa : oaList) {
            if (!(oa instanceof Map)) {
                throw new JSONStructureException(oaTypeName + " array items must all be objects");
            }
            Map oaMap = (Map)oa;
            Object idObject = oaMap.remove("Id");
            if (idObject == null) {
                throw new JSONStructureException(oaTypeName + " array item must have Id");
            }
            IdentifierImpl oaId = new IdentifierImpl(idObject.toString());
            Object aaListObject = oaMap.remove("AttributeAssignment");
            ArrayList<AttributeAssignment> attributeAssignmentList = new ArrayList<AttributeAssignment>();
            if (aaListObject != null) {
                if (!(aaListObject instanceof List)) {
                    throw new JSONStructureException("AttributeAssignment must be list in " + oaTypeName);
                }
                List attributeAssignmentMapList = (List)aaListObject;
                for (Object aaMapObject : attributeAssignmentMapList) {
                    Object valueObject;
                    if (aaMapObject == null || !(aaMapObject instanceof Map)) {
                        throw new JSONStructureException("AttributeAssignment list item must be non-null object in " + oaTypeName);
                    }
                    Map aaMap = (Map)aaMapObject;
                    StdMutableAttributeAssignment stdMutableAttributeAssignment = new StdMutableAttributeAssignment();
                    Object aaIdObject = aaMap.remove("AttributeId");
                    if (aaIdObject == null) {
                        throw new JSONStructureException("AttributeAssignment list item missing AttributeId in " + oaTypeName);
                    }
                    stdMutableAttributeAssignment.setAttributeId(new IdentifierImpl(aaIdObject.toString()));
                    Object categoryObject = aaMap.remove("Category");
                    if (categoryObject != null) {
                        stdMutableAttributeAssignment.setCategory(new IdentifierImpl(categoryObject.toString()));
                    }
                    Object dataTypeObject = aaMap.remove("DataType");
                    Identifier dataTypeId = null;
                    if (dataTypeObject != null) {
                        dataTypeId = shorthandMap.get(dataTypeObject.toString());
                        if (dataTypeId == null) {
                            throw new JSONStructureException("AttributeAssignment list item has unknown DataType='" + dataTypeObject.toString() + "' in " + oaTypeName);
                        }
                    } else {
                        dataTypeId = DataTypes.DT_STRING.getId();
                    }
                    if ((valueObject = aaMap.remove("Value")) == null) {
                        throw new JSONStructureException("AttributeAssignment list item missing Value in " + oaTypeName);
                    }
                    AttributeValue<?> attributeValue = null;
                    try {
                        DataType<?> dataType = new StdDataTypeFactory().getDataType(dataTypeId);
                        attributeValue = dataType == DataTypes.DT_XPATHEXPRESSION ? JSONResponse.convertMapToXPathExpression(valueObject) : dataType.createAttributeValue(valueObject);
                    }
                    catch (DataTypeException e) {
                        throw new JSONStructureException("AttributeAssignment list item Value='" + valueObject.toString() + "' not of type '" + dataTypeId + "' in " + oaTypeName);
                    }
                    stdMutableAttributeAssignment.setAttributeValue(attributeValue);
                    Object issuerObject = aaMap.remove("Issuer");
                    if (issuerObject != null) {
                        stdMutableAttributeAssignment.setIssuer(issuerObject.toString());
                    }
                    JSONResponse.checkUnknown("AttributeAssignment in " + oaTypeName, aaMap);
                    attributeAssignmentList.add(stdMutableAttributeAssignment);
                }
            }
            JSONResponse.checkUnknown(oaTypeName + " array item", oaMap);
            if (isObligation) {
                StdObligation obligation = new StdObligation(oaId, attributeAssignmentList);
                stdMutableResult.addObligation(obligation);
                continue;
            }
            StdAdvice advice = new StdAdvice(oaId, attributeAssignmentList);
            stdMutableResult.addAdvice(advice);
        }
    }

    private static void parseIdReferences(Object policyIdReferenceObject, StdMutableResult stdMutableResult, boolean isSet) throws JSONStructureException {
        String idTypeName;
        String string = idTypeName = isSet ? "PolicySetIdReference" : "PolicyIdReference";
        if (!(policyIdReferenceObject instanceof List)) {
            throw new JSONStructureException(idTypeName + " must be array");
        }
        List policyIdReferenceList = (List)policyIdReferenceObject;
        for (Object idReferenceObject : policyIdReferenceList) {
            if (idReferenceObject == null || !(idReferenceObject instanceof Map)) {
                throw new JSONStructureException(idTypeName + " array item must be non-null object");
            }
            Map idReferenceMap = (Map)idReferenceObject;
            Object idReferenceIdObject = idReferenceMap.remove("Id");
            if (idReferenceIdObject == null) {
                throw new JSONStructureException(idTypeName + " array item must contain Id");
            }
            IdentifierImpl idReferenceId = new IdentifierImpl(idReferenceIdObject.toString());
            StdVersion version = null;
            Object idReferenceVersionObject = idReferenceMap.remove("Version");
            if (idReferenceVersionObject != null) {
                try {
                    version = StdVersion.newInstance(idReferenceVersionObject.toString());
                }
                catch (ParseException e) {
                    throw new JSONStructureException(idTypeName + " array item Version: " + e.getMessage());
                }
            }
            JSONResponse.checkUnknown("IdReference in " + idTypeName, idReferenceMap);
            StdIdReference policyIdentifier = new StdIdReference(idReferenceId, version);
            if (isSet) {
                stdMutableResult.addPolicySetIdentifier(policyIdentifier);
                continue;
            }
            stdMutableResult.addPolicyIdentifier(policyIdentifier);
        }
    }

    public static Response load(String jsonString) throws JSONStructureException {
        Response response = null;
        try (ByteArrayInputStream is = new ByteArrayInputStream(jsonString.getBytes("UTF-8"));){
            response = JSONResponse.load(is);
        }
        catch (Exception ex) {
            throw new JSONStructureException("Exception loading String Response: " + ex.getMessage(), ex);
        }
        return response;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Response load(File fileResponse) throws JSONStructureException {
        try (BufferedReader br = new BufferedReader(new FileReader(fileResponse));){
            String line;
            String responseString = "";
            while ((line = br.readLine()) != null) {
                responseString = responseString + line;
            }
            br.close();
            Response response = JSONResponse.load(responseString);
            return response;
        }
        catch (Exception e) {
            throw new JSONStructureException(e);
        }
    }

    public static Response load(Path pathResponse) throws JSONStructureException {
        try {
            return JSONResponse.load(Files.newInputStream(pathResponse, new OpenOption[0]));
        }
        catch (Exception e) {
            throw new JSONStructureException(e);
        }
    }

    public static Response load(InputStream is) throws JSONStructureException {
        if (shorthandMap == null) {
            JSONResponse.initShorthandMap();
        }
        if (dataTypeFactory == null) {
            try {
                dataTypeFactory = DataTypeFactory.newInstance();
                if (dataTypeFactory == null) {
                    throw new NullPointerException("No DataTypeFactory found");
                }
            }
            catch (FactoryException e) {
                throw new JSONStructureException("Unable to find DataTypeFactory, e=" + e);
            }
        }
        StdMutableResponse stdMutableResponse = null;
        String json = null;
        ObjectMapper mapper = null;
        try {
            Scanner scanner = new Scanner(is);
            scanner.useDelimiter("\\A");
            json = scanner.hasNext() ? scanner.next() : "";
            scanner.close();
            mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
            mapper.configure(JsonParser.Feature.STRICT_DUPLICATE_DETECTION, true);
            Map root = (Map)mapper.readValue(json, Map.class);
            List resultList = (List)root.remove("Response");
            if (resultList == null) {
                throw new JSONStructureException("No \"Response\" property found.");
            }
            JSONResponse.checkUnknown("Top-level message", root);
            stdMutableResponse = new StdMutableResponse();
            for (int resultIndex = 0; resultIndex < resultList.size(); ++resultIndex) {
                Object policyIdObject;
                Object attributesObject;
                Object adviceObject;
                Object obligationsObject;
                Object resultObj = resultList.get(resultIndex);
                if (resultObj == null || !(resultObj instanceof Map)) {
                    throw new JSONStructureException("Response contains null Result or list instead of Result object");
                }
                StdMutableResult stdMutableResult = new StdMutableResult();
                Map resultMap = (Map)resultObj;
                Object decisionObject = resultMap.remove("Decision");
                if (decisionObject == null) {
                    throw new JSONStructureException("Result must have Decision");
                }
                Decision decision = Decision.get(decisionObject.toString());
                if (decision == null) {
                    throw new JSONStructureException("Unknown value for Decision: '" + decisionObject.toString() + "'");
                }
                stdMutableResult.setDecision(decision);
                Object statusObject = resultMap.remove("Status");
                if (statusObject != null) {
                    Object statusCodeObject;
                    Object detailObject;
                    if (!(statusObject instanceof Map)) {
                        throw new JSONStructureException("Status must be an object, not type '" + statusObject.getClass().getName() + "'");
                    }
                    StdMutableStatus stdMutableStatus = new StdMutableStatus();
                    Map statusMap = (Map)statusObject;
                    Object messageObject = statusMap.remove("StatusMessage");
                    if (messageObject != null) {
                        stdMutableStatus.setStatusMessage(messageObject.toString());
                    }
                    if ((detailObject = statusMap.remove("StatusDetail")) != null) {
                        StdMutableStatusDetail statusDetail = new StdMutableStatusDetail();
                        String unescapedContent = detailObject.toString().replace("\\\"", "\"");
                        unescapedContent = unescapedContent.replace("\\\\", "\\");
                        unescapedContent = "<ROOT>" + unescapedContent + "</ROOT>";
                        Document doc = null;
                        try (ByteArrayInputStream bis = new ByteArrayInputStream(unescapedContent.getBytes("UTF-8"));){
                            doc = DOMUtil.loadDocument(bis);
                        }
                        catch (Exception ex) {
                            throw new JSONStructureException("Unable to parse Content '" + detailObject.toString() + "'");
                        }
                        Element docElement = doc.getDocumentElement();
                        NodeList missingAttributeDetailList = docElement.getElementsByTagName("MissingAttributeDetail");
                        for (int madNodeIndex = 0; madNodeIndex < missingAttributeDetailList.getLength(); ++madNodeIndex) {
                            Node madNode = missingAttributeDetailList.item(madNodeIndex);
                            StdMutableMissingAttributeDetail mutableMAD = new StdMutableMissingAttributeDetail();
                            NamedNodeMap attributeMap = madNode.getAttributes();
                            Node attributeNode = attributeMap.getNamedItem("AttributeId");
                            if (attributeNode == null) {
                                throw new JSONStructureException("MissingAttributeDetail missing AttributeId");
                            }
                            mutableMAD.setAttributeId(new IdentifierImpl(attributeNode.getNodeValue()));
                            Node categoryNode = attributeMap.getNamedItem("Category");
                            if (categoryNode == null) {
                                throw new JSONStructureException("MissingAttributeDetail missing Category");
                            }
                            mutableMAD.setCategory(new IdentifierImpl(categoryNode.getNodeValue()));
                            Node dataTypeNode = attributeMap.getNamedItem("DataType");
                            if (dataTypeNode == null) {
                                throw new JSONStructureException("MissingAttributeDetail missing DataType");
                            }
                            mutableMAD.setDataTypeId(new IdentifierImpl(dataTypeNode.getNodeValue()));
                            Node issuerNode = attributeMap.getNamedItem("Issuer");
                            if (issuerNode != null) {
                                mutableMAD.setIssuer(issuerNode.getNodeValue());
                            }
                            NodeList childNodeList = madNode.getChildNodes();
                            for (int childIndex = 0; childIndex < childNodeList.getLength(); ++childIndex) {
                                AttributeValue<?> attributeValue;
                                Node childNode = childNodeList.item(childIndex);
                                if (!childNode.getNodeName().equals("AttributeValue")) continue;
                                Node childDataTypeNode = childNode.getAttributes().getNamedItem("DataType");
                                if (childDataTypeNode == null) {
                                    throw new JSONStructureException("MissingAttributeDetail contains AttributeValue '" + childNode.getNodeValue() + "' with no DataType");
                                }
                                String dataType = childDataTypeNode.getNodeValue();
                                Identifier valueDataTypeId = shorthandMap.get(dataType);
                                if (valueDataTypeId == null) {
                                    throw new JSONStructureException("MissingAttibuteDetail contains AttributeValue with unknown DataType=" + dataType);
                                }
                                DataType<?> valueDataType = dataTypeFactory.getDataType(valueDataTypeId);
                                try {
                                    Node valueNode = childNode;
                                    if (valueNode.hasChildNodes()) {
                                        valueNode = valueNode.getFirstChild();
                                    }
                                    attributeValue = valueDataType.createAttributeValue(valueNode.getNodeValue());
                                }
                                catch (Exception ex) {
                                    throw new JSONStructureException("Unable to create AttributeValue from MissingAttributeDetail AttributeValue '" + childNode.getNodeValue() + "', error was: " + ex.getMessage());
                                }
                                mutableMAD.addAttributeValue(attributeValue);
                            }
                            statusDetail.addMissingAttributeDetail(mutableMAD);
                        }
                        stdMutableStatus.setStatusDetail(statusDetail);
                    }
                    if ((statusCodeObject = statusMap.remove("StatusCode")) != null) {
                        if (!(statusCodeObject instanceof Map)) {
                            throw new JSONStructureException("StatusCode must be object");
                        }
                        StatusCode statusCode = JSONResponse.parseStatusCode((Map)statusCodeObject);
                        stdMutableStatus.setStatusCode(statusCode);
                    }
                    JSONResponse.checkUnknown("Status", statusMap);
                    stdMutableResult.setStatus(stdMutableStatus);
                }
                if ((obligationsObject = resultMap.remove("Obligations")) != null) {
                    JSONResponse.parseObligationsOrAdvice(obligationsObject, stdMutableResult, true);
                }
                if ((adviceObject = resultMap.remove("AssociatedAdvice")) != null) {
                    JSONResponse.parseObligationsOrAdvice(adviceObject, stdMutableResult, false);
                }
                if ((attributesObject = resultMap.remove("Category")) != null) {
                    if (!(attributesObject instanceof List)) {
                        throw new JSONStructureException("Category must be list");
                    }
                    List attributesList = (List)attributesObject;
                    for (Object categoryObject : attributesList) {
                        if (categoryObject == null || !(categoryObject instanceof Map)) {
                            throw new JSONStructureException("Category array item must be object");
                        }
                        Map categoryMap = (Map)categoryObject;
                        StdMutableAttributeCategory stdMutableAttributeCategory = new StdMutableAttributeCategory();
                        Object categoryIdObject = categoryMap.remove("CategoryId");
                        if (categoryIdObject == null) {
                            throw new JSONStructureException("Category array item must contain CategoryId");
                        }
                        IdentifierImpl categoryId = new IdentifierImpl(categoryIdObject.toString());
                        stdMutableAttributeCategory.setCategory(categoryId);
                        Object attributeListObject = categoryMap.remove("Attribute");
                        if (attributeListObject != null) {
                            if (!(attributeListObject instanceof List)) {
                                throw new JSONStructureException("Category memeber Attribute must be list");
                            }
                            List attributeList = (List)attributeListObject;
                            for (Object attributeMapObject : attributeList) {
                                Object valueObject;
                                if (attributeMapObject == null || !(attributeMapObject instanceof Map)) {
                                    throw new JSONStructureException("Category member Attribute list item must be object");
                                }
                                Map attributeMap = (Map)attributeMapObject;
                                StdMutableAttribute stdMutableAttribute = new StdMutableAttribute();
                                Object includeInResultObject = attributeMap.remove("IncludeInResult");
                                stdMutableAttribute.setIncludeInResults(true);
                                if (includeInResultObject != null) {
                                    try {
                                        boolean include = DataTypes.DT_BOOLEAN.convert(includeInResultObject);
                                        stdMutableAttribute.setIncludeInResults(include);
                                    }
                                    catch (DataTypeException e) {
                                        throw new JSONStructureException("Category member Attribute list item has IncludeInResult value '" + includeInResultObject.toString() + "' which is not boolean");
                                    }
                                }
                                stdMutableAttribute.setCategory(categoryId);
                                Object aaIdObject = attributeMap.remove("AttributeId");
                                if (aaIdObject == null) {
                                    throw new JSONStructureException("Category member Attribute list item missing AttributeId");
                                }
                                stdMutableAttribute.setAttributeId(new IdentifierImpl(aaIdObject.toString()));
                                Object dataTypeObject = attributeMap.remove("DataType");
                                Identifier dataTypeId = null;
                                if (dataTypeObject != null) {
                                    dataTypeId = shorthandMap.get(dataTypeObject.toString());
                                    if (dataTypeId == null) {
                                        throw new JSONStructureException("Category member Attribute list item has unknown DataType='" + dataTypeObject.toString() + "'");
                                    }
                                } else {
                                    dataTypeId = DataTypes.DT_STRING.getId();
                                }
                                if ((valueObject = attributeMap.remove("Value")) == null) {
                                    throw new JSONStructureException("Category member Attribute list item missing Value");
                                }
                                AttributeValue<?> attributeValue = null;
                                try {
                                    DataType<?> dataType = new StdDataTypeFactory().getDataType(dataTypeId);
                                    attributeValue = dataType == DataTypes.DT_XPATHEXPRESSION ? JSONResponse.convertMapToXPathExpression(valueObject) : dataType.createAttributeValue(valueObject);
                                }
                                catch (DataTypeException e) {
                                    throw new JSONStructureException("Category member Attribute list item Value='" + valueObject.toString() + "' not of type '" + dataTypeId + "'");
                                }
                                stdMutableAttribute.addValue(attributeValue);
                                Object issuerObject = attributeMap.remove("Issuer");
                                if (issuerObject != null) {
                                    stdMutableAttribute.setIssuer(issuerObject.toString());
                                }
                                JSONResponse.checkUnknown("Category Attribute list item", attributeMap);
                                stdMutableAttributeCategory.add(stdMutableAttribute);
                            }
                        }
                        JSONResponse.checkUnknown("Category", categoryMap);
                        if (stdMutableAttributeCategory.getAttributes().size() <= 0) continue;
                        stdMutableResult.addAttributeCategory(stdMutableAttributeCategory);
                    }
                }
                if ((policyIdObject = resultMap.remove("PolicyIdentifier")) != null) {
                    Object policySetIdReferenceObject;
                    if (!(policyIdObject instanceof Map)) {
                        throw new JSONStructureException("PolicyIdentifier must be object");
                    }
                    Map policyIdMap = (Map)policyIdObject;
                    Object policyIdReferenceObject = policyIdMap.remove("PolicyIdReference");
                    if (policyIdReferenceObject != null) {
                        JSONResponse.parseIdReferences(policyIdReferenceObject, stdMutableResult, false);
                    }
                    if ((policySetIdReferenceObject = policyIdMap.remove("PolicySetIdReference")) != null) {
                        JSONResponse.parseIdReferences(policySetIdReferenceObject, stdMutableResult, true);
                    }
                    JSONResponse.checkUnknown("PolicyIdentifier", policyIdMap);
                }
                JSONResponse.checkUnknown("Result", resultMap);
                stdMutableResponse.add(stdMutableResult);
            }
            return stdMutableResponse;
        }
        catch (JsonParseException e) {
            throw new JSONStructureException("Unable to parse JSON '" + json + "', exception: " + (Object)((Object)e), e);
        }
        catch (JsonMappingException e) {
            throw new JSONStructureException("Unable to map JSON '" + json + "', exception: " + (Object)((Object)e), e);
        }
        catch (IOException e) {
            throw new JSONStructureException("Unable to read JSON input, exception: " + e, e);
        }
    }

    public static String toString(Response response) throws Exception {
        return JSONResponse.toString(response, true);
    }

    public static String toString(Response response, boolean prettyPrint) throws Exception {
        String outputString = null;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            JSONResponse.convert(response, os, prettyPrint);
            outputString = new String(os.toByteArray(), "UTF-8");
        }
        return outputString;
    }

    public static void convert(Response response, OutputStream outputStream) throws IOException, JSONStructureException {
        JSONResponse.convert(response, outputStream, false);
    }

    public static void convert(Response response, OutputStream outputStream, boolean prettyPrint) throws IOException, JSONStructureException {
        if (outputShorthandMap == null) {
            JSONResponse.initOutputShorthandMap();
        }
        if (response == null) {
            throw new JSONStructureException("No Request in convert");
        }
        if (response.getResults() == null || response.getResults().size() == 0) {
            throw new JSONStructureException("No Result in Response");
        }
        String json = null;
        ArrayList responses = new ArrayList();
        for (Result result : response.getResults()) {
            AttributeValue<?> value;
            HashMap<String, Object> entityTree;
            AttributeAssignment entity;
            ArrayList attributes;
            Iterator<AttributeAssignment> iterSetObs;
            HashMap<String, Object> responseTree = new HashMap<String, Object>();
            if (result.getDecision() == null) {
                throw new JSONStructureException("No Decision in Result");
            }
            responseTree.put("Decision", result.getDecision().toString());
            if (result.getStatus() != null) {
                if (result.getStatus().getStatusCode() == null) {
                    throw new JSONStructureException("No Identifier given in StatusCode");
                }
                Identifier statusCodeId = result.getStatus().getStatusCode().getStatusCodeValue();
                if (statusCodeId.equals(StdStatusCode.STATUS_CODE_OK.getStatusCodeValue()) && result.getDecision() != Decision.DENY && result.getDecision() != Decision.PERMIT && result.getDecision() != Decision.NOTAPPLICABLE || !statusCodeId.equals(StdStatusCode.STATUS_CODE_OK.getStatusCodeValue()) && result.getDecision() != Decision.INDETERMINATE && result.getDecision() != Decision.INDETERMINATE_DENY && result.getDecision() != Decision.INDETERMINATE_DENYPERMIT && result.getDecision() != Decision.INDETERMINATE_PERMIT) {
                    throw new JSONStructureException("StatusCode '" + statusCodeId.stringValue() + "' does not match Decision '" + result.getDecision().toString());
                }
                HashMap<String, Object> statusTree = new HashMap<String, Object>();
                HashMap<String, Object> statusValue = new HashMap<String, Object>();
                statusValue.put("Value", statusCodeId.stringValue());
                JSONResponse.addChildStatusCodes(result.getStatus().getStatusCode(), statusValue);
                statusTree.put("StatusCode", statusValue);
                String message = result.getStatus().getStatusMessage();
                if (message != null) {
                    statusTree.put("StatusMessage", message);
                }
                if (result.getStatus().getStatusDetail() != null) {
                    String statusDetailXMLString = "";
                    if (result.getStatus().isOk()) {
                        throw new JSONStructureException("Status '" + result.getStatus().getStatusCode().toString() + "' must not return StatusDetail");
                    }
                    if (result.getStatus().getStatusCode().equals(XACML3.ID_STATUS_MISSING_ATTRIBUTE) && result.getStatus().getStatusDetail().getMissingAttributeDetails() == null) {
                        throw new JSONStructureException("Status '" + result.getStatus().getStatusCode().toString() + "' has StatusDetail without MissingAttributeDetail");
                    }
                    if (result.getStatus().getStatusCode().equals(XACML3.ID_STATUS_SYNTAX_ERROR)) {
                        throw new JSONStructureException("Status '" + result.getStatus().getStatusCode().toString() + "' must not return StatusDetail");
                    }
                    if (result.getStatus().getStatusCode().equals(XACML3.ID_STATUS_PROCESSING_ERROR)) {
                        throw new JSONStructureException("Status '" + result.getStatus().getStatusCode().toString() + "' must not return StatusDetail");
                    }
                    if (result.getStatus().getStatusDetail().getMissingAttributeDetails() != null) {
                        if (!statusCodeId.equals(XACML3.ID_STATUS_MISSING_ATTRIBUTE)) {
                            throw new JSONStructureException("MissingAttributeDetails can only be included when StatusCode is MISSING_ATTRIBUTES, not '" + statusCodeId.stringValue());
                        }
                        if (result.getStatus().getStatusDetail().getMissingAttributeDetails().size() > 0) {
                            statusDetailXMLString = "";
                            for (MissingAttributeDetail mad : result.getStatus().getStatusDetail().getMissingAttributeDetails()) {
                                statusDetailXMLString = statusDetailXMLString + "<MissingAttributeDetail";
                                if (mad.getCategory() == null || mad.getAttributeId() == null || mad.getDataTypeId() == null) {
                                    throw new JSONStructureException("MissingAttributeDetail must have Category, AttributeId and DataType");
                                }
                                statusDetailXMLString = statusDetailXMLString + " Category=\"" + mad.getCategory().stringValue() + "\"";
                                statusDetailXMLString = statusDetailXMLString + " AttributeId=\"" + mad.getAttributeId().stringValue() + "\"";
                                statusDetailXMLString = statusDetailXMLString + " DataType=\"" + mad.getDataTypeId().stringValue() + "\"";
                                if (mad.getIssuer() != null) {
                                    statusDetailXMLString = statusDetailXMLString + " Issuer=\"" + mad.getIssuer() + "\"";
                                }
                                statusDetailXMLString = statusDetailXMLString + ">";
                                if (mad.getAttributeValues() == null || mad.getAttributeValues().size() <= 0) continue;
                                for (AttributeValue<?> av : mad.getAttributeValues()) {
                                    statusDetailXMLString = statusDetailXMLString + "<AttributeValue";
                                    statusDetailXMLString = statusDetailXMLString + " DataType=\"" + av.getDataTypeId() + "\">";
                                    statusDetailXMLString = statusDetailXMLString + JSONResponse.jsonOutputObject(av.getValue(), av).toString() + "</AttributeValue>";
                                }
                            }
                            statusDetailXMLString = statusDetailXMLString + "</MissingAttributeDetail>";
                        }
                    } else {
                        throw new JSONStructureException("Unhandled StatusDetail contents (statusDetail exists but is not MissingAttributeDetail)");
                    }
                    if (statusDetailXMLString.length() > 0) {
                        statusDetailXMLString = statusDetailXMLString.replace("\\", "\\\\");
                        statusDetailXMLString = statusDetailXMLString.replace("\"", "\\\"");
                        statusTree.put("StatusDetail", statusDetailXMLString);
                    }
                }
                responseTree.put("Status", statusTree);
            }
            if (result.getObligations() != null && result.getObligations().size() > 0) {
                Iterator<Obligation> iterObs = result.getObligations().iterator();
                ArrayList obligationCollectionList = new ArrayList();
                while (iterObs.hasNext()) {
                    Obligation ob = iterObs.next();
                    HashMap<String, Object> obligationTree = new HashMap<String, Object>();
                    if (ob.getId() == null) {
                        throw new JSONStructureException("Obligation must have Id");
                    }
                    obligationTree.put("Id", ob.getId().stringValue());
                    if (ob.getAttributeAssignments() != null && ob.getAttributeAssignments().size() > 0) {
                        iterSetObs = ob.getAttributeAssignments().iterator();
                        attributes = new ArrayList();
                        while (iterSetObs.hasNext()) {
                            entity = iterSetObs.next();
                            entityTree = new HashMap<String, Object>();
                            if (entity.getAttributeId() == null) {
                                throw new JSONStructureException("Obligation Attribute must have AttributeId");
                            }
                            entityTree.put("AttributeId", entity.getAttributeId().stringValue());
                            if (entity.getCategory() != null) {
                                entityTree.put("Category", entity.getCategory().stringValue());
                            }
                            if (entity.getIssuer() != null) {
                                entityTree.put("Issuer", entity.getIssuer());
                            }
                            if ((value = entity.getAttributeValue()) == null || value.getValue() == null) {
                                entityTree.put("Value", new String(""));
                            } else {
                                if (value.getDataTypeId() != null) {
                                    entityTree.put("DataType", value.getDataTypeId().stringValue());
                                }
                                entityTree.put("Value", JSONResponse.jsonOutputObject(value.getValue(), value));
                            }
                            attributes.add(entityTree);
                        }
                        obligationTree.put("AttributeAssignment", attributes);
                    }
                    obligationCollectionList.add(obligationTree);
                }
                responseTree.put("Obligations", obligationCollectionList);
            }
            if (result.getAssociatedAdvice() != null && result.getAssociatedAdvice().size() > 0) {
                Iterator<Advice> iterAAs = result.getAssociatedAdvice().iterator();
                ArrayList adviceCollectionList = new ArrayList();
                while (iterAAs.hasNext()) {
                    Advice advice = iterAAs.next();
                    HashMap<String, Object> adviceTree = new HashMap<String, Object>();
                    if (advice.getId() == null) {
                        throw new JSONStructureException("Advice must have Id");
                    }
                    adviceTree.put("Id", advice.getId().stringValue());
                    if (advice.getAttributeAssignments() != null && advice.getAttributeAssignments().size() > 0) {
                        iterSetObs = advice.getAttributeAssignments().iterator();
                        attributes = new ArrayList();
                        while (iterSetObs.hasNext()) {
                            entity = iterSetObs.next();
                            entityTree = new HashMap();
                            if (entity.getAttributeId() == null) {
                                throw new JSONStructureException("Advice Attribute must have AttributeId");
                            }
                            entityTree.put("AttributeId", entity.getAttributeId().stringValue());
                            if (entity.getCategory() != null) {
                                entityTree.put("Category", entity.getCategory().stringValue());
                            }
                            if (entity.getIssuer() != null) {
                                entityTree.put("Issuer", entity.getIssuer());
                            }
                            if ((value = entity.getAttributeValue()) == null || value.getValue() == null) {
                                entityTree.put("Value", new String(""));
                            } else {
                                if (value.getDataTypeId() != null) {
                                    entityTree.put("DataType", value.getDataTypeId().stringValue());
                                }
                                entityTree.put("Value", JSONResponse.jsonOutputObject(value.getValue(), value));
                            }
                            attributes.add(entityTree);
                        }
                        adviceTree.put("AttributeAssignment", attributes);
                    }
                    adviceCollectionList.add(adviceTree);
                }
                responseTree.put("AssociatedAdvice", adviceCollectionList);
            }
            if (result.getAttributes() != null && result.getAttributes().size() > 0) {
                Iterator<AttributeCategory> iterAttributes = result.getAttributes().iterator();
                ArrayList categoryArray = new ArrayList();
                while (iterAttributes.hasNext()) {
                    AttributeCategory entity2 = iterAttributes.next();
                    HashMap<String, Object> categoryTree = new HashMap<String, Object>();
                    categoryTree.put("CategoryId", entity2.getCategory().stringValue());
                    Collection<Attribute> attrs = entity2.getAttributes();
                    if (attrs != null) {
                        Iterator<Attribute> iterAttrs = attrs.iterator();
                        ArrayList arrayAttributes = new ArrayList();
                        while (iterAttrs.hasNext()) {
                            Attribute attribute = iterAttrs.next();
                            if (!attribute.getIncludeInResults()) continue;
                            HashMap<String, Object> theAttribute = new HashMap<String, Object>();
                            if (attribute.getAttributeId() == null) {
                                throw new JSONStructureException("Attribute must have AttributeId");
                            }
                            theAttribute.put("AttributeId", attribute.getAttributeId().stringValue());
                            if (attribute.getValues() == null || attribute.getValues().size() == 0) {
                                throw new JSONStructureException("Attribute missing required Value");
                            }
                            Iterator<AttributeValue<?>> valueIterator = attribute.getValues().iterator();
                            if (attribute.getValues().size() == 1) {
                                AttributeValue<?> attributeValue = valueIterator.next();
                                if (attributeValue == null || attributeValue.getValue() == null) {
                                    throw new JSONStructureException("Attribute must have value");
                                }
                                theAttribute.put("Value", JSONResponse.jsonOutputObject(attributeValue.getValue(), attributeValue));
                                if (attributeValue.getDataTypeId() != null) {
                                    theAttribute.put("DataType", attributeValue.getDataTypeId().stringValue());
                                }
                            } else {
                                ArrayList<Object> attrValueList = new ArrayList<Object>();
                                boolean mixedTypes = false;
                                SemanticString inferredDataTypeId = null;
                                while (valueIterator.hasNext()) {
                                    AttributeValue<?> attrValue = valueIterator.next();
                                    if (attrValue == null || attrValue.getValue() == null) {
                                        throw new JSONStructureException("Attribute in array must have value");
                                    }
                                    attrValueList.add(JSONResponse.jsonOutputObject(attrValue.getValue(), attrValue));
                                    if (attrValue.getDataTypeId() == null) continue;
                                    if (inferredDataTypeId == null) {
                                        inferredDataTypeId = attrValue.getDataTypeId();
                                        continue;
                                    }
                                    if (inferredDataTypeId.equals(DataTypes.DT_INTEGER.getId()) && attrValue.getDataTypeId().equals(DataTypes.DT_DOUBLE.getId())) {
                                        inferredDataTypeId = attrValue.getDataTypeId();
                                        continue;
                                    }
                                    if (inferredDataTypeId.equals(DataTypes.DT_DOUBLE.getId()) && attrValue.getDataTypeId().equals(DataTypes.DT_INTEGER.getId()) || inferredDataTypeId.equals(attrValue.getDataTypeId())) continue;
                                    throw new JSONStructureException("Mixed DataTypes in Attribute values, '" + attrValue.getDataTypeId().stringValue() + "' in list of '" + inferredDataTypeId.stringValue() + "'");
                                }
                                theAttribute.put("Value", attrValueList);
                                if (inferredDataTypeId != null && !mixedTypes) {
                                    theAttribute.put("DataType", inferredDataTypeId.stringValue());
                                }
                            }
                            if (attribute.getIssuer() != null) {
                                theAttribute.put("Issuer", attribute.getIssuer());
                            }
                            arrayAttributes.add(theAttribute);
                        }
                        categoryTree.put("Attribute", arrayAttributes);
                    }
                    if (categoryTree.size() <= 0) continue;
                    categoryArray.add(categoryTree);
                }
                if (categoryArray.size() > 0) {
                    responseTree.put("Category", categoryArray);
                }
            }
            if (result.getPolicyIdentifiers() != null && result.getPolicyIdentifiers().size() > 0 || result.getPolicySetIdentifiers() != null && result.getPolicySetIdentifiers().size() > 0) {
                HashMap<String, String> entityTree2;
                ArrayList policyIdentifierList;
                HashMap policyIdentifierCollectionList = new HashMap();
                if (result.getPolicyIdentifiers() != null && result.getPolicyIdentifiers().size() > 0) {
                    policyIdentifierList = new ArrayList();
                    for (IdReference idRef : result.getPolicyIdentifiers()) {
                        if (idRef == null) {
                            throw new JSONStructureException("PolicyIdReference with null reference");
                        }
                        entityTree2 = new HashMap<String, String>();
                        entityTree2.put("Id", idRef.getId().stringValue());
                        if (idRef.getVersion() != null) {
                            entityTree2.put("Version", idRef.getVersion().stringValue());
                        }
                        policyIdentifierList.add(entityTree2);
                    }
                    policyIdentifierCollectionList.put("PolicyIdReference", policyIdentifierList);
                }
                if (result.getPolicySetIdentifiers() != null && result.getPolicySetIdentifiers().size() > 0) {
                    policyIdentifierList = new ArrayList();
                    for (IdReference idRef : result.getPolicySetIdentifiers()) {
                        if (idRef == null) {
                            throw new JSONStructureException("PolicySetIdReference with null reference");
                        }
                        entityTree2 = new HashMap();
                        entityTree2.put("Id", idRef.getId().stringValue());
                        if (idRef.getVersion() != null) {
                            entityTree2.put("Version", idRef.getVersion().stringValue());
                        }
                        policyIdentifierList.add(entityTree2);
                    }
                    policyIdentifierCollectionList.put("PolicySetIdReference", policyIdentifierList);
                }
                responseTree.put("PolicyIdentifier", policyIdentifierCollectionList);
            }
            responses.add(responseTree);
        }
        HashMap theWholeResponse = new HashMap();
        theWholeResponse.put("Response", responses);
        ObjectMapper mapper = new ObjectMapper().setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
        mapper.configure(SerializationFeature.INDENT_OUTPUT, prettyPrint);
        try (OutputStreamWriter osw = new OutputStreamWriter(outputStream);){
            json = mapper.writeValueAsString(theWholeResponse);
            osw.write(json);
            osw.flush();
        }
        catch (Exception e) {
            logger.error((Object)("Failed to write to json string: " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    private static void addChildStatusCodes(StatusCode statusCode, Map<String, Object> map) {
        if (statusCode.getChild() != null) {
            StatusCode child = statusCode.getChild();
            HashMap<String, Object> childMap = new HashMap<String, Object>();
            childMap.put("Value", child.getStatusCodeValue().stringValue());
            JSONResponse.addChildStatusCodes(child, childMap);
            map.put("StatusCode", childMap);
        }
    }

    private static Object jsonOutputObject(Object obj, AttributeValue<?> attrValue) throws JSONStructureException {
        if (obj instanceof String || obj instanceof Boolean || obj instanceof BigInteger) {
            return obj;
        }
        if (obj instanceof Double) {
            Double d = (Double)obj;
            if (d == Double.NaN) {
                return "NaN";
            }
            if (d == Double.POSITIVE_INFINITY) {
                return "INF";
            }
            if (d == Double.NEGATIVE_INFINITY) {
                return "-INF";
            }
            return obj;
        }
        if (obj instanceof SemanticString) {
            return ((SemanticString)obj).stringValue();
        }
        if (obj instanceof X500Principal || obj instanceof URI) {
            return obj.toString();
        }
        if (obj instanceof XPathExpressionWrapper) {
            HashMap<String, Object> xpathExpressionMap = new HashMap<String, Object>();
            Identifier xpathCategoryId = attrValue.getXPathCategory();
            if (xpathCategoryId == null) {
                throw new JSONStructureException("XPathExpression is missing XPathCategory");
            }
            xpathExpressionMap.put("XPathCategory", attrValue.getXPathCategory().stringValue());
            XPathExpressionWrapper xw = (XPathExpressionWrapper)obj;
            xpathExpressionMap.put("XPath", xw.getPath());
            ExtendedNamespaceContext namespaceContext = xw.getNamespaceContext();
            if (namespaceContext != null) {
                ArrayList namespaceList = new ArrayList();
                Iterator<String> prefixIt = namespaceContext.getAllPrefixes();
                while (prefixIt.hasNext()) {
                    String prefix = prefixIt.next();
                    String namespaceURI = namespaceContext.getNamespaceURI(prefix);
                    HashMap<String, String> namespaceMap = new HashMap<String, String>();
                    if (prefix != null && !prefix.equals("")) {
                        namespaceMap.put("Prefix", prefix);
                    }
                    namespaceMap.put("Namespace", namespaceURI);
                    namespaceList.add(namespaceMap);
                }
                xpathExpressionMap.put("Namespaces", namespaceList);
            }
            return xpathExpressionMap;
        }
        throw new JSONStructureException("Unhandled data type='" + obj.getClass().getName() + "'");
    }
}

