/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import java.util.Collection;
import java.util.LinkedList;
import org.apache.openaz.xacml.api.pap.PDP;
import org.apache.openaz.xacml.api.pap.PDPGroup;

public class StdPDPItemSetChangeNotifier {
    private Collection<StdItemSetChangeListener> listeners;

    public void addItemSetChangeListener(StdItemSetChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new LinkedList<StdItemSetChangeListener>();
        }
        this.listeners.add(listener);
    }

    public void removeItemSetChangeListener(StdItemSetChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void fireChanged() {
        if (this.listeners == null) {
            return;
        }
        for (StdItemSetChangeListener l : this.listeners) {
            l.changed();
        }
    }

    public void firePDPGroupChanged(PDPGroup group) {
        if (this.listeners == null) {
            return;
        }
        for (StdItemSetChangeListener l : this.listeners) {
            l.groupChanged(group);
        }
    }

    public void firePDPChanged(PDP pdp) {
        if (this.listeners == null) {
            return;
        }
        for (StdItemSetChangeListener l : this.listeners) {
            l.pdpChanged(pdp);
        }
    }

    public static interface StdItemSetChangeListener {
        public void changed();

        public void groupChanged(PDPGroup var1);

        public void pdpChanged(PDP var1);
    }
}

