/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pap;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pap.PDPPIPConfig;

public class StdPDPPIPConfig
implements PDPPIPConfig,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Log logger = LogFactory.getLog(StdPDPPIPConfig.class);
    private String id;
    private String name;
    private String description;
    private String classname;
    private Map<String, String> config = new HashMap<String, String>();

    public StdPDPPIPConfig() {
    }

    public StdPDPPIPConfig(String id) {
        this.id = id;
    }

    public StdPDPPIPConfig(String id, String name, String description) {
        this(id);
        this.name = name;
        this.description = description;
    }

    public StdPDPPIPConfig(String id, Properties properties) {
        this(id);
        if (!this.initialize(properties)) {
            throw new IllegalArgumentException("PIP Engine '" + id + "' has no classname property in config");
        }
    }

    public boolean initialize(Properties properties) {
        boolean classnameSeen = false;
        for (Object key : properties.keySet()) {
            if (!key.toString().startsWith(this.id + ".")) continue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found: " + key));
            }
            if (key.toString().equals(this.id + ".name")) {
                this.name = properties.getProperty(key.toString());
            } else if (key.toString().equals(this.id + ".description")) {
                this.description = properties.getProperty(key.toString());
            } else if (key.toString().equals(this.id + ".classname")) {
                this.classname = properties.getProperty(key.toString());
                classnameSeen = true;
            }
            this.config.put(key.toString(), properties.getProperty(key.toString()));
        }
        return classnameSeen;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getClassname() {
        return this.classname;
    }

    public void setClassname(String classname) {
        this.classname = classname;
    }

    @Override
    @JsonIgnore
    public Map<String, String> getConfiguration() {
        return Collections.unmodifiableMap(this.config);
    }

    public void setValues(Map<String, String> config) {
        this.config = config;
    }

    @Override
    @JsonIgnore
    public boolean isConfigured() {
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.classname == null ? 0 : this.classname.hashCode());
        result = 31 * result + (this.config == null ? 0 : this.config.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StdPDPPIPConfig other = (StdPDPPIPConfig)obj;
        if (this.classname == null ? other.classname != null : !this.classname.equals(other.classname)) {
            return false;
        }
        if (this.config == null ? other.config != null : !this.config.equals(other.config)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "StdPDPPIPConfig [id=" + this.id + ", name=" + this.name + ", description=" + this.description + ", classname=" + this.classname + ", config=" + this.config + "]";
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public void setConfig(Map<String, String> config) {
        this.config = config;
    }
}

