/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdMutableAttribute;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;
import org.apache.openaz.xacml.std.pip.StdSinglePIPResponse;

public class EnvironmentEngine
implements PIPEngine {
    private Date contextTime;
    private StdSinglePIPResponse responseTime;
    private StdSinglePIPResponse responseDate;
    private StdSinglePIPResponse responseDateTime;

    protected StdSinglePIPResponse getResponseTime() throws DataTypeException {
        if (this.responseTime == null) {
            this.responseTime = new StdSinglePIPResponse(new StdMutableAttribute(XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT, XACML3.ID_ENVIRONMENT_CURRENT_TIME, DataTypes.DT_TIME.createAttributeValue(this.contextTime)));
        }
        return this.responseTime;
    }

    protected StdSinglePIPResponse getResponseDate() throws DataTypeException {
        if (this.responseDate == null) {
            this.responseDate = new StdSinglePIPResponse(new StdMutableAttribute(XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT, XACML3.ID_ENVIRONMENT_CURRENT_DATE, DataTypes.DT_DATE.createAttributeValue(this.contextTime)));
        }
        return this.responseDate;
    }

    protected StdSinglePIPResponse getResponseDateTime() throws DataTypeException {
        if (this.responseDateTime == null) {
            this.responseDateTime = new StdSinglePIPResponse(new StdMutableAttribute(XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT, XACML3.ID_ENVIRONMENT_CURRENT_DATETIME, DataTypes.DT_DATETIME.createAttributeValue(this.contextTime)));
        }
        return this.responseDateTime;
    }

    public EnvironmentEngine(Date dateContextTimeIn) {
        this.contextTime = dateContextTimeIn;
    }

    @Override
    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public String getDescription() {
        return "Environment attribute PIP";
    }

    @Override
    public Collection<PIPRequest> attributesRequired() {
        return Collections.emptyList();
    }

    @Override
    public Collection<PIPRequest> attributesProvided() {
        ArrayList<PIPRequest> attributes = new ArrayList<PIPRequest>();
        attributes.add(new StdPIPRequest(XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT, XACML3.ID_ENVIRONMENT_CURRENT_DATE, XACML3.ID_DATATYPE_DATE, null));
        attributes.add(new StdPIPRequest(XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT, XACML3.ID_ENVIRONMENT_CURRENT_TIME, XACML3.ID_DATATYPE_TIME, null));
        attributes.add(new StdPIPRequest(XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT, XACML3.ID_ENVIRONMENT_CURRENT_DATETIME, XACML3.ID_DATATYPE_DATETIME, null));
        return attributes;
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (!XACML3.ID_ATTRIBUTE_CATEGORY_ENVIRONMENT.equals(pipRequest.getCategory()) || pipRequest.getIssuer() != null && pipRequest.getIssuer().length() > 0) {
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        Identifier attributeIdRequest = pipRequest.getAttributeId();
        StdSinglePIPResponse pipResponse = null;
        try {
            if (XACML3.ID_ENVIRONMENT_CURRENT_DATE.equals(attributeIdRequest)) {
                pipResponse = this.getResponseDate();
            } else if (XACML3.ID_ENVIRONMENT_CURRENT_TIME.equals(attributeIdRequest)) {
                pipResponse = this.getResponseTime();
            } else if (XACML3.ID_ENVIRONMENT_CURRENT_DATETIME.equals(attributeIdRequest)) {
                pipResponse = this.getResponseDateTime();
            }
        }
        catch (DataTypeException ex) {
            throw new PIPException("DataTypeException getting \"" + attributeIdRequest.stringValue() + "\"", ex);
        }
        if (pipResponse == null) {
            return StdPIPResponse.PIP_RESPONSE_EMPTY;
        }
        AttributeValue<?> attributeValuePipResponse = pipResponse.getSingleAttribute().getValues().iterator().next();
        if (attributeValuePipResponse.getDataTypeId().equals(pipRequest.getDataTypeId())) {
            return pipResponse;
        }
        return StdPIPResponse.PIP_RESPONSE_EMPTY;
    }
}

