/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.jdbc;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.XACML3;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.datatypes.ISO8601Date;
import org.apache.openaz.xacml.std.datatypes.ISO8601DateTime;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.engines.Configurables;
import org.apache.openaz.xacml.std.pip.engines.jdbc.JDBCResolver;

public class ConfigurableJDBCResolver
implements JDBCResolver {
    public static final String PROP_SELECT = "select";
    public static final String PROP_SELECT_FIELDS = "fields";
    public static final String PROP_SELECT_FIELD = "field";
    public static final String PROP_SELECT_PARAMETERS = "parameters";
    public static final String PROP_SELECT_PARAMETER = "parameter";
    private Log logger = LogFactory.getLog(this.getClass());
    private String defaultIssuer;
    private Set<PIPRequest> supportedRequests = new HashSet<PIPRequest>();
    private Set<PIPRequest> supportedRequestsNoIssuer = new HashSet<PIPRequest>();
    private Map<String, PIPRequest> mapFields = new HashMap<String, PIPRequest>();
    private String sqlQuery;
    private List<PIPRequest> parameters = new ArrayList<PIPRequest>();
    private static DataTypeFactory dataTypeFactory = null;

    protected boolean isSupported(PIPRequest pipRequest) {
        if (pipRequest.getIssuer() == null) {
            return this.supportedRequestsNoIssuer.contains(pipRequest);
        }
        return this.supportedRequests.contains(pipRequest);
    }

    public ConfigurableJDBCResolver() {
        if (dataTypeFactory == null) {
            throw new IllegalStateException("No DataTypeFactory instance created");
        }
    }

    public Map<String, PIPRequest> getMapFields() {
        return this.mapFields;
    }

    public List<PIPRequest> getParameters() {
        return this.parameters;
    }

    public Properties generateProperties(String id, String select) {
        return ConfigurableJDBCResolver.generateProperties(id, select, this.mapFields, this.parameters);
    }

    public static Properties generateProperties(String id, String select, Map<String, PIPRequest> mapFields, List<PIPRequest> parameters) {
        Properties properties = new Properties();
        properties.setProperty(Joiner.on((char)'.').join((Object)id, (Object)PROP_SELECT, new Object[0]), select);
        if (mapFields.size() > 0) {
            properties.setProperty(Joiner.on((char)'.').join((Object)id, (Object)PROP_SELECT_FIELDS, new Object[0]), Joiner.on((char)',').join(mapFields.keySet()));
            for (String field : mapFields.keySet()) {
                PIPRequest request = mapFields.get(field);
                String fieldPrefix = Joiner.on((char)'.').join((Object)id, (Object)PROP_SELECT_FIELD, new Object[0]);
                properties.setProperty(fieldPrefix + ".id", request.getAttributeId().stringValue());
                properties.setProperty(fieldPrefix + ".datatype", request.getDataTypeId().stringValue());
                properties.setProperty(fieldPrefix + ".category", request.getCategory().stringValue());
                if (request.getIssuer() == null) continue;
                properties.setProperty(fieldPrefix + ".issuer", request.getIssuer());
            }
        }
        if (parameters.size() > 0) {
            String params = "1";
            for (int i = 2; i <= parameters.size(); ++i) {
                params = params + "," + i;
            }
            properties.setProperty(Joiner.on((char)'.').join((Object)id, (Object)PROP_SELECT_PARAMETERS, new Object[0]), params);
            int position = 1;
            for (PIPRequest request : parameters) {
                String fieldPrefix = Joiner.on((char)'.').join((Object)id, (Object)PROP_SELECT_PARAMETER, new Object[]{position++});
                properties.setProperty(fieldPrefix + ".id", request.getAttributeId().stringValue());
                properties.setProperty(fieldPrefix + ".datatype", request.getDataTypeId().stringValue());
                properties.setProperty(fieldPrefix + ".category", request.getCategory().stringValue());
                if (request.getIssuer() == null) continue;
                properties.setProperty(fieldPrefix + ".issuer", request.getIssuer());
            }
        }
        return properties;
    }

    protected void configureField(String id, String fieldName, Properties properties) throws PIPException {
        PIPRequest pipRequestField = Configurables.getPIPRequest(id + "." + PROP_SELECT_FIELD + "." + fieldName, properties, this.defaultIssuer);
        this.supportedRequests.add(pipRequestField);
        this.supportedRequestsNoIssuer.add(new StdPIPRequest(pipRequestField.getCategory(), pipRequestField.getAttributeId(), pipRequestField.getDataTypeId()));
        this.mapFields.put(fieldName, pipRequestField);
    }

    protected void configureParameter(String id, String parameterName, Properties properties) throws PIPException {
        PIPRequest pipRequestParameter = Configurables.getPIPRequest(id + "." + PROP_SELECT_PARAMETER + "." + parameterName, properties, null);
        this.parameters.add(pipRequestParameter);
    }

    @Override
    public void configure(String id, Properties properties, String defaultIssuer) throws PIPException {
        this.defaultIssuer = defaultIssuer;
        String idPrefix = id + ".";
        String stringProp = idPrefix + PROP_SELECT;
        this.sqlQuery = properties.getProperty(stringProp);
        if (this.sqlQuery == null || this.sqlQuery.length() == 0) {
            this.logger.error((Object)("No '" + stringProp + "' property"));
            throw new PIPException("No '" + stringProp + "' property");
        }
        stringProp = idPrefix + PROP_SELECT_FIELDS;
        String fields = properties.getProperty(stringProp);
        if (fields == null || fields.length() == 0) {
            this.logger.error((Object)("No '" + stringProp + "' property"));
            throw new PIPException("No '" + stringProp + "' property");
        }
        for (String field : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)fields)) {
            this.configureField(id, field, properties);
        }
        stringProp = idPrefix + PROP_SELECT_PARAMETERS;
        String parameters = properties.getProperty(stringProp);
        if (parameters != null && parameters.length() > 0) {
            for (String parameter : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)parameters)) {
                this.configureParameter(id, parameter, properties);
            }
        }
    }

    @Override
    public PreparedStatement getPreparedStatement(PIPEngine pipEngine, PIPRequest pipRequest, PIPFinder pipFinder, Connection connection) throws PIPException {
        if (!this.isSupported(pipRequest)) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        try {
            preparedStatement = connection.prepareStatement(this.sqlQuery);
        }
        catch (SQLException ex) {
            this.logger.error((Object)("SQLException creating PreparedStatement: " + ex.toString()), (Throwable)ex);
            return null;
        }
        if (this.parameters.size() > 0) {
            for (int i = 0; i < this.parameters.size(); ++i) {
                PIPRequest pipRequestParameter = this.parameters.get(i);
                PIPResponse pipResponse = pipFinder.getMatchingAttributes(pipRequestParameter, null);
                if (pipResponse.getStatus() == null || pipResponse.getStatus().isOk()) {
                    Collection<Attribute> listAttributes = pipResponse.getAttributes();
                    if (listAttributes.size() > 0) {
                        if (listAttributes.size() > 1) {
                            this.logger.error((Object)("PIPFinder returned more than one Attribute for " + pipRequestParameter.toString()));
                            throw new PIPException("PIPFinder returned more than one Attribute for " + pipRequestParameter.toString());
                        }
                        Collection<AttributeValue<?>> listAttributeValuesReturned = listAttributes.iterator().next().getValues();
                        if (listAttributeValuesReturned.size() > 0) {
                            if (listAttributeValuesReturned.size() > 1) {
                                this.logger.warn((Object)("PIPFinder returned more than one AttributeValue for " + pipRequestParameter.toString()));
                                return null;
                            }
                            AttributeValue<?> attributeValue = listAttributeValuesReturned.iterator().next();
                            Identifier identifierAttributeValueDataType = attributeValue.getDataTypeId();
                            try {
                                Date sqlDate;
                                if (identifierAttributeValueDataType.equals(XACML3.ID_DATATYPE_INTEGER)) {
                                    preparedStatement.setInt(i + 1, DataTypes.DT_INTEGER.convert(attributeValue.getValue()).intValue());
                                    continue;
                                }
                                if (identifierAttributeValueDataType.equals(XACML3.ID_DATATYPE_DOUBLE)) {
                                    preparedStatement.setDouble(i + 1, DataTypes.DT_DOUBLE.convert(attributeValue.getValue()));
                                    continue;
                                }
                                if (identifierAttributeValueDataType.equals(XACML3.ID_DATATYPE_BOOLEAN)) {
                                    preparedStatement.setBoolean(i + 1, DataTypes.DT_BOOLEAN.convert(attributeValue.getValue()));
                                    continue;
                                }
                                if (identifierAttributeValueDataType.equals(XACML3.ID_DATATYPE_DATETIME)) {
                                    ISO8601DateTime iso8601DateTime = DataTypes.DT_DATETIME.convert(attributeValue.getValue());
                                    sqlDate = new Date(iso8601DateTime.getCalendar().getTimeInMillis());
                                    preparedStatement.setDate(i + 1, sqlDate, iso8601DateTime.getCalendar());
                                    continue;
                                }
                                if (identifierAttributeValueDataType.equals(XACML3.ID_DATATYPE_DATE)) {
                                    ISO8601Date iso8601Date = DataTypes.DT_DATE.convert(attributeValue.getValue());
                                    sqlDate = new Date(iso8601Date.getCalendar().getTimeInMillis());
                                    preparedStatement.setDate(i + 1, sqlDate, iso8601Date.getCalendar());
                                    continue;
                                }
                                preparedStatement.setString(i + 1, DataTypes.DT_STRING.convert(attributeValue.getValue()));
                                continue;
                            }
                            catch (Exception ex) {
                                this.logger.error((Object)("Exception setting parameter " + (i + 1) + " to " + attributeValue.toString() + ": " + ex.toString()), (Throwable)ex);
                                return null;
                            }
                        }
                        this.logger.warn((Object)("No AttributeValues returned for parameter " + pipRequestParameter.toString()));
                        return null;
                    }
                    this.logger.warn((Object)("No Attributes returned for parameter " + pipRequestParameter.toString()));
                    return null;
                }
                this.logger.warn((Object)("PIPFinder returned status " + pipResponse.getStatus().toString()));
                return null;
            }
        }
        return preparedStatement;
    }

    protected Attribute getAttributeFromResultSet(ResultSet resultSet, String fieldName, PIPRequest pipRequestAttribute) {
        AttributeValue<?> attributeValue = null;
        Identifier identifierDataType = pipRequestAttribute.getDataTypeId();
        try {
            DataType<?> dataType = dataTypeFactory.getDataType(identifierDataType);
            if (dataType == null) {
                this.logger.warn((Object)("Unknown data type " + pipRequestAttribute.getDataTypeId().stringValue()));
                return null;
            }
            int columnIndex = -1;
            try {
                columnIndex = resultSet.findColumn(fieldName);
            }
            catch (Exception e) {
                try {
                    columnIndex = Integer.parseInt(fieldName);
                }
                catch (Exception e1) {
                    this.logger.error((Object)("Failed to find column with label " + fieldName));
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Column " + fieldName + " maps to column index " + columnIndex));
            }
            if (identifierDataType.equals(XACML3.ID_DATATYPE_BOOLEAN)) {
                attributeValue = dataType.createAttributeValue(resultSet.getBoolean(columnIndex));
            } else if (identifierDataType.equals(XACML3.ID_DATATYPE_DATE) || identifierDataType.equals(XACML3.ID_DATATYPE_DATETIME)) {
                attributeValue = dataType.createAttributeValue(resultSet.getDate(columnIndex));
            } else if (identifierDataType.equals(XACML3.ID_DATATYPE_DOUBLE)) {
                attributeValue = dataType.createAttributeValue(resultSet.getDouble(columnIndex));
            } else if (identifierDataType.equals(XACML3.ID_DATATYPE_INTEGER)) {
                attributeValue = dataType.createAttributeValue(resultSet.getInt(columnIndex));
            } else {
                String stringValue = resultSet.getString(columnIndex);
                if (stringValue != null) {
                    attributeValue = dataType.createAttributeValue(stringValue);
                }
            }
        }
        catch (Exception ex) {
            this.logger.error((Object)("Exception getting value for fieldName '" + fieldName + "' as a " + identifierDataType.stringValue() + ": " + ex.toString()), (Throwable)ex);
            return null;
        }
        String issuer = this.defaultIssuer;
        if (pipRequestAttribute.getIssuer() != null) {
            issuer = pipRequestAttribute.getIssuer();
        }
        return new StdAttribute(pipRequestAttribute.getCategory(), pipRequestAttribute.getAttributeId(), attributeValue, issuer, false);
    }

    @Override
    public List<Attribute> decodeResult(ResultSet resultSet) throws PIPException {
        ArrayList<Attribute> listAttributes = new ArrayList<Attribute>();
        for (String fieldName : this.mapFields.keySet()) {
            PIPRequest pipRequestField = this.mapFields.get(fieldName);
            assert (pipRequestField != null);
            Attribute attribute = this.getAttributeFromResultSet(resultSet, fieldName, pipRequestField);
            if (attribute == null) continue;
            listAttributes.add(attribute);
        }
        return listAttributes;
    }

    @Override
    public void attributesRequired(Collection<PIPRequest> parameters) {
        for (PIPRequest parameter : this.parameters) {
            parameters.add(new StdPIPRequest(parameter.getCategory(), parameter.getAttributeId(), parameter.getDataTypeId(), parameter.getIssuer()));
        }
    }

    @Override
    public void attributesProvided(Collection<PIPRequest> attributes) {
        for (String key : this.mapFields.keySet()) {
            PIPRequest attribute = this.mapFields.get(key);
            attributes.add(new StdPIPRequest(attribute.getCategory(), attribute.getAttributeId(), attribute.getDataTypeId(), attribute.getIssuer() != null ? attribute.getIssuer() : this.defaultIssuer));
        }
    }

    static {
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
        }
        catch (Exception ex) {
            LogFactory.getLog(ConfigurableJDBCResolver.class).error((Object)("Exception geting DataTypeFactory: " + ex.toString()), (Throwable)ex);
        }
    }
}

