/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.engines.ldap;

import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.AttributeValue;
import org.apache.openaz.xacml.api.DataType;
import org.apache.openaz.xacml.api.DataTypeException;
import org.apache.openaz.xacml.api.DataTypeFactory;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.datatypes.DataTypes;
import org.apache.openaz.xacml.std.pip.StdPIPRequest;
import org.apache.openaz.xacml.std.pip.engines.Configurables;
import org.apache.openaz.xacml.std.pip.engines.ldap.LDAPResolver;
import org.apache.openaz.xacml.util.FactoryException;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.Velocity;
import org.apache.velocity.app.event.EventCartridge;
import org.apache.velocity.app.event.EventHandler;
import org.apache.velocity.app.event.ReferenceInsertionEventHandler;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.MethodInvocationException;
import org.apache.velocity.exception.ParseErrorException;
import org.apache.velocity.exception.ResourceNotFoundException;

public class ConfigurableLDAPResolver
implements LDAPResolver {
    private static DataTypeFactory dataTypeFactory = null;
    private Log logger = LogFactory.getLog(this.getClass());
    private String defaultIssuer;
    private String id;
    private String base;
    private String filter;
    private Map<String, PIPRequest> baseParameters;
    private Map<String, PIPRequest> filterParameters;
    private Map<String, PIPRequest> filterView;

    @Override
    public void configure(String id, Properties properties, String defaultIssuer) throws PIPException {
        this.id = id;
        this.defaultIssuer = defaultIssuer;
        this.base = properties.getProperty(id + ".base");
        this.filter = properties.getProperty(id + ".filter");
        Set<String> baseParametersNames = this.prepareVelocityTemplate(this.base);
        Set<String> filterParametersNames = this.prepareVelocityTemplate(this.filter);
        this.baseParameters = Configurables.getPIPRequestMap(id + ".base", "parameters", properties, null);
        this.filterParameters = Configurables.getPIPRequestMap(id + ".filter", "parameters", properties, null);
        if (!this.baseParameters.keySet().containsAll(baseParametersNames)) {
            throw new PIPException("The 'base' template contains parameters that were not specified in its map.");
        }
        if (!this.filterParameters.keySet().containsAll(filterParametersNames)) {
            throw new PIPException("The 'filter' template contains parameters that were not specified in its map.");
        }
        this.filterView = Configurables.getPIPRequestMap(id + ".filter", "view", properties, defaultIssuer);
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("(" + id + ") " + "\nbase '" + this.base + "', parameters " + this.baseParameters + "\nfilter '" + this.filter + "', parameters " + this.filterParameters + ", view " + this.filterView));
        }
    }

    public void store(String id, Properties properties) throws PIPException {
        properties.setProperty(id + ".base", this.base);
        properties.setProperty(id + ".filter", this.filter);
        Configurables.setPIPRequestMap(this.baseParameters, id + ".base", "parameters", properties);
        Configurables.setPIPRequestMap(this.filterParameters, id + ".filter", "parameters", properties);
        Configurables.setPIPRequestMap(this.filterView, id + ".filter", "view", properties);
    }

    private Set<String> prepareVelocityTemplate(String template) throws PIPException {
        VelocityContext vctx = new VelocityContext();
        EventCartridge vec = new EventCartridge();
        VelocityParameterReader reader = new VelocityParameterReader();
        vec.addEventHandler((EventHandler)reader);
        vec.attachToContext((Context)vctx);
        try {
            Velocity.evaluate((Context)vctx, (Writer)new StringWriter(), (String)"LdapResolver", (String)template);
        }
        catch (ParseErrorException pex) {
            throw new PIPException("Velocity template preparation failed", pex);
        }
        catch (MethodInvocationException mix) {
            throw new PIPException("Velocity template preparation failed", mix);
        }
        catch (ResourceNotFoundException rnfx) {
            throw new PIPException("Velocity template preparation failed", rnfx);
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("(" + this.id + ") " + template + " with parameters " + reader.parameters));
        }
        return reader.parameters;
    }

    private String evaluateVelocityTemplate(String template, Map<String, PIPRequest> templateParameters, PIPFinder pipFinder) throws PIPException {
        StringWriter out = new StringWriter();
        VelocityContext vctx = new VelocityContext();
        EventCartridge vec = new EventCartridge();
        VelocityParameterWriter writer = new VelocityParameterWriter(pipFinder, templateParameters);
        vec.addEventHandler((EventHandler)writer);
        vec.attachToContext((Context)vctx);
        try {
            Velocity.evaluate((Context)vctx, (Writer)out, (String)"LdapResolver", (String)template);
        }
        catch (ParseErrorException pex) {
            throw new PIPException("Velocity template evaluation failed", pex);
        }
        catch (MethodInvocationException mix) {
            throw new PIPException("Velocity template evaluation failed", mix);
        }
        catch (ResourceNotFoundException rnfx) {
            throw new PIPException("Velocity template evaluation failed", rnfx);
        }
        this.logger.warn((Object)("(" + this.id + ") " + " template yields " + out.toString()));
        return out.toString();
    }

    private Object evaluatePIPRequest(PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        Collection<org.apache.openaz.xacml.api.Attribute> listAttributes;
        PIPResponse pipResponse;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("(" + this.id + ") " + pipRequest));
        }
        if (((pipResponse = pipFinder.getMatchingAttributes(pipRequest, null)).getStatus() == null || pipResponse.getStatus().isOk()) && (listAttributes = pipResponse.getAttributes()).size() > 0) {
            if (listAttributes.size() > 1) {
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)("(" + this.id + ") " + "PIPFinder returned more than one Attribute for " + pipRequest));
                }
                throw new PIPException("PIPFinder returned more than one Attribute for " + pipRequest.toString());
            }
            Collection<AttributeValue<?>> listAttributeValuesReturned = listAttributes.iterator().next().getValues();
            if (listAttributeValuesReturned.size() > 0) {
                if (listAttributeValuesReturned.size() > 1) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("(" + this.id + ") " + "PIPFinder returned more than one AttributeValue for " + pipRequest));
                    }
                    return null;
                }
                AttributeValue<?> attributeValue = listAttributeValuesReturned.iterator().next();
                try {
                    return DataTypes.DT_STRING.convert(attributeValue.getValue());
                }
                catch (DataTypeException dtx) {
                    throw new PIPException("Fauiled to extract attribute value", dtx);
                }
            }
        }
        return null;
    }

    @Override
    public String getBase(PIPEngine pipEngine, PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (!this.filterView.containsValue(pipRequest)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("(" + this.id + ") " + pipRequest + " not in " + this.filterView));
            }
            return null;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("(" + this.id + ") " + pipRequest));
        }
        return this.evaluateVelocityTemplate(this.base, this.baseParameters, pipFinder);
    }

    public void setBase(String base) throws PIPException {
        Set<String> baseParametersNames = this.prepareVelocityTemplate(base);
        if (!this.baseParameters.keySet().containsAll(baseParametersNames)) {
            throw new PIPException("The 'base' template contains parameters that were not specified in its map.");
        }
        this.base = base;
    }

    @Override
    public String getFilterString(PIPEngine pipEngine, PIPRequest pipRequest, PIPFinder pipFinder) throws PIPException {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)("(" + this.id + ") " + pipRequest));
        }
        if (!this.filterView.containsValue(pipRequest)) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)("(" + this.id + ") " + "request " + pipRequest + " not in " + this.filterView));
            }
            return null;
        }
        return this.evaluateVelocityTemplate(this.filter, this.filterParameters, pipFinder);
    }

    public void setFilterString(String filter) throws PIPException {
        Set<String> filterParametersNames = this.prepareVelocityTemplate(filter);
        if (!this.filterParameters.keySet().containsAll(filterParametersNames)) {
            throw new PIPException("The 'filter' template contains parameters that were not specified in its map.");
        }
        this.filter = filter;
    }

    private org.apache.openaz.xacml.api.Attribute decodeResultValue(SearchResult searchResult, String view, PIPRequest viewRequest) {
        HashSet attributeMultiValue;
        AttributeValue<?> attributeValue;
        block12: {
            attributeValue = null;
            attributeMultiValue = null;
            DataType<?> dataType = null;
            this.logger.warn((Object)("(" + this.id + ") " + "SearchResult attributes: " + searchResult.getAttributes()));
            try {
                dataType = dataTypeFactory.getDataType(viewRequest.getDataTypeId());
                if (dataType == null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("(" + this.id + ") " + "Unknown data type in " + viewRequest));
                    }
                    return null;
                }
                if ("dn".equalsIgnoreCase(view)) {
                    attributeValue = dataType.createAttributeValue(searchResult.getNameInNamespace());
                    break block12;
                }
                Attribute dirAttr = searchResult.getAttributes().get(view);
                if (dirAttr != null) {
                    if (this.logger.isTraceEnabled()) {
                        this.logger.trace((Object)("(" + this.id + ") " + "directory attribute '" + view + "' value is '" + dirAttr + "'"));
                    }
                    if (dirAttr.size() == 1) {
                        attributeValue = dataType.createAttributeValue(dirAttr.get().toString());
                    } else {
                        if (this.logger.isTraceEnabled()) {
                            this.logger.trace((Object)("(" + this.id + ") " + "SearchResult yields a multi-valued '" + view + "'"));
                        }
                        attributeMultiValue = new HashSet();
                        for (int i = 0; i < dirAttr.size(); ++i) {
                            attributeMultiValue.add(dataType.createAttributeValue(dirAttr.get().toString()));
                        }
                    }
                    break block12;
                }
                this.logger.warn((Object)("(" + this.id + ") " + "SearchResult did not provide a value for '" + view + "'"));
                return null;
            }
            catch (DataTypeException dtx) {
                this.logger.error((Object)("(" + this.id + ") " + "Failed to decode search result"), (Throwable)dtx);
                return null;
            }
            catch (NamingException nx) {
                this.logger.error((Object)("(" + this.id + ") " + "Failed to decode search result"), (Throwable)nx);
                return null;
            }
        }
        StdAttribute attr = null;
        attr = attributeMultiValue == null ? new StdAttribute(viewRequest.getCategory(), viewRequest.getAttributeId(), attributeValue, viewRequest.getIssuer(), false) : new StdAttribute(viewRequest.getCategory(), viewRequest.getAttributeId(), attributeMultiValue, viewRequest.getIssuer(), false);
        this.logger.warn((Object)("(" + this.id + ") " + " providing attribute " + attr));
        return attr;
    }

    @Override
    public List<org.apache.openaz.xacml.api.Attribute> decodeResult(SearchResult searchResult) throws PIPException {
        ArrayList<org.apache.openaz.xacml.api.Attribute> attributes = new ArrayList<org.apache.openaz.xacml.api.Attribute>();
        for (Map.Entry<String, PIPRequest> viewEntry : this.filterView.entrySet()) {
            org.apache.openaz.xacml.api.Attribute attribute = this.decodeResultValue(searchResult, viewEntry.getKey(), viewEntry.getValue());
            if (attribute == null) continue;
            attributes.add(attribute);
        }
        return attributes;
    }

    @Override
    public void attributesRequired(Collection<PIPRequest> attributes) {
        for (String key : this.filterView.keySet()) {
            attributes.add(new StdPIPRequest(this.filterView.get(key)));
        }
    }

    @Override
    public void attributesProvided(Collection<PIPRequest> attributes) {
        for (String key : this.filterParameters.keySet()) {
            PIPRequest attribute = this.filterParameters.get(key);
            attributes.add(new StdPIPRequest(attribute.getCategory(), attribute.getAttributeId(), attribute.getDataTypeId(), attribute.getIssuer() != null ? attribute.getIssuer() : this.defaultIssuer));
        }
    }

    static {
        try {
            dataTypeFactory = DataTypeFactory.newInstance();
        }
        catch (FactoryException fx) {
            throw new RuntimeException(fx);
        }
        Velocity.setProperty((String)"runtime.log.logsystem.log4j.logger", (Object)"MAIN_LOG");
        Velocity.init();
    }

    private class VelocityParameterWriter
    extends VelocityParameterHandler {
        private PIPFinder finder;
        private Map<String, PIPRequest> parameters;

        public VelocityParameterWriter(PIPFinder finder, Map<String, PIPRequest> parameters) {
            this.finder = finder;
            this.parameters = parameters;
        }

        @Override
        public Object referenceInsert(String theReference, Object theValue) {
            String param = (String)super.referenceInsert(theReference, theValue);
            try {
                PIPRequest request = this.parameters.get(param);
                if (ConfigurableLDAPResolver.this.logger.isTraceEnabled()) {
                    ConfigurableLDAPResolver.this.logger.trace((Object)("(" + ConfigurableLDAPResolver.this.id + ") " + "Velocity parameter: " + param + " requests " + request));
                }
                if (null == request) {
                    throw new RuntimeException("Parameter '" + param + "' is not available");
                }
                Object val = ConfigurableLDAPResolver.this.evaluatePIPRequest(request, this.finder);
                if (null != val) {
                    return val;
                }
                if (param.startsWith("_")) {
                    return "*";
                }
                return null;
            }
            catch (PIPException pipx) {
                throw new RuntimeException(pipx);
            }
        }
    }

    private class VelocityParameterReader
    extends VelocityParameterHandler {
        private Set<String> parameters;

        private VelocityParameterReader() {
            this.parameters = new HashSet<String>();
        }

        @Override
        public Object referenceInsert(String theReference, Object theValue) {
            String param = (String)super.referenceInsert(theReference, theValue);
            this.parameters.add(param);
            return "";
        }
    }

    private class VelocityParameterHandler
    implements ReferenceInsertionEventHandler {
        private Pattern vpp = Pattern.compile("\\{(\\w)+\\}");

        private VelocityParameterHandler() {
        }

        public Object referenceInsert(String theReference, Object theValue) {
            Matcher vvm = this.vpp.matcher(theReference);
            String param = null;
            if (vvm.find()) {
                String vv = vvm.group();
                param = vv.substring(1, vv.length() - 1);
            } else {
                param = "";
            }
            if (ConfigurableLDAPResolver.this.logger.isTraceEnabled()) {
                ConfigurableLDAPResolver.this.logger.trace((Object)("(" + ConfigurableLDAPResolver.this.id + ") " + "Velocity parameter: " + param));
            }
            return param;
        }
    }
}

