/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.finders;

import java.util.Collection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.std.pip.engines.ConfigurableEngine;
import org.apache.openaz.xacml.std.pip.finders.EngineFinder;
import org.apache.openaz.xacml.util.AttributeUtils;

public class ConfigurableEngineFinder
extends EngineFinder {
    private static final String PROP_PIP_ENGINES = "xacml.pip.engines";
    private static final String CLASSNAME = ".classname";
    private Log logger = LogFactory.getLog(this.getClass());

    protected ConfigurableEngine newEngine(String className) throws PIPException {
        Class<?> classForEngine = null;
        try {
            classForEngine = Class.forName(className);
            if (!ConfigurableEngine.class.isAssignableFrom(classForEngine)) {
                throw new ClassNotFoundException("Engine class \"" + className + "\" does not implement ConfigurableEngine");
            }
            return (ConfigurableEngine)ConfigurableEngine.class.cast(classForEngine.newInstance());
        }
        catch (Exception ex) {
            throw new PIPException("Exception getting Class for \"" + className + "\"" + ex.getLocalizedMessage());
        }
    }

    protected void configureEngine(String engineId, Properties properties) throws PIPException {
        String engineClassName = properties.getProperty(engineId + CLASSNAME);
        if (engineClassName == null) {
            throw new PIPException("No .classname property for PIP engine \"" + engineId + "\"");
        }
        ConfigurableEngine configurableEngine = this.newEngine(engineClassName);
        configurableEngine.configure(engineId, properties);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Engine " + engineId + " Provides: "));
            Collection<PIPRequest> attributes = configurableEngine.attributesProvided();
            for (PIPRequest attribute : attributes) {
                this.logger.debug((Object)(System.lineSeparator() + AttributeUtils.prettyPrint(attribute)));
            }
            this.logger.debug((Object)("Engine " + engineId + " Requires: "));
            attributes = configurableEngine.attributesRequired();
            for (PIPRequest attribute : attributes) {
                this.logger.debug((Object)(System.lineSeparator() + AttributeUtils.prettyPrint(attribute)));
            }
        }
        this.register(configurableEngine);
    }

    public void configure(Properties properties) throws PIPException {
        String engineIds = properties.getProperty(PROP_PIP_ENGINES);
        if (engineIds == null || engineIds.length() == 0) {
            return;
        }
        String[] engineIdArray = engineIds.split("[,]", 0);
        if (engineIdArray == null || engineIdArray.length == 0) {
            return;
        }
        for (String engineId : engineIdArray) {
            try {
                this.configureEngine(engineId, properties);
            }
            catch (PIPException ex) {
                this.logger.error((Object)("Exception configuring engine with id \"" + engineId + "\""), (Throwable)ex);
            }
        }
    }
}

