/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.std.pip.finders;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openaz.xacml.api.Status;
import org.apache.openaz.xacml.api.pip.PIPEngine;
import org.apache.openaz.xacml.api.pip.PIPException;
import org.apache.openaz.xacml.api.pip.PIPFinder;
import org.apache.openaz.xacml.api.pip.PIPRequest;
import org.apache.openaz.xacml.api.pip.PIPResponse;
import org.apache.openaz.xacml.std.StdStatus;
import org.apache.openaz.xacml.std.StdStatusCode;
import org.apache.openaz.xacml.std.pip.StdMutablePIPResponse;
import org.apache.openaz.xacml.std.pip.StdPIPResponse;

public class EngineFinder
implements PIPFinder {
    private Map<String, List<PIPEngine>> pipEngines = new HashMap<String, List<PIPEngine>>();

    public void register(PIPEngine pipEngine) {
        if (pipEngine != null) {
            List<PIPEngine> pipEnginesForName = this.pipEngines.get(pipEngine.getName());
            if (pipEnginesForName == null) {
                pipEnginesForName = new ArrayList<PIPEngine>();
                this.pipEngines.put(pipEngine.getName(), pipEnginesForName);
            }
            pipEnginesForName.add(pipEngine);
        }
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPEngine exclude, PIPFinder pipFinderParent) throws PIPException {
        StdMutablePIPResponse pipResponse = new StdMutablePIPResponse();
        Status firstErrorStatus = null;
        for (List<PIPEngine> listPIPEngines : this.pipEngines.values()) {
            for (PIPEngine pipEngine : listPIPEngines) {
                if (pipEngine == exclude) continue;
                PIPResponse pipResponseEngine = null;
                try {
                    pipResponseEngine = pipEngine.getAttributes(pipRequest, pipFinderParent);
                }
                catch (Exception e) {
                    pipResponseEngine = new StdPIPResponse(new StdStatus(StdStatusCode.STATUS_CODE_PROCESSING_ERROR));
                }
                if (pipResponseEngine == null) continue;
                if (pipResponseEngine.getStatus() == null || pipResponseEngine.getStatus().isOk()) {
                    pipResponse.addAttributes(pipResponseEngine.getAttributes());
                    continue;
                }
                if (firstErrorStatus != null) continue;
                firstErrorStatus = pipResponseEngine.getStatus();
            }
        }
        if (pipResponse.getAttributes().size() == 0 && firstErrorStatus != null) {
            pipResponse.setStatus(firstErrorStatus);
        }
        return new StdPIPResponse(pipResponse);
    }

    @Override
    public PIPResponse getMatchingAttributes(PIPRequest pipRequest, PIPEngine exclude, PIPFinder pipFinderParent) throws PIPException {
        return StdPIPResponse.getMatchingResponse(pipRequest, this.getAttributes(pipRequest, exclude, pipFinderParent));
    }

    @Override
    public PIPResponse getAttributes(PIPRequest pipRequest, PIPEngine exclude) throws PIPException {
        return this.getAttributes(pipRequest, exclude, this);
    }

    @Override
    public PIPResponse getMatchingAttributes(PIPRequest pipRequest, PIPEngine exclude) throws PIPException {
        return StdPIPResponse.getMatchingResponse(pipRequest, this.getAttributes(pipRequest, exclude));
    }

    @Override
    public Collection<PIPEngine> getPIPEngines() {
        ArrayList<PIPEngine> engines = new ArrayList<PIPEngine>();
        for (List<PIPEngine> list : this.pipEngines.values()) {
            for (PIPEngine engine : list) {
                engines.add(engine);
            }
        }
        return Collections.unmodifiableList(engines);
    }
}

