/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AdviceExpressionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AdviceExpressionsType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AllOfType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AnyOfType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeAssignmentExpressionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeDesignatorType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeSelectorType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.AttributeValueType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ConditionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.IdReferenceType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.MatchType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ObligationExpressionType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ObligationExpressionsType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySetType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicyType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.RuleType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.TargetType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.VariableDefinitionType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.openaz.xacml.api.Advice;
import org.apache.openaz.xacml.api.Attribute;
import org.apache.openaz.xacml.api.Identifier;
import org.apache.openaz.xacml.api.Obligation;
import org.apache.openaz.xacml.std.IdentifierImpl;
import org.apache.openaz.xacml.std.StdAttribute;
import org.apache.openaz.xacml.std.StdAttributeAssignment;
import org.apache.openaz.xacml.std.StdAttributeValue;
import org.apache.openaz.xacml.std.StdMutableAdvice;
import org.apache.openaz.xacml.std.StdMutableObligation;
import org.apache.openaz.xacml.std.dom.DOMUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XACMLPolicyScanner {
    private static final Log logger = LogFactory.getLog(XACMLPolicyScanner.class);
    private Object policyObject = null;
    private Callback callback = null;

    public XACMLPolicyScanner(Path filename, Callback callback) {
        try (InputStream is = Files.newInputStream(filename, new OpenOption[0]);){
            this.policyObject = XACMLPolicyScanner.readPolicy(is);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read policy", (Throwable)e);
        }
        this.callback = callback;
    }

    public XACMLPolicyScanner(PolicySetType policySet, Callback callback) {
        this.policyObject = policySet;
        this.callback = callback;
    }

    public XACMLPolicyScanner(PolicySetType policySet) {
        this(policySet, null);
    }

    public XACMLPolicyScanner(PolicyType policy, Callback callback) {
        this.policyObject = policy;
        this.callback = callback;
    }

    public XACMLPolicyScanner(PolicyType policy) {
        this(policy, null);
    }

    public void setCallback(Callback cb) {
        this.callback = cb;
    }

    public Object scan(Callback cb) {
        this.callback = cb;
        return this.scan();
    }

    public Object scan() {
        if (this.policyObject == null) {
            return null;
        }
        if (this.callback != null && this.callback.onBeginScan(this.policyObject) == CallbackResult.STOP) {
            return this.policyObject;
        }
        if (this.policyObject instanceof PolicyType) {
            this.scanPolicy(null, (PolicyType)this.policyObject);
        } else if (this.policyObject instanceof PolicySetType) {
            this.scanPolicySet(null, (PolicySetType)this.policyObject);
        } else {
            logger.error((Object)("Unknown class type: " + this.policyObject.getClass().getCanonicalName()));
        }
        if (this.callback != null) {
            this.callback.onFinishScan(this.policyObject);
        }
        return this.policyObject;
    }

    protected CallbackResult scanPolicySet(PolicySetType parent, PolicySetType policySet) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scanning policy set: " + policySet.getPolicySetId() + " " + policySet.getDescription()));
        }
        if (this.callback != null && this.callback.onPreVisitPolicySet(parent, policySet) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanTarget(policySet, policySet.getTarget()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanObligations(policySet, policySet.getObligationExpressions()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanAdvice(policySet, policySet.getAdviceExpressions()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        List<JAXBElement<?>> list = policySet.getPolicySetOrPolicyOrPolicySetIdReference();
        for (JAXBElement<?> element : list) {
            if (element.getName().getLocalPart().equals("PolicySet")) {
                if (this.scanPolicySet(policySet, (PolicySetType)element.getValue()) != CallbackResult.STOP) continue;
                return CallbackResult.STOP;
            }
            if (element.getName().getLocalPart().equals("Policy")) {
                if (this.scanPolicy(policySet, (PolicyType)element.getValue()) != CallbackResult.STOP) continue;
                return CallbackResult.STOP;
            }
            if (element.getValue() instanceof IdReferenceType) continue;
            logger.warn((Object)("generating policy sets found unsupported element: " + element.getName().getNamespaceURI()));
        }
        if (this.callback != null && this.callback.onPostVisitPolicySet(parent, policySet) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        return CallbackResult.CONTINUE;
    }

    protected CallbackResult scanPolicy(PolicySetType parent, PolicyType policy) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("scanning policy: " + policy.getPolicyId() + " " + policy.getDescription()));
        }
        if (this.callback != null && this.callback.onPreVisitPolicy(parent, policy) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanTarget(policy, policy.getTarget()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanVariables(policy, policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanObligations(policy, policy.getObligationExpressions()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        if (this.scanAdvice(policy, policy.getAdviceExpressions()) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        List<Object> list = policy.getCombinerParametersOrRuleCombinerParametersOrVariableDefinition();
        for (Object o : list) {
            if (o instanceof RuleType) {
                RuleType rule = (RuleType)o;
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("scanning rule: " + rule.getRuleId() + " " + rule.getDescription()));
                }
                if (this.callback != null && this.callback.onPreVisitRule(policy, rule) == CallbackResult.STOP) {
                    return CallbackResult.STOP;
                }
                if (this.scanTarget(rule, rule.getTarget()) == CallbackResult.STOP) {
                    return CallbackResult.STOP;
                }
                if (this.scanConditions(rule, rule.getCondition()) == CallbackResult.STOP) {
                    return CallbackResult.STOP;
                }
                if (this.scanObligations(rule, rule.getObligationExpressions()) == CallbackResult.STOP) {
                    return CallbackResult.STOP;
                }
                if (this.scanAdvice(rule, rule.getAdviceExpressions()) == CallbackResult.STOP) {
                    return CallbackResult.STOP;
                }
                if (this.callback == null || this.callback.onPostVisitRule(policy, rule) != CallbackResult.STOP) continue;
                return CallbackResult.STOP;
            }
            if (o instanceof VariableDefinitionType) {
                if (this.callback == null || this.callback.onVariable(policy, (VariableDefinitionType)o) != CallbackResult.STOP) continue;
                return CallbackResult.STOP;
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("scanning policy rules found unsupported object:" + o.toString()));
        }
        if (this.callback != null && this.callback.onPostVisitPolicy(parent, policy) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        return CallbackResult.CONTINUE;
    }

    protected CallbackResult scanTarget(Object parent, TargetType target) {
        if (target == null) {
            return CallbackResult.CONTINUE;
        }
        List<AnyOfType> anyOfList = target.getAnyOf();
        if (anyOfList != null) {
            for (AnyOfType anyOf : anyOfList) {
                List<AllOfType> allOfList = anyOf.getAllOf();
                if (allOfList == null) continue;
                for (AllOfType allOf : allOfList) {
                    List<MatchType> matchList = allOf.getMatch();
                    if (matchList == null) continue;
                    for (MatchType match : matchList) {
                        StdAttribute attribute = null;
                        AttributeValueType value = match.getAttributeValue();
                        if (match.getAttributeDesignator() != null && value != null) {
                            AttributeDesignatorType designator = match.getAttributeDesignator();
                            attribute = new StdAttribute((Identifier)new IdentifierImpl(designator.getCategory()), (Identifier)new IdentifierImpl(designator.getAttributeId()), new StdAttributeValue<List<Object>>(new IdentifierImpl(value.getDataType()), value.getContent()), designator.getIssuer(), false);
                        } else if (match.getAttributeSelector() != null && value != null) {
                            AttributeSelectorType selector = match.getAttributeSelector();
                            attribute = new StdAttribute((Identifier)new IdentifierImpl(selector.getCategory()), (Identifier)new IdentifierImpl(selector.getContextSelectorId()), new StdAttributeValue<List<Object>>(new IdentifierImpl(value.getDataType()), value.getContent()), null, false);
                        } else {
                            logger.warn((Object)"NULL designator/selector or value for match.");
                        }
                        if (attribute == null || this.callback == null || this.callback.onAttribute(parent, target, attribute) != CallbackResult.STOP) continue;
                        return CallbackResult.STOP;
                    }
                }
            }
        }
        return CallbackResult.CONTINUE;
    }

    protected CallbackResult scanObligations(Object parent, ObligationExpressionsType obligationExpressionsType) {
        if (obligationExpressionsType == null) {
            return CallbackResult.CONTINUE;
        }
        List<ObligationExpressionType> expressions = obligationExpressionsType.getObligationExpression();
        if (expressions == null || expressions.size() == 0) {
            return CallbackResult.CONTINUE;
        }
        for (ObligationExpressionType expression : expressions) {
            StdMutableObligation ob = new StdMutableObligation(new IdentifierImpl(expression.getObligationId()));
            List<AttributeAssignmentExpressionType> assignments = expression.getAttributeAssignmentExpression();
            if (assignments != null) {
                for (AttributeAssignmentExpressionType assignment : assignments) {
                    IdentifierImpl categoryId = null;
                    if (assignment.getCategory() != null) {
                        categoryId = new IdentifierImpl(assignment.getCategory());
                    }
                    StdAttributeAssignment attribute = new StdAttributeAssignment(categoryId, new IdentifierImpl(assignment.getAttributeId()), assignment.getIssuer(), new StdAttributeValue<Object>(null, null));
                    ob.addAttributeAssignment(attribute);
                }
            }
            if (this.callback == null || this.callback.onObligation(parent, expression, ob) != CallbackResult.STOP) continue;
            return CallbackResult.STOP;
        }
        return CallbackResult.CONTINUE;
    }

    protected CallbackResult scanAdvice(Object parent, AdviceExpressionsType adviceExpressionstype) {
        if (adviceExpressionstype == null) {
            return CallbackResult.CONTINUE;
        }
        List<AdviceExpressionType> expressions = adviceExpressionstype.getAdviceExpression();
        if (expressions == null || expressions.size() == 0) {
            return CallbackResult.CONTINUE;
        }
        for (AdviceExpressionType expression : expressions) {
            StdMutableAdvice ob = new StdMutableAdvice(new IdentifierImpl(expression.getAdviceId()));
            List<AttributeAssignmentExpressionType> assignments = expression.getAttributeAssignmentExpression();
            if (assignments != null) {
                for (AttributeAssignmentExpressionType assignment : assignments) {
                    IdentifierImpl categoryId = null;
                    if (assignment.getCategory() != null) {
                        categoryId = new IdentifierImpl(assignment.getCategory());
                    }
                    StdAttributeAssignment attribute = new StdAttributeAssignment(categoryId, new IdentifierImpl(assignment.getAttributeId()), assignment.getIssuer(), new StdAttributeValue<Object>(null, null));
                    ob.addAttributeAssignment(attribute);
                }
            }
            if (this.callback == null || this.callback.onAdvice(parent, expression, ob) != CallbackResult.STOP) continue;
            return CallbackResult.STOP;
        }
        return CallbackResult.CONTINUE;
    }

    protected CallbackResult scanVariables(PolicyType policy, List<Object> list) {
        if (list == null) {
            return CallbackResult.CONTINUE;
        }
        for (Object o : list) {
            if (!(o instanceof VariableDefinitionType) || this.callback == null || this.callback.onVariable(policy, (VariableDefinitionType)o) != CallbackResult.STOP) continue;
            return CallbackResult.STOP;
        }
        return CallbackResult.CONTINUE;
    }

    protected CallbackResult scanConditions(RuleType rule, ConditionType condition) {
        if (condition != null && this.callback != null && this.callback.onCondition(rule, condition) == CallbackResult.STOP) {
            return CallbackResult.STOP;
        }
        return CallbackResult.CONTINUE;
    }

    public static String getVersion(Path policy) throws IOException {
        Object data = null;
        try (InputStream is = Files.newInputStream(policy, new OpenOption[0]);){
            data = XACMLPolicyScanner.readPolicy(is);
        }
        catch (IOException e) {
            logger.error((Object)"Failed to read policy", (Throwable)e);
            throw e;
        }
        if (data == null) {
            logger.warn((Object)"Version is null.");
            return null;
        }
        return XACMLPolicyScanner.getVersion(data);
    }

    public static String getVersion(Object data) {
        String version = null;
        try {
            if (data instanceof PolicySetType) {
                version = ((PolicySetType)data).getVersion();
            } else if (data instanceof PolicyType) {
                version = ((PolicyType)data).getVersion();
            } else {
                if (data != null) {
                    logger.error((Object)("Expecting a PolicySet/Policy/Rule object. Got: " + data.getClass().getCanonicalName()));
                }
                return null;
            }
            if (version != null && version.length() > 0) {
                return version;
            }
            logger.warn((Object)"No version set in policy");
        }
        catch (NumberFormatException e) {
            logger.error((Object)("Invalid version contained in policy: " + version));
            return null;
        }
        return null;
    }

    public static String getID(Object data) {
        if (data instanceof PolicySetType) {
            return ((PolicySetType)data).getPolicySetId();
        }
        if (data instanceof PolicyType) {
            return ((PolicyType)data).getPolicyId();
        }
        logger.error((Object)("Expecting a PolicySet/Policy/Rule object. Got: " + data.getClass().getCanonicalName()));
        return null;
    }

    public static Object readPolicy(InputStream is) {
        try {
            DocumentBuilder db = DOMUtil.getDocumentBuilder();
            Document doc = db.parse(is);
            NodeList nodes = doc.getChildNodes();
            Node node = nodes.item(0);
            Element e = null;
            if (node.getNodeType() == 1) {
                e = (Element)node;
                if (e.getNamespaceURI().equals("urn:oasis:names:tc:xacml:3.0:core:schema:wd-17")) {
                    if (e.getNodeName().endsWith("Policy")) {
                        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PolicyType.class});
                        Unmarshaller um = context.createUnmarshaller();
                        JAXBElement root = um.unmarshal((Node)e, PolicyType.class);
                        return root.getValue();
                    }
                    if (e.getNodeName().endsWith("PolicySet")) {
                        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PolicySetType.class});
                        Unmarshaller um = context.createUnmarshaller();
                        JAXBElement root = um.unmarshal((Node)e, PolicySetType.class);
                        return root.getValue();
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Not supported yet: " + e.getNodeName()));
                    }
                } else {
                    logger.warn((Object)("unsupported namespace: " + e.getNamespaceURI()));
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)("No root element contained in policy  Name: " + node.getNodeName() + " type: " + node.getNodeType() + " Value: " + node.getNodeValue()));
            }
        }
        catch (Exception e) {
            logger.error((Object)e.getMessage());
        }
        return null;
    }

    public static class SimpleCallback
    implements Callback {
        @Override
        public CallbackResult onBeginScan(Object root) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public void onFinishScan(Object root) {
        }

        @Override
        public CallbackResult onPreVisitPolicySet(PolicySetType parent, PolicySetType policySet) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPostVisitPolicySet(PolicySetType parent, PolicySetType policySet) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPreVisitPolicy(PolicySetType parent, PolicyType policy) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPostVisitPolicy(PolicySetType parent, PolicyType policy) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPreVisitRule(PolicyType parent, RuleType rule) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPostVisitRule(PolicyType parent, RuleType rule) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onAttribute(Object parent, Object container, Attribute attribute) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onObligation(Object parent, ObligationExpressionType expression, Obligation obligation) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onAdvice(Object parent, AdviceExpressionType expression, Advice advice) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onVariable(PolicyType policy, VariableDefinitionType o) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onCondition(RuleType rule, ConditionType condition) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPolicySetIdReference(IdReferenceType reference, PolicySetType parent) {
            return CallbackResult.CONTINUE;
        }

        @Override
        public CallbackResult onPolicyIdReference(IdReferenceType reference, PolicySetType parent) {
            return CallbackResult.CONTINUE;
        }
    }

    public static interface Callback {
        public CallbackResult onBeginScan(Object var1);

        public void onFinishScan(Object var1);

        public CallbackResult onPreVisitPolicySet(PolicySetType var1, PolicySetType var2);

        public CallbackResult onPostVisitPolicySet(PolicySetType var1, PolicySetType var2);

        public CallbackResult onPreVisitPolicy(PolicySetType var1, PolicyType var2);

        public CallbackResult onPostVisitPolicy(PolicySetType var1, PolicyType var2);

        public CallbackResult onPreVisitRule(PolicyType var1, RuleType var2);

        public CallbackResult onPostVisitRule(PolicyType var1, RuleType var2);

        public CallbackResult onAttribute(Object var1, Object var2, Attribute var3);

        public CallbackResult onObligation(Object var1, ObligationExpressionType var2, Obligation var3);

        public CallbackResult onAdvice(Object var1, AdviceExpressionType var2, Advice var3);

        public CallbackResult onVariable(PolicyType var1, VariableDefinitionType var2);

        public CallbackResult onCondition(RuleType var1, ConditionType var2);

        public CallbackResult onPolicySetIdReference(IdReferenceType var1, PolicySetType var2);

        public CallbackResult onPolicyIdReference(IdReferenceType var1, PolicySetType var2);
    }

    public static enum CallbackResult {
        CONTINUE,
        STOP;

    }
}

