/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openaz.xacml.util;

import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.ObjectFactory;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicySetType;
import oasis.names.tc.xacml._3_0.core.schema.wd_17.PolicyType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XACMLPolicyWriter {
    private static final Log logger = LogFactory.getLog(XACMLPolicyWriter.class);

    public static Path writePolicyFile(Path filename, PolicySetType policySet) {
        JAXBElement<PolicySetType> policySetElement = new ObjectFactory().createPolicySet(policySet);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PolicySetType.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(policySetElement, filename.toFile());
            if (Files.exists(filename, new LinkOption[0])) {
                return filename;
            }
            logger.error((Object)"File does not exist after marshalling.");
            return null;
        }
        catch (JAXBException e) {
            logger.error((Object)("writePolicyFile failed: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public static void writePolicyFile(OutputStream os, PolicySetType policySet) {
        JAXBElement<PolicySetType> policySetElement = new ObjectFactory().createPolicySet(policySet);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PolicySetType.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(policySetElement, os);
        }
        catch (JAXBException e) {
            logger.error((Object)("writePolicyFile failed: " + e.getLocalizedMessage()));
        }
    }

    public static Path writePolicyFile(Path filename, PolicyType policy) {
        JAXBElement<PolicyType> policyElement = new ObjectFactory().createPolicy(policy);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PolicyType.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(policyElement, filename.toFile());
            if (Files.exists(filename, new LinkOption[0])) {
                return filename;
            }
            logger.error((Object)"File does not exist after marshalling.");
            return null;
        }
        catch (JAXBException e) {
            logger.error((Object)("writePolicyFile failed: " + e.getLocalizedMessage()));
            return null;
        }
    }

    public static void writePolicyFile(OutputStream os, PolicyType policy) {
        JAXBElement<PolicyType> policySetElement = new ObjectFactory().createPolicy(policy);
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{PolicyType.class});
            Marshaller m = context.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.marshal(policySetElement, os);
        }
        catch (JAXBException e) {
            logger.error((Object)("writePolicyFile failed: " + e.getLocalizedMessage()));
        }
    }
}

