/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.plugin;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.maven.plugin.AbstractDeployMojo;
import org.apache.openejb.maven.plugin.TomEEException;

@Mojo(name="undeploy")
public class UnDeployMojo
extends AbstractDeployMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        Deployer deployer = (Deployer)this.lookup("openejb/DeployerBusinessRemote");
        try {
            Collection apps = deployer.getDeployedApps();
            ArrayList<String> paths = new ArrayList<String>(apps.size());
            for (AppInfo info : apps) {
                paths.add(info.path);
            }
            if (paths.contains(this.path)) {
                deployer.undeploy(this.path);
            } else {
                for (String proposed : paths) {
                    if (!this.path.equals(proposed + ".war") && !this.path.equals(proposed + ".ear") && !this.path.equals(proposed + ".jar")) continue;
                    deployer.undeploy(proposed);
                    return;
                }
                for (String proposed : paths) {
                    if (!proposed.endsWith("/" + this.path) && !proposed.endsWith("\\" + this.path)) continue;
                    deployer.undeploy(proposed);
                    return;
                }
            }
        }
        catch (OpenEJBException e) {
            throw new TomEEException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

