/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.client.Connection;
import org.apache.openejb.client.ConnectionFactory;
import org.apache.openejb.client.ConnectionManager;
import org.apache.openejb.client.MulticastSearch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastConnectionFactory
implements ConnectionFactory {
    private final Set<String> defaultSchemes = new HashSet<String>();
    String defaultGroup;
    private int defaultTimeout;

    public MulticastConnectionFactory() {
        this.defaultSchemes.add("ejbd");
        this.defaultSchemes.add("ejbds");
        this.defaultSchemes.add("http");
        this.defaultSchemes.add("https");
        this.defaultGroup = "default";
        this.defaultTimeout = 5000;
    }

    @Override
    public Connection getConnection(URI uri) throws IOException {
        Map<String, String> params = null;
        try {
            params = URIs.parseParamters(uri);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid multicast uri " + uri.toString(), e);
        }
        Set<String> schemes = MulticastConnectionFactory.getSet(params, "schemes", this.defaultSchemes);
        String group = MulticastConnectionFactory.getString(params, "group", this.defaultGroup);
        long timeout = MulticastConnectionFactory.getLong(params, "timeout", this.defaultTimeout);
        MulticastSearch search = new MulticastSearch(uri.getHost(), uri.getPort());
        URI serviceURI = search.search(new Filter(group, schemes), timeout, TimeUnit.MILLISECONDS);
        if (serviceURI == null) {
            throw new IllegalArgumentException("Unable to find an ejb server via the multicast URI: " + uri);
        }
        try {
            serviceURI = MulticastConnectionFactory.unwrap(serviceURI);
            serviceURI = MulticastConnectionFactory.unwrap(serviceURI);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid ejb service uri " + serviceURI.toString(), e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid ejb service uri " + serviceURI.toString(), e);
        }
        return ConnectionManager.getConnection(serviceURI);
    }

    public static String getString(Map<String, String> params, String param, String defaultValue) {
        String value = params.get(param);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public static long getLong(Map<String, String> params, String param, long defaultValue) {
        String value = params.get(param);
        if (value == null) {
            return defaultValue;
        }
        return new Long(value);
    }

    public static Set<String> getSet(Map<String, String> params, String param, Set<String> defaultSet) {
        LinkedHashSet<String> set = new LinkedHashSet();
        if (params.containsKey(param)) {
            String value = params.get(param);
            if (value != null) {
                String[] strings;
                for (String s : strings = value.split(",")) {
                    set.add(s);
                }
            }
        } else {
            set = defaultSet;
        }
        return set;
    }

    private static URI unwrap(URI uri) throws URISyntaxException {
        return new URI(uri.getSchemeSpecificPart());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Filter
    implements MulticastSearch.Filter {
        private final Set<String> schemes;
        private final String group;

        public Filter(String group, Set<String> schemes) {
            this.group = group;
            this.schemes = schemes;
        }

        @Override
        public boolean accept(URI service) {
            try {
                if (!this.group.equals(service.getScheme())) {
                    return false;
                }
                if (!"ejb".equals((service = MulticastConnectionFactory.unwrap(service)).getScheme())) {
                    return false;
                }
                if (this.schemes.contains((service = MulticastConnectionFactory.unwrap(service)).getScheme())) {
                    return true;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class URIs {
        public static Map<String, String> parseQuery(String uri) throws URISyntaxException {
            try {
                LinkedHashMap<String, String> rc = new LinkedHashMap<String, String>();
                if (uri != null) {
                    String[] parameters = uri.split("&");
                    for (int i = 0; i < parameters.length; ++i) {
                        int p = parameters[i].indexOf("=");
                        if (p >= 0) {
                            String name = URLDecoder.decode(parameters[i].substring(0, p), "UTF-8");
                            String value = URLDecoder.decode(parameters[i].substring(p + 1), "UTF-8");
                            rc.put(name, value);
                            continue;
                        }
                        rc.put(parameters[i], null);
                    }
                }
                return rc;
            }
            catch (UnsupportedEncodingException e) {
                throw (URISyntaxException)new URISyntaxException(e.toString(), "Invalid encoding").initCause(e);
            }
        }

        public static Map<String, String> parseParamters(URI uri) throws URISyntaxException {
            return uri.getQuery() == null ? Collections.EMPTY_MAP : URIs.parseQuery(URIs.stripPrefix(uri.getQuery(), "?"));
        }

        public static String stripPrefix(String value, String prefix) {
            if (value.startsWith(prefix)) {
                return value.substring(prefix.length());
            }
            return value;
        }
    }
}

