/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.net.URI;
import javax.naming.Context;
import javax.naming.NamingException;
import org.apache.openejb.client.ServiceLocator;

public class GenericServiceLocator
extends ServiceLocator {
    private final String commonPrefix;

    public GenericServiceLocator(URI serverUri, String commonPrefix) throws NamingException {
        super(serverUri);
        this.commonPrefix = commonPrefix;
    }

    public GenericServiceLocator(URI serverUri, String username, String password, String commonPrefix) throws NamingException {
        super(serverUri, username, password);
        this.commonPrefix = commonPrefix;
    }

    public GenericServiceLocator(URI serverUri, String username, String password, String realm, String commonPrefix) throws NamingException {
        super(serverUri, username, password, realm);
        this.commonPrefix = commonPrefix;
    }

    public GenericServiceLocator(Context context, String commonPrefix) {
        super(context);
        this.commonPrefix = commonPrefix;
    }

    @Override
    public Object lookup(String name) {
        if (this.commonPrefix != null) {
            name = this.commonPrefix + "/" + name;
        }
        return super.lookup(name);
    }

    public <T> T lookup(Class<T> type) {
        return (T)this.lookup(type.getName());
    }

    public <T> T lookup(String prefix, Class<T> type) {
        return (T)this.lookup(prefix + "/" + type.getName());
    }

    public <T, B> T lookup(Class<T> type, Class<B> ejbClass) {
        return (T)this.lookup(type.getName() + "/" + ejbClass.getName());
    }
}

